/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelParameter;
import org.java.plugin.registry.xml.ParameterValueParser;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExtensionImpl
extends PluginElementImpl<Extension>
implements Extension {
    private final ModelExtension model;
    private List<Extension.Parameter> parameters;
    private Boolean isValid;

    ExtensionImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelExtension modelExtension) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelExtension.getId(), modelExtension.getDocumentation());
        this.model = modelExtension;
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extensionIdIsBlank", pluginDescriptorImpl.getId());
        }
        if (this.model.getPointId() == null || this.model.getPointId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extendedPointIdIsBlank", pluginDescriptorImpl.getId());
        }
        this.parameters = new ArrayList<Extension.Parameter>(this.model.getParams().size());
        for (ModelParameter modelParameter : this.model.getParams()) {
            this.parameters.add(new ParameterImpl(null, modelParameter));
        }
        this.parameters = Collections.unmodifiableList(this.parameters);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    @Override
    public Collection<Extension.Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Extension.Parameter getParameter(String string) {
        ParameterImpl parameterImpl = null;
        for (Extension.Parameter parameter : this.parameters) {
            ParameterImpl parameterImpl2 = (ParameterImpl)parameter;
            if (!parameterImpl2.getId().equals(string)) continue;
            if (parameterImpl == null) {
                parameterImpl = parameterImpl2;
                continue;
            }
            throw new IllegalArgumentException("more than one parameter with ID " + string + " defined in extension " + this.getUniqueId());
        }
        return parameterImpl;
    }

    @Override
    public Collection<Extension.Parameter> getParameters(String string) {
        LinkedList<Extension.Parameter> linkedList = new LinkedList<Extension.Parameter>();
        for (Extension.Parameter parameter : this.parameters) {
            if (!parameter.getId().equals(string)) continue;
            linkedList.add(parameter);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public String getExtendedPluginId() {
        return this.model.getPluginId();
    }

    @Override
    public String getExtendedPointId() {
        return this.model.getPointId();
    }

    @Override
    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection<IntegrityCheckReport.ReportItem> validate() {
        ExtensionPoint extensionPoint = this.getExtensionPoint(this.getExtendedPluginId(), this.getExtendedPointId());
        if (extensionPoint == null) {
            this.isValid = Boolean.FALSE;
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "extPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getExtendedPluginId(), this.getExtendedPointId()), this.getUniqueId()}));
        }
        Collection<IntegrityCheckReport.ReportItem> collection = this.validateParameters(extensionPoint.getParameterDefinitions(), this.parameters);
        this.isValid = collection.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        return collection;
    }

    ExtensionPoint getExtensionPoint(String string) {
        PluginRegistry pluginRegistry = this.getDeclaringPluginDescriptor().getRegistry();
        return this.getExtensionPoint(pluginRegistry.extractPluginId(string), pluginRegistry.extractId(string));
    }

    ExtensionPoint getExtensionPoint(String string, String string2) {
        PluginRegistry pluginRegistry = this.getDeclaringPluginDescriptor().getRegistry();
        if (!pluginRegistry.isPluginDescriptorAvailable(string)) {
            return null;
        }
        for (ExtensionPoint extensionPoint : pluginRegistry.getPluginDescriptor(string).getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            return extensionPoint;
        }
        return null;
    }

    private Collection<IntegrityCheckReport.ReportItem> validateParameters(Collection<ExtensionPoint.ParameterDefinition> collection, Collection<Extension.Parameter> collection2) {
        Collection<Extension.Parameter> collection3;
        ExtensionPoint.ParameterDefinition parameterDefinition;
        LinkedList<IntegrityCheckReport.ReportItem> linkedList = new LinkedList<IntegrityCheckReport.ReportItem>();
        HashMap hashMap = new HashMap();
        for (Extension.Parameter object2 : collection2) {
            parameterDefinition = object2.getDefinition();
            if (parameterDefinition == null) {
                linkedList.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "cantDetectParameterDef", new Object[]{object2.getId(), this.getUniqueId()}));
                continue;
            }
            if (hashMap.containsKey(object2.getId())) {
                ((Collection)hashMap.get(object2.getId())).add(object2);
                continue;
            }
            collection3 = new LinkedList<Extension.Parameter>();
            collection3.add(object2);
            hashMap.put(object2.getId(), collection3);
        }
        if (!linkedList.isEmpty()) {
            return linkedList;
        }
        List list = Collections.emptyList();
        Iterator<ExtensionPoint.ParameterDefinition> iterator = collection.iterator();
        while (iterator.hasNext()) {
            collection3 = (Collection)hashMap.get((parameterDefinition = iterator.next()).getId());
            linkedList.addAll(this.validateParameters(parameterDefinition, (Collection<Extension.Parameter>)(collection3 != null ? collection3 : list)));
        }
        return linkedList;
    }

    private Collection<IntegrityCheckReport.ReportItem> validateParameters(ExtensionPoint.ParameterDefinition parameterDefinition, Collection<Extension.Parameter> collection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("validating parameters for definition " + parameterDefinition));
        }
        switch (parameterDefinition.getMultiplicity()) {
            case ONE: {
                if (collection.size() == 1) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "tooManyOrFewParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
            }
            case NONE_OR_ONE: {
                if (collection.size() <= 1) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "tooManyParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
            }
            case ONE_OR_MORE: {
                if (!collection.isEmpty()) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "tooFewParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
            }
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IntegrityCheckReport.ReportItem> linkedList = new LinkedList<IntegrityCheckReport.ReportItem>();
        int n = 1;
        for (Extension.Parameter parameter : collection) {
            ParameterImpl parameterImpl = (ParameterImpl)parameter;
            if (!parameterImpl.isValid()) {
                linkedList.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "invalidParameterValue", new Object[]{parameterDefinition.getId(), n, this.getUniqueId()}));
            }
            if (ParameterType.ANY != parameterDefinition.getType() && linkedList.isEmpty()) {
                linkedList.addAll(this.validateParameters(parameterImpl.getDefinition().getSubDefinitions(), parameterImpl.getSubParameters()));
            }
            ++n;
        }
        return linkedList;
    }

    public String toString() {
        return "{PluginExtension: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterImpl
    extends PluginElementImpl<Extension.Parameter>
    implements Extension.Parameter {
        private final ModelParameter modelParam;
        private ParameterValueParser valueParser;
        private List<Extension.Parameter> subParameters;
        private ExtensionPoint.ParameterDefinition definition;
        private boolean definitionDetected;
        private final ParameterImpl superParameter;

        ParameterImpl(ParameterImpl parameterImpl, ModelParameter modelParameter) throws ManifestProcessingException {
            super(ExtensionImpl.this.getDeclaringPluginDescriptor(), ExtensionImpl.this.getDeclaringPluginFragment(), modelParameter.getId(), modelParameter.getDocumentation());
            this.definition = null;
            this.definitionDetected = false;
            this.superParameter = parameterImpl;
            this.modelParam = modelParameter;
            this.subParameters = new ArrayList<Extension.Parameter>(this.modelParam.getParams().size());
            for (ModelParameter modelParameter2 : this.modelParam.getParams()) {
                this.subParameters.add(new ParameterImpl(this, modelParameter2));
            }
            this.subParameters = Collections.unmodifiableList(this.subParameters);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("object instantiated: " + this));
            }
        }

        @Override
        public Extension getDeclaringExtension() {
            return ExtensionImpl.this;
        }

        @Override
        public PluginDescriptor getDeclaringPluginDescriptor() {
            return ExtensionImpl.this.getDeclaringPluginDescriptor();
        }

        @Override
        public PluginFragment getDeclaringPluginFragment() {
            return ExtensionImpl.this.getDeclaringPluginFragment();
        }

        @Override
        public ExtensionPoint.ParameterDefinition getDefinition() {
            Collection<ExtensionPoint.ParameterDefinition> collection;
            if (this.definitionDetected) {
                return this.definition;
            }
            this.definitionDetected = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("detecting definition for parameter " + this));
            }
            if (this.superParameter != null) {
                if (this.superParameter.getDefinition() == null) {
                    return null;
                }
                if (ParameterType.ANY == this.superParameter.getDefinition().getType()) {
                    this.definition = this.superParameter.getDefinition();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("definition detected - " + this.definition));
                    }
                    return this.definition;
                }
                collection = this.superParameter.getDefinition().getSubDefinitions();
            } else {
                collection = ExtensionImpl.this.getExtensionPoint(this.getDeclaringExtension().getExtendedPluginId(), this.getDeclaringExtension().getExtendedPointId()).getParameterDefinitions();
            }
            for (ExtensionPoint.ParameterDefinition parameterDefinition : collection) {
                if (!parameterDefinition.getId().equals(this.getId())) continue;
                this.definition = parameterDefinition;
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("definition detected - " + this.definition));
            }
            return this.definition;
        }

        @Override
        public Extension.Parameter getSuperParameter() {
            return this.superParameter;
        }

        @Override
        public Collection<Extension.Parameter> getSubParameters() {
            return this.subParameters;
        }

        @Override
        public Extension.Parameter getSubParameter(String string) {
            ParameterImpl parameterImpl = null;
            for (Extension.Parameter parameter : this.subParameters) {
                ParameterImpl parameterImpl2 = (ParameterImpl)parameter;
                if (!parameterImpl2.getId().equals(string)) continue;
                if (parameterImpl == null) {
                    parameterImpl = parameterImpl2;
                    continue;
                }
                throw new IllegalArgumentException("more than one parameter with ID " + string + " defined in extension " + ExtensionImpl.this.getUniqueId());
            }
            return parameterImpl;
        }

        @Override
        public Collection<Extension.Parameter> getSubParameters(String string) {
            LinkedList<Extension.Parameter> linkedList = new LinkedList<Extension.Parameter>();
            for (Extension.Parameter parameter : this.subParameters) {
                if (!parameter.getId().equals(string)) continue;
                linkedList.add(parameter);
            }
            return Collections.unmodifiableList(linkedList);
        }

        @Override
        public String rawValue() {
            return this.modelParam.getValue() != null ? this.modelParam.getValue() : "";
        }

        boolean isValid() {
            if (this.valueParser != null) {
                return this.valueParser.isParsingSucceeds();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("validating parameter " + this));
            }
            this.valueParser = new ParameterValueParser(this.getDeclaringPluginDescriptor().getRegistry(), this.getDefinition(), this.modelParam.getValue());
            if (!this.valueParser.isParsingSucceeds()) {
                this.log.warn((Object)("parsing value for parameter " + this + " failed, message is: " + this.valueParser.getParsingMessage()));
            }
            return this.valueParser.isParsingSucceeds();
        }

        @Override
        public Boolean valueAsBoolean() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.BOOLEAN != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.BOOLEAN));
            }
            if (this.valueParser.getValue() == null) {
                return (Boolean)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Boolean)this.valueParser.getValue();
        }

        @Override
        public Date valueAsDate() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.DATE != this.definition.getType() && ParameterType.DATE_TIME != this.definition.getType() && ParameterType.TIME != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.DATE) + " nor " + (Object)((Object)ParameterType.DATE_TIME) + " nor" + (Object)((Object)ParameterType.TIME));
            }
            if (this.valueParser.getValue() == null) {
                return (Date)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Date)this.valueParser.getValue();
        }

        @Override
        public Number valueAsNumber() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.NUMBER != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.NUMBER));
            }
            if (this.valueParser.getValue() == null) {
                return (Number)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Number)this.valueParser.getValue();
        }

        @Override
        public String valueAsString() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.STRING != this.definition.getType() && ParameterType.FIXED != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.STRING));
            }
            if (this.valueParser.getValue() == null) {
                return (String)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (String)this.valueParser.getValue();
        }

        @Override
        public Extension valueAsExtension() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.EXTENSION_ID != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.EXTENSION_ID));
            }
            if (this.valueParser.getValue() == null) {
                return (Extension)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Extension)this.valueParser.getValue();
        }

        @Override
        public ExtensionPoint valueAsExtensionPoint() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.EXTENSION_POINT_ID != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.EXTENSION_POINT_ID));
            }
            if (this.valueParser.getValue() == null) {
                return (ExtensionPoint)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (ExtensionPoint)this.valueParser.getValue();
        }

        @Override
        public PluginDescriptor valueAsPluginDescriptor() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.PLUGIN_ID != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.PLUGIN_ID));
            }
            if (this.valueParser.getValue() == null) {
                return (PluginDescriptor)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (PluginDescriptor)this.valueParser.getValue();
        }

        @Override
        public URL valueAsUrl() {
            return this.valueAsUrl(null);
        }

        @Override
        public URL valueAsUrl(PathResolver pathResolver) {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.RESOURCE != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.RESOURCE));
            }
            if (this.valueParser.getValue() == null && this.rawValue() == null) {
                return this.valueAsUrl(pathResolver, this.getDefinition().getDeclaringExtensionPoint(), (URL)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue(), this.getDefinition().getDefaultValue());
            }
            return this.valueAsUrl(pathResolver, this.getDeclaringPluginDescriptor(), (URL)this.valueParser.getValue(), this.rawValue());
        }

        private URL valueAsUrl(PathResolver pathResolver, Identity identity, URL uRL, String string) {
            if (pathResolver == null || uRL != null) {
                return uRL;
            }
            if (string == null) {
                return null;
            }
            return pathResolver.resolvePath(identity, string);
        }

        public String toString() {
            return "{PluginExtension.Parameter: extUid=" + this.getDeclaringExtension().getUniqueId() + "; id=" + this.getId() + "}";
        }

        @Override
        protected boolean isEqualTo(Identity identity) {
            if (!super.isEqualTo(identity)) {
                return false;
            }
            ParameterImpl parameterImpl = (ParameterImpl)identity;
            if (this.getSuperParameter() == null && parameterImpl.getSuperParameter() == null) {
                return true;
            }
            if (this.getSuperParameter() == null || parameterImpl.getSuperParameter() == null) {
                return false;
            }
            return this.getSuperParameter().equals(parameterImpl.getSuperParameter());
        }
    }
}

