/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ManifestParser;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginRegistryImpl
implements PluginRegistry {
    static final String PACKAGE_NAME = "org.java.plugin.registry.xml";
    private static final char UNIQUE_SEPARATOR = '@';
    private static final Log log = LogFactory.getLog(PluginRegistryImpl.class);
    private final List<IntegrityCheckReport.ReportItem> registrationReport = new LinkedList<IntegrityCheckReport.ReportItem>();
    private final Map<String, PluginDescriptor> registeredPlugins = new HashMap<String, PluginDescriptor>();
    private final Map<String, PluginFragment> registeredFragments = new HashMap<String, PluginFragment>();
    private final List<PluginRegistry.RegistryChangeListener> listeners = Collections.synchronizedList(new LinkedList());
    private ManifestParser manifestParser;
    private boolean stopOnError = false;

    public PluginRegistryImpl() {
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registryStart", null));
    }

    @Override
    public void configure(ExtendedProperties extendedProperties) {
        this.stopOnError = "true".equalsIgnoreCase(extendedProperties.getProperty("stopOnError", "false"));
        boolean bl = !"false".equalsIgnoreCase(extendedProperties.getProperty("isValidating", "true"));
        this.manifestParser = new ManifestParser(bl);
        log.info((Object)("configured, stopOnError=" + this.stopOnError + ", isValidating=" + bl));
    }

    @Override
    public ManifestInfo readManifestInfo(URL uRL) throws ManifestProcessingException {
        try {
            return new ManifestInfoImpl(this.manifestParser.parseManifestInfo(uRL));
        }
        catch (Exception exception) {
            throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", uRL, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Identity> register(URL[] uRLArray) throws ManifestProcessingException {
        void extension;
        LinkedList<ExtensionPoint> linkedList = new LinkedList<ExtensionPoint>();
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        for (PluginDescriptor object32 : this.registeredPlugins.values()) {
            for (ExtensionPoint extensionPoint : object32.getExtensionPoints()) {
                linkedList.add(extensionPoint);
                for (Extension modelPluginManifest : extensionPoint.getConnectedExtensions()) {
                    hashMap.put(modelPluginManifest.getUniqueId(), modelPluginManifest);
                }
            }
        }
        HashMap hashMap2 = new HashMap(uRLArray.length);
        HashMap<String, ModelPluginManifest> hashMap3 = new HashMap<String, ModelPluginManifest>();
        HashMap hashMap4 = new HashMap();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "manifestsParsingStart", null));
        URL[] uRLArray2 = uRLArray;
        int n = uRLArray2.length;
        boolean extensionPoint = false;
        while (extension < n) {
            block25: {
                ModelPluginManifest modelPluginManifest;
                URL uRL = uRLArray2[extension];
                try {
                    modelPluginManifest = this.manifestParser.parseManifest(uRL);
                }
                catch (Exception exception) {
                    log.error((Object)("can't parse manifest file " + uRL), (Throwable)exception);
                    if (this.stopOnError) {
                        throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", uRL, exception);
                    }
                    this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "manifestParsingError", new Object[]{uRL, exception}));
                    break block25;
                }
                if (modelPluginManifest instanceof ModelPluginFragment) {
                    hashMap4.put(uRL.toExternalForm(), modelPluginManifest);
                } else if (!(modelPluginManifest instanceof ModelPluginDescriptor)) {
                    log.warn((Object)("URL " + uRL + " points to XML document of unknown type"));
                } else {
                    hashMap3.put(uRL.toExternalForm(), modelPluginManifest);
                }
            }
            ++extension;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("manifest files parsed, plugins.size=" + hashMap3.size() + ", fragments.size=" + hashMap4.size()));
        }
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "manifestsParsingFinish", new Object[]{hashMap3.size(), hashMap4.size()}));
        this.checkVersions(hashMap3);
        if (log.isDebugEnabled()) {
            log.debug((Object)("plug-ins versions checked, plugins.size=" + hashMap3.size()));
        }
        this.checkVersions(hashMap4);
        if (log.isDebugEnabled()) {
            log.debug((Object)("plug-in fragments versions checked, fragments.size=" + hashMap4.size()));
        }
        RegistryChangeDataImpl registryChangeDataImpl = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringPluginsStart", null));
        for (ModelPluginManifest pluginDescriptor : hashMap3.values()) {
            PluginDescriptor pluginDescriptor2 = this.registerPlugin((ModelPluginDescriptor)pluginDescriptor, registryChangeDataImpl);
            if (pluginDescriptor2 == null) continue;
            hashMap2.put(pluginDescriptor2.getLocation().toExternalForm(), pluginDescriptor2);
        }
        hashMap3.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringFragmentsStart", null));
        for (ModelPluginManifest extension2 : hashMap4.values()) {
            PluginFragment pluginFragment = this.registerFragment((ModelPluginFragment)extension2, registryChangeDataImpl);
            if (pluginFragment == null) continue;
            hashMap2.put(pluginFragment.getLocation().toExternalForm(), pluginFragment);
        }
        hashMap4.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringPluginsFinish", this.registeredPlugins.size()));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringFragmentsFinish", this.registeredFragments.size()));
        log.info((Object)("plug-in and fragment descriptors registered - " + hashMap2.size()));
        this.dump();
        if (hashMap2.isEmpty()) {
            return hashMap2;
        }
        for (ExtensionPoint extensionPoint2 : linkedList) {
            ((ExtensionPointImpl)extensionPoint2).registryChanged();
        }
        for (Extension extension3 : hashMap.values()) {
            ((ExtensionImpl)extension3).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            for (PluginDescriptor pluginDescriptor : this.registeredPlugins.values()) {
                for (ExtensionPoint extensionPoint3 : pluginDescriptor.getExtensionPoints()) {
                    for (Extension extension4 : extensionPoint3.getConnectedExtensions()) {
                        if (!hashMap.containsKey(extension4.getUniqueId())) {
                            registryChangeDataImpl.putAddedExtension(extension4.getUniqueId(), this.makeUniqueId(extension4.getExtendedPluginId(), extension4.getExtendedPointId()));
                            continue;
                        }
                        hashMap.remove(extension4.getUniqueId());
                        if (!registryChangeDataImpl.modifiedPlugins().contains(extension4.getDeclaringPluginDescriptor().getId()) && !registryChangeDataImpl.modifiedPlugins().contains(extension4.getExtendedPluginId())) continue;
                        registryChangeDataImpl.putModifiedExtension(extension4.getUniqueId(), this.makeUniqueId(extension4.getExtendedPluginId(), extension4.getExtendedPointId()));
                    }
                }
            }
            for (Extension extension5 : hashMap.values()) {
                registryChangeDataImpl.putRemovedExtension(extension5.getUniqueId(), this.makeUniqueId(extension5.getExtendedPluginId(), extension5.getExtendedPointId()));
            }
            this.fireEvent(registryChangeDataImpl);
        }
        return hashMap2;
    }

    private void checkVersions(Map<String, ModelPluginManifest> map) throws ManifestProcessingException {
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<Map.Entry<String, ModelPluginManifest>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ModelPluginManifest> object = iterator.next();
            String string = object.getKey();
            ModelPluginManifest modelPluginManifest = object.getValue();
            if (this.registeredPlugins.containsKey(modelPluginManifest.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePlugin", modelPluginManifest.getId());
                }
                iterator.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "duplicatedPluginId", modelPluginManifest.getId()));
                continue;
            }
            if (this.registeredFragments.containsKey(modelPluginManifest.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePluginFragment", modelPluginManifest.getId());
                }
                iterator.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "duplicatedFragmentId", modelPluginManifest.getId()));
                continue;
            }
            Object[] objectArray = (Object[])hashMap.get(modelPluginManifest.getId());
            if (objectArray == null) {
                hashMap.put(modelPluginManifest.getId(), new Object[]{modelPluginManifest.getVersion(), string});
                continue;
            }
            if (((Version)objectArray[0]).compareTo(modelPluginManifest.getVersion()) < 0) {
                hashSet.add((String)objectArray[1]);
                hashMap.put(modelPluginManifest.getId(), new Object[]{modelPluginManifest.getVersion(), string});
                continue;
            }
            hashSet.add(string);
        }
        hashMap.clear();
        for (String string : hashSet) {
            map.remove(string);
        }
        hashSet.clear();
    }

    private PluginDescriptor registerPlugin(ModelPluginDescriptor modelPluginDescriptor, RegistryChangeDataImpl registryChangeDataImpl) throws ManifestProcessingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering plug-in, URL - " + modelPluginDescriptor.getLocation()));
        }
        PluginDescriptorImpl pluginDescriptorImpl = null;
        try {
            pluginDescriptorImpl = new PluginDescriptorImpl(this, modelPluginDescriptor);
            registryChangeDataImpl.addedPlugins().add(pluginDescriptorImpl.getId());
            for (PluginFragment pluginFragment : this.registeredFragments.values()) {
                PluginFragmentImpl pluginFragmentImpl = (PluginFragmentImpl)pluginFragment;
                if (!pluginFragmentImpl.matches(pluginDescriptorImpl)) continue;
                pluginDescriptorImpl.registerFragment(pluginFragmentImpl);
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginRegistered", pluginDescriptorImpl.getUniqueId()));
        }
        catch (ManifestProcessingException manifestProcessingException) {
            log.error((Object)("failed registering plug-in, URL - " + modelPluginDescriptor.getLocation()), (Throwable)manifestProcessingException);
            if (this.stopOnError) {
                throw manifestProcessingException;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "pluginRegistrationFailed", new Object[]{modelPluginDescriptor.getLocation(), manifestProcessingException}));
            return null;
        }
        this.registeredPlugins.put(pluginDescriptorImpl.getId(), pluginDescriptorImpl);
        return pluginDescriptorImpl;
    }

    private PluginFragment registerFragment(ModelPluginFragment modelPluginFragment, RegistryChangeDataImpl registryChangeDataImpl) throws ManifestProcessingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering plug-in fragment descriptor, URL - " + modelPluginFragment.getLocation()));
        }
        PluginFragmentImpl pluginFragmentImpl = null;
        try {
            pluginFragmentImpl = new PluginFragmentImpl(this, modelPluginFragment);
            boolean bl = false;
            PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)this.getPluginDescriptor(pluginFragmentImpl.getPluginId());
            if (pluginFragmentImpl.matches(pluginDescriptorImpl)) {
                pluginDescriptorImpl.registerFragment(pluginFragmentImpl);
                if (!registryChangeDataImpl.addedPlugins().contains(pluginDescriptorImpl.getId())) {
                    registryChangeDataImpl.modifiedPlugins().add(pluginDescriptorImpl.getId());
                }
                bl = true;
            }
            if (!bl) {
                log.warn((Object)("no matching plug-ins found for fragment " + pluginFragmentImpl.getUniqueId()));
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.WARNING, null, IntegrityCheckReport.Error.NO_ERROR, "noMatchingPluginFound", pluginFragmentImpl.getUniqueId()));
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "fragmentRegistered", pluginFragmentImpl.getUniqueId()));
        }
        catch (ManifestProcessingException manifestProcessingException) {
            log.error((Object)("failed registering plug-in fragment descriptor, URL - " + modelPluginFragment.getLocation()), (Throwable)manifestProcessingException);
            if (this.stopOnError) {
                throw manifestProcessingException;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "fragmentRegistrationFailed", new Object[]{modelPluginFragment.getLocation(), manifestProcessingException}));
            return null;
        }
        this.registeredFragments.put(pluginFragmentImpl.getId(), pluginFragmentImpl);
        return pluginFragmentImpl;
    }

    @Override
    public Collection<String> unregister(String[] stringArray) {
        LinkedList<ExtensionPoint> linkedList = new LinkedList<ExtensionPoint>();
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        for (PluginDescriptor object22 : this.registeredPlugins.values()) {
            for (ExtensionPoint extensionPoint : object22.getExtensionPoints()) {
                linkedList.add(extensionPoint);
                for (Extension pluginDescriptor : extensionPoint.getConnectedExtensions()) {
                    hashMap.put(pluginDescriptor.getUniqueId(), pluginDescriptor);
                }
            }
        }
        HashSet hashSet = new HashSet();
        RegistryChangeDataImpl registryChangeDataImpl = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringPrepare", null));
        HashMap hashMap2 = new HashMap();
        HashMap<String, PluginFragment> hashMap3 = new HashMap<String, PluginFragment>();
        for (String string : stringArray) {
            PluginDescriptor pluginDescriptor = this.registeredPlugins.get(string);
            if (pluginDescriptor != null) {
                for (PluginDescriptor pluginDescriptor2 : this.getDependingPlugins(pluginDescriptor)) {
                    hashMap2.put(pluginDescriptor2.getId(), pluginDescriptor2);
                    registryChangeDataImpl.removedPlugins().add(pluginDescriptor2.getId());
                }
                hashMap2.put(pluginDescriptor.getId(), pluginDescriptor);
                registryChangeDataImpl.removedPlugins().add(pluginDescriptor.getId());
                continue;
            }
            PluginFragment pluginFragment = this.registeredFragments.get(string);
            if (pluginFragment != null) {
                hashMap3.put(pluginFragment.getId(), pluginFragment);
                continue;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.WARNING, null, IntegrityCheckReport.Error.NO_ERROR, "pluginToUngregisterNotFound", string));
        }
        for (PluginDescriptor pluginDescriptor : hashMap2.values()) {
            for (PluginFragment pluginFragment : pluginDescriptor.getFragments()) {
                if (hashMap3.containsKey(pluginFragment.getId())) continue;
                hashMap3.put(pluginFragment.getId(), pluginFragment);
            }
        }
        this.fireEvent(registryChangeDataImpl);
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringFragmentsStart", null));
        for (PluginFragment extensionPoint : hashMap3.values()) {
            PluginFragmentImpl pluginFragmentImpl = (PluginFragmentImpl)extensionPoint;
            this.unregisterFragment(pluginFragmentImpl);
            if (!hashMap2.containsKey(pluginFragmentImpl.getPluginId())) {
                registryChangeDataImpl.modifiedPlugins().add(pluginFragmentImpl.getPluginId());
            }
            hashSet.add(pluginFragmentImpl.getUniqueId());
        }
        hashMap3.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringPluginsStart", null));
        for (PluginDescriptor extension : hashMap2.values()) {
            PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)extension;
            this.unregisterPlugin(pluginDescriptorImpl);
            hashSet.add(pluginDescriptorImpl.getUniqueId());
        }
        hashMap2.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringPluginsFinish", this.registeredPlugins.size()));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringFragmentsFinish", this.registeredFragments.size()));
        log.info((Object)("plug-in and fragment descriptors unregistered - " + hashSet.size()));
        this.dump();
        if (hashSet.isEmpty()) {
            return hashSet;
        }
        for (ExtensionPoint pluginDescriptor : linkedList) {
            ((ExtensionPointImpl)pluginDescriptor).registryChanged();
        }
        for (Extension extension : hashMap.values()) {
            ((ExtensionImpl)extension).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            for (PluginDescriptor pluginDescriptor : this.registeredPlugins.values()) {
                for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
                    for (Extension extension : extensionPoint.getConnectedExtensions()) {
                        if (!hashMap.containsKey(extension.getUniqueId())) {
                            registryChangeDataImpl.putAddedExtension(extension.getUniqueId(), this.makeUniqueId(extension.getExtendedPluginId(), extension.getExtendedPointId()));
                            continue;
                        }
                        hashMap.remove(extension.getUniqueId());
                        if (!registryChangeDataImpl.modifiedPlugins().contains(extension.getDeclaringPluginDescriptor().getId()) && !registryChangeDataImpl.modifiedPlugins().contains(extension.getExtendedPluginId())) continue;
                        registryChangeDataImpl.putModifiedExtension(extension.getUniqueId(), this.makeUniqueId(extension.getExtendedPluginId(), extension.getExtendedPointId()));
                    }
                }
            }
            for (Extension extension : hashMap.values()) {
                registryChangeDataImpl.putRemovedExtension(extension.getUniqueId(), this.makeUniqueId(extension.getExtendedPluginId(), extension.getExtendedPointId()));
            }
            this.fireEvent(registryChangeDataImpl);
        }
        return hashSet;
    }

    private void unregisterPlugin(PluginDescriptorImpl pluginDescriptorImpl) {
        this.registeredPlugins.remove(pluginDescriptorImpl.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginUnregistered", pluginDescriptorImpl.getUniqueId()));
    }

    private void unregisterFragment(PluginFragmentImpl pluginFragmentImpl) {
        PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)this.registeredPlugins.get(pluginFragmentImpl.getPluginId());
        if (pluginDescriptorImpl != null) {
            pluginDescriptorImpl.unregisterFragment(pluginFragmentImpl);
        }
        this.registeredFragments.remove(pluginFragmentImpl.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "fragmentUnregistered", pluginFragmentImpl.getUniqueId()));
    }

    private void dump() {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PLUG-IN REGISTRY DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tPlug-ins: " + this.registeredPlugins.size() + "\r\n");
        for (PluginDescriptor uniqueIdentity : this.registeredPlugins.values()) {
            stringBuilder.append("\t\t").append(uniqueIdentity).append("\r\n");
        }
        stringBuilder.append("\tFragments: " + this.registeredFragments.size() + "\r\n");
        for (PluginFragment pluginFragment : this.registeredFragments.values()) {
            stringBuilder.append("\t\t").append(pluginFragment).append("\r\n");
        }
        stringBuilder.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        stringBuilder.append("-------------- DUMP END -----------------\r\n");
        log.debug((Object)stringBuilder.toString());
    }

    @Override
    public ExtensionPoint getExtensionPoint(String string, String string2) {
        PluginDescriptor pluginDescriptor = this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID " + string + " provided for extension point " + string2);
        }
        for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            if (extensionPoint.isValid()) {
                return extensionPoint;
            }
            log.warn((Object)("extension point " + extensionPoint.getUniqueId() + " is invalid and ignored by registry"));
            break;
        }
        throw new IllegalArgumentException("unknown extension point ID - " + this.makeUniqueId(string, string2));
    }

    @Override
    public ExtensionPoint getExtensionPoint(String string) {
        return this.getExtensionPoint(this.extractPluginId(string), this.extractId(string));
    }

    @Override
    public boolean isExtensionPointAvailable(String string, String string2) {
        PluginDescriptor pluginDescriptor = this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            return false;
        }
        for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            return extensionPoint.isValid();
        }
        return false;
    }

    @Override
    public boolean isExtensionPointAvailable(String string) {
        return this.isExtensionPointAvailable(this.extractPluginId(string), this.extractId(string));
    }

    @Override
    public PluginDescriptor getPluginDescriptor(String string) {
        PluginDescriptor pluginDescriptor = this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        return pluginDescriptor;
    }

    @Override
    public boolean isPluginDescriptorAvailable(String string) {
        return this.registeredPlugins.containsKey(string);
    }

    @Override
    public Collection<PluginDescriptor> getPluginDescriptors() {
        List<PluginDescriptor> list = Collections.emptyList();
        return this.registeredPlugins.isEmpty() ? list : Collections.unmodifiableCollection(this.registeredPlugins.values());
    }

    @Override
    public Collection<PluginFragment> getPluginFragments() {
        List<PluginFragment> list = Collections.emptyList();
        return this.registeredFragments.isEmpty() ? list : Collections.unmodifiableCollection(this.registeredFragments.values());
    }

    @Override
    public Collection<PluginDescriptor> getDependingPlugins(PluginDescriptor pluginDescriptor) {
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        block0: for (PluginDescriptor pluginDescriptor2 : this.getPluginDescriptors()) {
            if (pluginDescriptor2.getId().equals(pluginDescriptor.getId())) continue;
            for (PluginPrerequisite pluginPrerequisite : pluginDescriptor2.getPrerequisites()) {
                if (!pluginPrerequisite.getPluginId().equals(pluginDescriptor.getId()) || !pluginPrerequisite.matches()) continue;
                if (hashMap.containsKey(pluginDescriptor2.getId())) continue block0;
                hashMap.put(pluginDescriptor2.getId(), pluginDescriptor2);
                for (PluginDescriptor pluginDescriptor3 : this.getDependingPlugins(pluginDescriptor2)) {
                    if (hashMap.containsKey(pluginDescriptor3.getId())) continue;
                    hashMap.put(pluginDescriptor3.getId(), pluginDescriptor3);
                }
                continue block0;
            }
        }
        return hashMap.values();
    }

    @Override
    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver) {
        return this.checkIntegrity(pathResolver, false);
    }

    @Override
    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver, boolean bl) {
        List list = Collections.emptyList();
        IntegrityChecker integrityChecker = new IntegrityChecker(this, bl ? this.registrationReport : list);
        integrityChecker.doCheck(pathResolver);
        return integrityChecker;
    }

    @Override
    public IntegrityCheckReport getRegistrationReport() {
        return new IntegrityChecker(this, this.registrationReport);
    }

    @Override
    public String makeUniqueId(String string, String string2) {
        return string + '@' + string2;
    }

    @Override
    public String makeUniqueId(String string, Version version) {
        return string + '@' + version;
    }

    @Override
    public String extractPluginId(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return string.substring(0, n);
    }

    @Override
    public String extractId(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return string.substring(n + 1);
    }

    @Override
    public Version extractVersion(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return Version.parse(string.substring(n + 1));
    }

    @Override
    public void registerListener(PluginRegistry.RegistryChangeListener registryChangeListener) {
        if (this.listeners.contains(registryChangeListener)) {
            throw new IllegalArgumentException("listener " + registryChangeListener + " already registered");
        }
        this.listeners.add(registryChangeListener);
    }

    @Override
    public void unregisterListener(PluginRegistry.RegistryChangeListener registryChangeListener) {
        if (!this.listeners.remove(registryChangeListener)) {
            log.warn((Object)("unknown listener " + registryChangeListener));
        }
    }

    void fireEvent(RegistryChangeDataImpl registryChangeDataImpl) {
        registryChangeDataImpl.dump();
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginRegistry.RegistryChangeListener[] registryChangeListenerArray = this.listeners.toArray(new PluginRegistry.RegistryChangeListener[this.listeners.size()]);
        registryChangeDataImpl.beforeEventFire();
        if (log.isDebugEnabled()) {
            log.debug((Object)"propagating registry change event");
        }
        for (PluginRegistry.RegistryChangeListener registryChangeListener : registryChangeListenerArray) {
            registryChangeListener.registryChanged(registryChangeDataImpl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"registry change event propagated");
        }
        registryChangeDataImpl.afterEventFire();
    }

    private static final class ManifestInfoImpl
    implements ManifestInfo {
        private final ModelManifestInfo model;

        ManifestInfoImpl(ModelManifestInfo modelManifestInfo) {
            this.model = modelManifestInfo;
        }

        public String getId() {
            return this.model.getId();
        }

        public Version getVersion() {
            return this.model.getVersion();
        }

        public String getVendor() {
            return this.model.getVendor();
        }

        public String getPluginId() {
            return this.model.getPluginId();
        }

        public Version getPluginVersion() {
            return this.model.getPluginVersion();
        }

        public MatchingRule getMatchingRule() {
            return this.model.getMatchRule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegistryChangeDataImpl
    implements PluginRegistry.RegistryChangeData {
        private Set<String> addedPlugins;
        private Set<String> removedPlugins;
        private Set<String> modifiedPlugins;
        private Map<String, String> addedExtensions;
        private Map<String, String> removedExtensions;
        private Map<String, String> modifiedExtensions;

        protected RegistryChangeDataImpl() {
            this.reset();
        }

        private void reset() {
            this.addedPlugins = new HashSet<String>();
            this.removedPlugins = new HashSet<String>();
            this.modifiedPlugins = new HashSet<String>();
            this.addedExtensions = new HashMap<String, String>();
            this.removedExtensions = new HashMap<String, String>();
            this.modifiedExtensions = new HashMap<String, String>();
        }

        protected void beforeEventFire() {
            this.addedPlugins = Collections.unmodifiableSet(this.addedPlugins);
            this.removedPlugins = Collections.unmodifiableSet(this.removedPlugins);
            this.modifiedPlugins = Collections.unmodifiableSet(this.modifiedPlugins);
            this.addedExtensions = Collections.unmodifiableMap(this.addedExtensions);
            this.removedExtensions = Collections.unmodifiableMap(this.removedExtensions);
            this.modifiedExtensions = Collections.unmodifiableMap(this.modifiedExtensions);
        }

        protected void afterEventFire() {
            this.reset();
        }

        protected void dump() {
            Log log = LogFactory.getLog(this.getClass());
            if (!log.isDebugEnabled()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PLUG-IN REGISTRY CHANGES DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tAdded plug-ins: " + this.addedPlugins.size() + "\r\n");
            for (String object : this.addedPlugins) {
                stringBuilder.append("\t\t").append((Object)object).append("\r\n");
            }
            stringBuilder.append("\tRemoved plug-ins: " + this.removedPlugins.size() + "\r\n");
            for (String string : this.removedPlugins) {
                stringBuilder.append("\t\t").append((Object)string).append("\r\n");
            }
            stringBuilder.append("\tModified plug-ins: " + this.modifiedPlugins.size() + "\r\n");
            for (String string : this.modifiedPlugins) {
                stringBuilder.append("\t\t").append((Object)string).append("\r\n");
            }
            stringBuilder.append("\tAdded extensions: " + this.addedExtensions.size() + "\r\n");
            for (Map.Entry entry : this.addedExtensions.entrySet()) {
                stringBuilder.append("\t\t").append(entry).append("\r\n");
            }
            stringBuilder.append("\tRemoved extensions: " + this.removedExtensions.size() + "\r\n");
            for (Map.Entry entry : this.removedExtensions.entrySet()) {
                stringBuilder.append("\t\t").append(entry).append("\r\n");
            }
            stringBuilder.append("\tModified extensions: " + this.modifiedExtensions.size() + "\r\n");
            for (Map.Entry entry : this.modifiedExtensions.entrySet()) {
                stringBuilder.append("\t\t").append(entry).append("\r\n");
            }
            stringBuilder.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
            stringBuilder.append("-------------- DUMP END -----------------\r\n");
            log.debug((Object)stringBuilder.toString());
        }

        @Override
        public Set<String> addedPlugins() {
            return this.addedPlugins;
        }

        @Override
        public Set<String> removedPlugins() {
            return this.removedPlugins;
        }

        @Override
        public Set<String> modifiedPlugins() {
            return this.modifiedPlugins;
        }

        void putAddedExtension(String string, String string2) {
            this.addedExtensions.put(string, string2);
        }

        @Override
        public Set<String> addedExtensions() {
            return this.addedExtensions.keySet();
        }

        @Override
        public Set<String> addedExtensions(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.addedExtensions.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }

        void putRemovedExtension(String string, String string2) {
            this.removedExtensions.put(string, string2);
        }

        @Override
        public Set<String> removedExtensions() {
            return this.removedExtensions.keySet();
        }

        @Override
        public Set<String> removedExtensions(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.removedExtensions.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }

        void putModifiedExtension(String string, String string2) {
            this.modifiedExtensions.put(string, string2);
        }

        @Override
        public Set<String> modifiedExtensions() {
            return this.modifiedExtensions.keySet();
        }

        @Override
        public Set<String> modifiedExtensions(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.modifiedExtensions.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

