/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.JpfException;
import org.java.plugin.PathResolver;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.PluginLifecycleHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardPluginManager
extends PluginManager {
    Log log = LogFactory.getLog(this.getClass());
    private final PathResolver pathResolver;
    private final PluginRegistry registry;
    private final PluginLifecycleHandler lifecycleHandler;
    private final Map<String, Plugin> activePlugins = new HashMap<String, Plugin>();
    private final Set<String> activatingPlugins = new HashSet<String>();
    private final Set<String> badPlugins = new HashSet<String>();
    private final List<String> activationLog = new LinkedList<String>();
    private final Map<String, PluginClassLoader> classLoaders = new HashMap<String, PluginClassLoader>();
    private final Set<String> disabledPlugins = new HashSet<String>();
    private final List<PluginManager.EventListener> listeners = Collections.synchronizedList(new LinkedList());
    private PluginRegistry.RegistryChangeListener registryChangeListener;
    private Map<String, URL> notRegisteredPluginLocations = new HashMap<String, URL>();

    protected StandardPluginManager(PluginRegistry pluginRegistry, PathResolver pathResolver, PluginLifecycleHandler pluginLifecycleHandler) {
        this.registry = pluginRegistry;
        this.pathResolver = pathResolver;
        this.lifecycleHandler = pluginLifecycleHandler;
        this.lifecycleHandler.init(this);
        this.registryChangeListener = new PluginRegistry.RegistryChangeListener(){

            public void registryChanged(PluginRegistry.RegistryChangeData registryChangeData) {
                StandardPluginManager.this.registryChangeHandler(registryChangeData);
            }
        };
        this.registry.registerListener(this.registryChangeListener);
    }

    @Override
    public PluginRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    synchronized void registryChangeHandler(PluginRegistry.RegistryChangeData registryChangeData) {
        Object object;
        this.badPlugins.clear();
        for (String iterator : registryChangeData.removedPlugins()) {
            this.deactivatePlugin(iterator);
            this.pathResolver.unregisterContext(iterator);
        }
        for (PluginDescriptor pluginDescriptor : this.registry.getPluginDescriptors()) {
            object = this.notRegisteredPluginLocations.remove(pluginDescriptor.getLocation().toExternalForm());
            if (object == null) continue;
            this.pathResolver.registerContext(pluginDescriptor, (URL)object);
        }
        for (PluginFragment pluginFragment : this.registry.getPluginFragments()) {
            object = this.notRegisteredPluginLocations.remove(pluginFragment.getLocation().toExternalForm());
            if (object == null) continue;
            this.pathResolver.registerContext(pluginFragment, (URL)object);
        }
        for (String string : registryChangeData.modifiedPlugins()) {
            if (this.activePlugins.containsKey(string)) {
                this.deactivatePlugin(string);
                try {
                    this.activatePlugin(string);
                }
                catch (Exception exception) {
                    this.log.error((Object)("failed activating modified plug-in " + string), (Throwable)exception);
                }
                continue;
            }
            PluginClassLoader pluginClassLoader = this.classLoaders.get(string);
            if (pluginClassLoader == null) continue;
            this.notifyClassLoader(pluginClassLoader);
        }
    }

    @Override
    public Map<String, Identity> publishPlugins(PluginManager.PluginLocation[] pluginLocationArray) throws JpfException {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (PluginManager.PluginLocation pluginLocation : pluginLocationArray) {
            URL uRL = pluginLocation.getManifestLocation();
            linkedList.add(uRL);
            this.notRegisteredPluginLocations.put(uRL.toExternalForm(), pluginLocation.getContextLocation());
        }
        return this.registry.register(linkedList.toArray(new URL[linkedList.size()]));
    }

    @Override
    public Plugin getPlugin(String string) throws PluginLifecycleException {
        Plugin plugin = this.activePlugins.get(string);
        if (plugin != null) {
            return plugin;
        }
        if (this.badPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled externally");
        }
        PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        return this.activatePlugin(pluginDescriptor);
    }

    @Override
    public void activatePlugin(String string) throws PluginLifecycleException {
        if (this.activePlugins.containsKey(string)) {
            return;
        }
        if (this.badPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(string)) {
            throw new IllegalArgumentException("plug-in " + string + " disabled externally");
        }
        PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        this.activatePlugin(pluginDescriptor);
    }

    @Override
    public Plugin getPluginFor(Object object) {
        if (object == null) {
            return null;
        }
        ClassLoader classLoader = object instanceof Class ? ((Class)object).getClassLoader() : (object instanceof ClassLoader ? (ClassLoader)object : object.getClass().getClassLoader());
        if (!(classLoader instanceof PluginClassLoader)) {
            return null;
        }
        PluginDescriptor pluginDescriptor = ((PluginClassLoader)classLoader).getPluginDescriptor();
        Plugin plugin = this.activePlugins.get(pluginDescriptor.getId());
        if (plugin != null) {
            return plugin;
        }
        throw new IllegalStateException("can't get plug-in " + pluginDescriptor);
    }

    @Override
    public boolean isPluginActivated(PluginDescriptor pluginDescriptor) {
        return this.activePlugins.containsKey(pluginDescriptor.getId());
    }

    @Override
    public boolean isBadPlugin(PluginDescriptor pluginDescriptor) {
        return this.badPlugins.contains(pluginDescriptor.getId());
    }

    @Override
    public boolean isPluginActivating(PluginDescriptor pluginDescriptor) {
        return this.activatingPlugins.contains(pluginDescriptor.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginClassLoader getPluginClassLoader(PluginDescriptor pluginDescriptor) {
        if (this.badPlugins.contains(pluginDescriptor.getId())) {
            throw new IllegalArgumentException("plug-in " + pluginDescriptor.getId() + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(pluginDescriptor.getId())) {
            throw new IllegalArgumentException("plug-in " + pluginDescriptor.getId() + " disabled externally");
        }
        PluginClassLoader pluginClassLoader = this.classLoaders.get(pluginDescriptor.getId());
        if (pluginClassLoader != null) {
            return pluginClassLoader;
        }
        StandardPluginManager standardPluginManager = this;
        synchronized (standardPluginManager) {
            pluginClassLoader = this.classLoaders.get(pluginDescriptor.getId());
            if (pluginClassLoader != null) {
                return pluginClassLoader;
            }
            pluginClassLoader = this.lifecycleHandler.createPluginClassLoader(pluginDescriptor);
            this.classLoaders.put(pluginDescriptor.getId(), pluginClassLoader);
        }
        return pluginClassLoader;
    }

    @Override
    public synchronized void shutdown() {
        this.log.debug((Object)"shutting down...");
        this.dump();
        this.registry.unregisterListener(this.registryChangeListener);
        ArrayList<String> arrayList = new ArrayList<String>(this.activationLog);
        Collections.reverse(arrayList);
        for (String string : arrayList) {
            PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
            if (pluginDescriptor == null) {
                this.log.warn((Object)("can't find descriptor for plug-in " + string + " to deactivate plug-in"), (Throwable)new Exception("fake exception to view stack trace"));
                continue;
            }
            this.deactivatePlugin(pluginDescriptor);
        }
        this.dump();
        this.classLoaders.clear();
        this.disabledPlugins.clear();
        this.listeners.clear();
        this.lifecycleHandler.dispose();
        this.log.info((Object)"shutdown done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Plugin activatePlugin(PluginDescriptor pluginDescriptor) throws PluginLifecycleException {
        Plugin plugin = this.activePlugins.get(pluginDescriptor.getId());
        if (plugin != null) {
            return plugin;
        }
        if (this.badPlugins.contains(pluginDescriptor.getId())) {
            throw new IllegalArgumentException("plug-in " + pluginDescriptor.getId() + " disabled as it wasn't properly initialized");
        }
        if (this.activatingPlugins.contains(pluginDescriptor.getId())) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginActivating", pluginDescriptor.getId());
        }
        this.activatingPlugins.add(pluginDescriptor.getId());
        try {
            Object object;
            try {
                this.checkPrerequisites(pluginDescriptor);
                object = pluginDescriptor.getPluginClassName();
                plugin = object == null || ((String)object).trim().length() == 0 ? new EmptyPlugin() : this.lifecycleHandler.createPluginInstance(pluginDescriptor);
                this.initPlugin(plugin, pluginDescriptor);
                this.lifecycleHandler.beforePluginStart(plugin);
                this.startPlugin(plugin);
            }
            catch (PluginLifecycleException pluginLifecycleException) {
                this.badPlugins.add(pluginDescriptor.getId());
                this.classLoaders.remove(pluginDescriptor.getId());
                throw pluginLifecycleException;
            }
            catch (Exception exception) {
                this.badPlugins.add(pluginDescriptor.getId());
                this.classLoaders.remove(pluginDescriptor.getId());
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginStartFailed", pluginDescriptor.getUniqueId(), exception);
            }
            this.activePlugins.put(pluginDescriptor.getId(), plugin);
            this.activationLog.add(pluginDescriptor.getId());
            this.log.info((Object)("plug-in started - " + pluginDescriptor.getUniqueId()));
            this.fireEvent(plugin, true);
            object = plugin;
            return object;
        }
        finally {
            this.activatingPlugins.remove(pluginDescriptor.getId());
        }
    }

    private void checkPrerequisites(PluginDescriptor pluginDescriptor) throws PluginLifecycleException {
        for (PluginPrerequisite pluginPrerequisite : pluginDescriptor.getPrerequisites()) {
            if (this.activatingPlugins.contains(pluginPrerequisite.getPluginId())) {
                this.log.warn((Object)("dependencies loop detected during activation of plug-in " + pluginDescriptor), (Throwable)new Exception("fake exception to view stack trace"));
                continue;
            }
            if (this.badPlugins.contains(pluginPrerequisite.getPluginId())) {
                if (pluginPrerequisite.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteBad", new Object[]{pluginDescriptor.getId(), pluginPrerequisite.getPluginId()});
            }
            if (this.disabledPlugins.contains(pluginPrerequisite.getPluginId())) {
                if (pluginPrerequisite.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteDisabled", new Object[]{pluginDescriptor.getId(), pluginPrerequisite.getPluginId()});
            }
            if (!pluginPrerequisite.matches()) {
                if (pluginPrerequisite.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteNotMatches", new Object[]{pluginDescriptor.getId(), pluginPrerequisite.getPluginId()});
            }
            try {
                this.activatePlugin(this.registry.getPluginDescriptor(pluginPrerequisite.getPluginId()));
            }
            catch (PluginLifecycleException pluginLifecycleException) {
                if (pluginPrerequisite.isOptional()) {
                    this.log.warn((Object)("failed activating optional plug-in from prerequisite " + pluginPrerequisite), (Throwable)pluginLifecycleException);
                    continue;
                }
                throw pluginLifecycleException;
            }
        }
    }

    @Override
    public void deactivatePlugin(String string) {
        if (!this.activePlugins.containsKey(string)) {
            return;
        }
        PluginDescriptor pluginDescriptor = this.registry.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        for (PluginDescriptor object22 : this.registry.getDependingPlugins(pluginDescriptor)) {
            hashMap.put(object22.getId(), object22);
        }
        LinkedList linkedList = new LinkedList();
        ArrayList<String> arrayList = new ArrayList<String>(this.activationLog);
        Collections.reverse(arrayList);
        for (Object object : arrayList) {
            if (((String)object).equals(pluginDescriptor.getId())) {
                linkedList.add(pluginDescriptor);
                continue;
            }
            if (!hashMap.containsKey(object)) continue;
            linkedList.add(hashMap.get(object));
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (PluginDescriptor)iterator.next();
            this.deactivatePlugin((PluginDescriptor)object);
        }
        this.dump();
    }

    private synchronized void deactivatePlugin(PluginDescriptor pluginDescriptor) {
        PluginClassLoader pluginClassLoader;
        Plugin plugin = this.activePlugins.remove(pluginDescriptor.getId());
        if (plugin != null) {
            try {
                if (plugin.isActive()) {
                    this.fireEvent(plugin, false);
                    this.stopPlugin(plugin);
                    this.lifecycleHandler.afterPluginStop(plugin);
                    this.log.info((Object)("plug-in stopped - " + pluginDescriptor.getUniqueId()));
                } else {
                    this.log.warn((Object)("plug-in " + pluginDescriptor.getUniqueId() + " is not active although present in active " + "plug-ins list"), (Throwable)new Exception("fake exception to view stack trace"));
                }
            }
            catch (Exception exception) {
                this.log.error((Object)("error while stopping plug-in " + pluginDescriptor.getUniqueId()), (Throwable)exception);
            }
        }
        if ((pluginClassLoader = this.classLoaders.remove(pluginDescriptor.getId())) != null) {
            this.disposeClassLoader(pluginClassLoader);
        }
        this.badPlugins.remove(pluginDescriptor.getId());
        this.activationLog.remove(pluginDescriptor.getId());
    }

    private void dump() {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("PLUGIN MANAGER DUMP:\r\n");
        stringBuilder.append("-------------- DUMP BEGIN -----------------\r\n");
        stringBuilder.append("\tActive plug-ins: " + this.activePlugins.size()).append("\r\n");
        for (Plugin object : this.activePlugins.values()) {
            stringBuilder.append("\t\t").append(object).append("\r\n");
        }
        stringBuilder.append("\tActivating plug-ins: " + this.activatingPlugins.size()).append("\r\n");
        for (String string : this.activatingPlugins) {
            stringBuilder.append("\t\t").append(string).append("\r\n");
        }
        stringBuilder.append("\tPlug-ins with instantiated class loaders: " + this.classLoaders.size()).append("\r\n");
        for (String string : this.classLoaders.keySet()) {
            stringBuilder.append("\t\t").append(string).append("\r\n");
        }
        stringBuilder.append("\tDisabled plug-ins: " + this.disabledPlugins.size()).append("\r\n");
        for (String string : this.disabledPlugins) {
            stringBuilder.append("\t\t").append(string).append("\r\n");
        }
        stringBuilder.append("\tBad plug-ins: " + this.badPlugins.size()).append("\r\n");
        for (String string : this.badPlugins) {
            stringBuilder.append("\t\t").append(string).append("\r\n");
        }
        stringBuilder.append("\tActivation log: " + this.activationLog.size()).append("\r\n");
        for (String string : this.activationLog) {
            stringBuilder.append("\t\t").append(string).append("\r\n");
        }
        stringBuilder.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        stringBuilder.append("-------------- DUMP END -----------------");
        this.log.debug((Object)stringBuilder.toString());
    }

    @Override
    public PluginDescriptor[] disablePlugin(PluginDescriptor pluginDescriptor) {
        LinkedList<PluginDescriptor> linkedList = new LinkedList<PluginDescriptor>();
        if (!this.disabledPlugins.contains(pluginDescriptor.getId())) {
            this.deactivatePlugin(pluginDescriptor);
            this.fireEvent(pluginDescriptor, false);
            this.disabledPlugins.add(pluginDescriptor.getId());
            linkedList.add(pluginDescriptor);
        }
        for (PluginDescriptor pluginDescriptor2 : this.registry.getDependingPlugins(pluginDescriptor)) {
            if (this.disabledPlugins.contains(pluginDescriptor2.getId())) continue;
            this.deactivatePlugin(pluginDescriptor2);
            this.fireEvent(pluginDescriptor2, false);
            this.disabledPlugins.add(pluginDescriptor2.getId());
            linkedList.add(pluginDescriptor2);
        }
        return linkedList.toArray(new PluginDescriptor[linkedList.size()]);
    }

    @Override
    public PluginDescriptor[] enablePlugin(PluginDescriptor pluginDescriptor, boolean bl) {
        LinkedList<PluginDescriptor> linkedList = new LinkedList<PluginDescriptor>();
        if (this.disabledPlugins.contains(pluginDescriptor.getId())) {
            this.disabledPlugins.remove(pluginDescriptor.getId());
            this.fireEvent(pluginDescriptor, true);
            linkedList.add(pluginDescriptor);
        }
        if (bl) {
            for (PluginDescriptor pluginDescriptor2 : this.registry.getDependingPlugins(pluginDescriptor)) {
                if (!this.disabledPlugins.contains(pluginDescriptor2.getId())) continue;
                this.disabledPlugins.remove(pluginDescriptor2.getId());
                this.fireEvent(pluginDescriptor2, true);
                linkedList.add(pluginDescriptor2);
            }
        }
        return linkedList.toArray(new PluginDescriptor[linkedList.size()]);
    }

    @Override
    public boolean isPluginEnabled(PluginDescriptor pluginDescriptor) {
        return !this.disabledPlugins.contains(pluginDescriptor.getId());
    }

    @Override
    public void registerListener(PluginManager.EventListener eventListener) {
        if (this.listeners.contains(eventListener)) {
            throw new IllegalArgumentException("listener " + eventListener + " already registered");
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void unregisterListener(PluginManager.EventListener eventListener) {
        if (!this.listeners.remove(eventListener)) {
            this.log.warn((Object)("unknown listener " + eventListener));
        }
    }

    private void fireEvent(Object object, boolean bl) {
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginManager.EventListener[] eventListenerArray = this.listeners.toArray(new PluginManager.EventListener[this.listeners.size()]);
        if (object instanceof PluginDescriptor) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)object;
            if (bl) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginEnabled\" event for " + pluginDescriptor));
                }
                for (PluginManager.EventListener eventListener : eventListenerArray) {
                    eventListener.pluginEnabled(pluginDescriptor);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginDisabled\" event for " + pluginDescriptor));
                }
                for (PluginManager.EventListener eventListener : eventListenerArray) {
                    eventListener.pluginDisabled(pluginDescriptor);
                }
            }
        } else {
            Plugin plugin = (Plugin)object;
            if (bl) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginActivated\" event for " + plugin));
                }
                for (PluginManager.EventListener eventListener : eventListenerArray) {
                    eventListener.pluginActivated(plugin);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginDeactivated\" event for " + plugin));
                }
                for (PluginManager.EventListener eventListener : eventListenerArray) {
                    eventListener.pluginDeactivated(plugin);
                }
            }
        }
    }

    static final class EmptyPlugin
    extends Plugin {
        EmptyPlugin() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

