/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessControlException;
import java.text.DecimalFormat;

public class FileUtils {
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;

    public static File createTempDir(String string, boolean bl) throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"));
        return FileUtils.createTempDir(file, string, bl);
    }

    public static File createTempDir(File file, String string, boolean bl) throws IOException {
        File file2 = new File(file, string + System.currentTimeMillis());
        if (file2.exists()) {
            file2.delete();
        }
        if (!file2.mkdir()) {
            throw new IOException("FileUtil -ERROR- Unable to create temp dir in default tmp file location=" + file2.getAbsolutePath());
        }
        if (bl) {
            file2.deleteOnExit();
        }
        return file2;
    }

    public static void checkDir(File file, boolean bl, boolean bl2) throws AccessControlException, FileNotFoundException, IOException {
        if (file == null) {
            throw new IOException("File is <NULL>");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("No file at path=" + file.getAbsoluteFile());
        }
        if (!file.isDirectory()) {
            throw new IOException("File is not a dir at path=" + file.getAbsoluteFile());
        }
        if (bl && !file.canRead()) {
            throw new AccessControlException("File is not readable at path=" + file.getAbsoluteFile());
        }
        if (bl2 && !file.canWrite()) {
            throw new AccessControlException("File is not writeable at path=" + file.getAbsoluteFile());
        }
    }

    public static String getFormattedContentSize(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("FILE IS NULL");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("FILE NOT FOUND path=" + file.getAbsolutePath());
        }
        return FileUtils.getFormattedContentSize(new Long(file.length()).floatValue());
    }

    public static String getFormattedContentSize(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("##0.0");
        String string = null;
        String string2 = null;
        if (d > 1.073741824E9) {
            string = decimalFormat.format(d / 1.073741824E9).toString();
            string2 = " GB";
        } else if (d > 1048576.0) {
            string = decimalFormat.format(d / 1048576.0).toString();
            string2 = " MB";
        } else {
            string = decimalFormat.format(d / 1024.0).toString();
            string2 = " KB";
        }
        return string + string2;
    }

    public static Long bToKb(long l) {
        return new Long(l / 0x100000L);
    }
}

