/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static String DB_PATTERN_LONG = "DD-MON-YYYY HH24:MI:SS";
    public static String DB_PATTERN_SHORT = "DD-MON-YYYY";
    public static String ORACLE_PATTERN_LONG = "dd-MMM-yyyy HH:mm:ss";
    public static String[] MONTHS_SHORT = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public static DateFormat getLongYearDateFormat(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)dateFormat).toPattern();
            string = string.replaceFirst("y+", "yyyy");
            dateFormat = new SimpleDateFormat(string, locale);
        }
        return dateFormat;
    }

    public static String getLongYearDate(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        return dateFormat.format(date);
    }

    public static String getMediumYearDate(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1);
        return dateFormat.format(date);
    }

    public static String getMediumTime(Date date) {
        DateFormat dateFormat = DateFormat.getTimeInstance(2);
        return dateFormat.format(date);
    }

    public static String getShortTime(Date date) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        return dateFormat.format(date);
    }

    public static String getMediumDate(Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        return dateFormat.format(date);
    }

    public static String getLongYearDate(Calendar calendar) {
        return DateUtil.getLongYearDate(calendar.getTime());
    }

    public static Date getCurrentCenturyDate(Locale locale, String string, int n) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        DateFormat dateFormat = DateUtil.getLongYearDateFormat(locale);
        dateFormat.setLenient(false);
        calendar.setTime(dateFormat.parse(string.trim()));
        if (calendar.get(1) < 100) {
            calendar.add(1, n);
        }
        return calendar.getTime();
    }

    public static Date getCurrentCenturyDate(String string, int n) throws ParseException {
        return DateUtil.getCurrentCenturyDate(Locale.getDefault(), string, n);
    }

    public static String getPatternDisplayString(DateFormat dateFormat) throws ClassCastException {
        String string = ((SimpleDateFormat)dateFormat).toPattern().toUpperCase();
        string = string.replaceFirst("^M+/D+/", "MM/DD/");
        return string;
    }

    public static boolean isInRange(Date date, Date date2, Date date3) {
        try {
            if (date.compareTo(date2) > 0 && date3.compareTo(date) > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getOracleDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ORACLE_PATTERN_LONG);
        return simpleDateFormat.format(date);
    }
}

