/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import net.sf.navigator.displayer.AbstractMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;

public abstract class MessageResourcesMenuDisplayer
extends AbstractMenuDisplayer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected Object messages = null;
    protected Locale locale = null;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Object getMessageResources() {
        return this.messages;
    }

    public void setMessageResources(Object messages) {
        this.messages = messages;
    }

    public String getMessage(String key) {
        String message;
        block13: {
            message = null;
            if (this.messages != null && this.messages instanceof ResourceBundle) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Looking up string '" + key + "' in ResourceBundle"));
                }
                ResourceBundle bundle = (ResourceBundle)this.messages;
                try {
                    message = bundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    message = null;
                }
            } else if (this.messages != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Looking up message '" + key + "' in Struts' MessageResources"));
                }
                if ("org.apache.struts.util.PropertyMessageResources".equals(this.messages.getClass().getName())) {
                    MessageResources resources = (MessageResources)this.messages;
                    try {
                        if (this.locale != null) {
                            message = resources.getMessage(this.locale, key);
                            break block13;
                        }
                        message = resources.getMessage(key);
                    }
                    catch (Throwable t) {
                        message = null;
                    }
                }
            } else {
                message = key;
            }
        }
        if (message == null) {
            message = key;
        }
        return message;
    }

    public String getMenuTarget(MenuComponent menu) {
        String menuTarget = this.target != null ? this.target : (menu.getTarget() != null ? menu.getTarget() : "_self");
        return menuTarget;
    }

    public String getMenuToolTip(MenuComponent menu) {
        String tooltip = menu.getToolTip() != null ? this.getMessage(menu.getToolTip()) : this.getMessage(menu.getTitle());
        return tooltip;
    }

    public String getMenuOnClick(MenuComponent menu) {
        if (menu.getOnclick() != null) {
            return " onclick=\"" + menu.getOnclick() + "\"";
        }
        return "";
    }

    public abstract void display(MenuComponent var1) throws JspException, IOException;
}

