/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import net.sf.navigator.displayer.ListMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;

public class TabbedMenuDisplayer
extends ListMenuDisplayer {
    public void display(MenuComponent menu) throws JspException, IOException {
        if (this.isAllowed(menu)) {
            this.displayComponents(menu, 0);
        }
    }

    protected void displayComponents(MenuComponent menu, int level) throws JspException, IOException {
        MenuComponent[] components = menu.getMenuComponents();
        if (components.length > 0) {
            this.out.print("\t<li>");
            String menuClass = "submenu";
            if (level >= 1) {
                menuClass = "deepmenu";
            }
            if (menu.getUrl() == null) {
                this.log.info((Object)("The Menu '" + this.getMessage(menu.getTitle()) + "' does not have a location defined, using first submenu's location"));
                menu.setUrl(components[0].getUrl());
            }
            this.out.print(this.displayStrings.getMessage("tmd.menu.tab", (Object)menu.getUrl(), (Object)super.getMenuToolTip(menu), (Object)this.getExtra(menu), (Object)this.getMessage(menu.getTitle())));
            int i = 0;
            while (i < components.length) {
                if (this.isAllowed(components[i])) {
                    if (components[i].getMenuComponents().length > 0) {
                        if (menuClass.equals("submenu")) {
                            this.out.print("<li>");
                        }
                        this.displayComponents(components[i], level + 1);
                        this.out.println("</ul></li>");
                        if (i == components[i].getMenuComponents().length - 1) {
                            this.out.println("</li>");
                        }
                    } else {
                        this.out.println(this.displayStrings.getMessage("tmd.menu.item", (Object)components[i].getUrl(), (Object)super.getMenuToolTip(components[i]), (Object)super.getExtra(components[i]), (Object)this.getMessage(components[i].getTitle())));
                    }
                }
                ++i;
            }
            if (menuClass.equals("submenu")) {
                this.out.println("\t</ul>");
            }
            this.out.print("\t</li>");
        } else {
            this.out.println(this.displayStrings.getMessage("tmd.menu.item", (Object)menu.getUrl(), (Object)super.getMenuToolTip(menu), (Object)super.getExtra(menu), (Object)this.getMessage(menu.getTitle())));
        }
    }
}

