/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.tools.VelocityFormatter;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.servlet.ServletLogger;
import org.apache.velocity.tools.view.servlet.WebappLoader;

public class VelocityMenuDisplayer
extends MessageResourcesMenuDisplayer {
    protected static final Log log = LogFactory.getLog(VelocityMenuDisplayer.class);
    private PageContext pageContext = null;

    public static void initialize(ServletContext context) {
        Velocity.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)context);
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)ServletLogger.class.getName());
        Velocity.setProperty((String)"resource.loader", (Object)"webapp");
        Velocity.setProperty((String)"webapp.resource.loader.class", (Object)WebappLoader.class.getName());
        try {
            Properties props = new Properties();
            ResourceBundle defaults = ResourceBundle.getBundle("net.sf.navigator.displayer.velocity");
            Enumeration<String> keys = defaults.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                props.put(key, defaults.getString(key));
            }
            ResourceBundle custom = null;
            try {
                custom = ResourceBundle.getBundle("velocity");
                Enumeration<String> keys2 = custom.getKeys();
                while (keys2.hasMoreElements()) {
                    String key = keys2.nextElement();
                    props.put(key, custom.getString(key));
                }
            }
            catch (MissingResourceException mre) {
                log.debug((Object)"No velocity.properties found in classpath, using default settings");
            }
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            log.error((Object)("Error initializing Velocity: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void init(PageContext pageContext, MenuDisplayerMapping mapping) {
        super.init(pageContext, mapping);
        this.pageContext = pageContext;
    }

    public void display(MenuComponent menu) throws JspException, IOException {
        if (this.isAllowed(menu)) {
            this.displayComponents(menu);
        }
    }

    protected void displayComponents(MenuComponent menu) throws JspException, IOException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        boolean debug = Boolean.valueOf(request.getParameter("debug"));
        if (debug) {
            this.pageContext.getOut().print(" [ " + this.getConfig() + " ] ");
        } else {
            Object val1;
            Template t;
            try {
                String template = this.getConfig();
                if (template == null) {
                    throw new JspException("You must specify a template using the 'config' attribute.");
                }
                log.debug((Object)("using template: " + template));
                t = Velocity.getTemplate((String)template);
            }
            catch (Exception e) {
                String msg = "Error initializing Velocity: " + e.toString();
                log.error((Object)msg, (Throwable)e);
                throw new JspException(msg, (Throwable)e);
            }
            StringWriter sw = new StringWriter();
            VelocityContext context = new VelocityContext();
            context.put("formatter", (Object)new VelocityFormatter((Context)context));
            context.put("now", (Object)Calendar.getInstance().getTime());
            context.put("ctxPath", (Object)request.getContextPath());
            context.put("stringUtils", (Object)new StringUtils());
            context.put("map", new HashMap());
            if (!StringUtils.isEmpty((String)this.name) && (val1 = this.pageContext.findAttribute(this.name)) != null) {
                context.put(this.name, val1);
            }
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object value = request.getAttribute(name);
                context.put(name, value);
            }
            context.put("request", (Object)request);
            context.put("session", (Object)request.getSession(false));
            this.updateAllowedComponents(menu);
            context.put("menuId", this.pageContext.getAttribute("menuId"));
            context.put("menu", (Object)menu);
            context.put("displayer", (Object)this);
            try {
                t.merge((Context)context, (Writer)sw);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new JspException((Throwable)ex);
            }
            String result = sw.getBuffer().toString();
            this.pageContext.getOut().print(result);
        }
    }

    private void updateAllowedComponents(MenuComponent menu) {
        MenuComponent[] components = menu.getMenuComponents();
        if (components.length > 0) {
            ArrayList<MenuComponent> componentsAllowed = new ArrayList<MenuComponent>();
            int i = 0;
            while (i < components.length) {
                if (this.isAllowed(components[i])) {
                    componentsAllowed.add(components[i]);
                    this.updateAllowedComponents(components[i]);
                }
                ++i;
            }
            menu.getComponents().clear();
            menu.getComponents().addAll(componentsAllowed);
        }
    }

    public void end(PageContext context) {
        this.pageContext = null;
    }
}

