/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.menu;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.VelocityMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import net.sf.navigator.util.LoadableResource;
import net.sf.navigator.util.LoadableResourceException;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuRepository
implements LoadableResource,
Serializable {
    public static final String MENU_REPOSITORY_KEY = "net.sf.navigator.menu.MENU_REPOSITORY";
    private static Log log = LogFactory.getLog(MenuRepository.class);
    protected String config = null;
    protected String name = null;
    protected ServletContext servletContext = null;
    protected LinkedMap menus = new LinkedMap();
    protected LinkedMap displayers = new LinkedMap();
    protected LinkedMap templates = new LinkedMap();
    private String breadCrumbDelimiter;

    public Set getMenuNames() {
        return this.menus.keySet();
    }

    public List getTopMenus() {
        ArrayList<MenuComponent> topMenus = new ArrayList<MenuComponent>();
        if (this.menus == null) {
            log.warn((Object)"No menus found in repository!");
            return topMenus;
        }
        for (String name : this.menus.keySet()) {
            MenuComponent menu = this.getMenu(name);
            if (menu.getParent() != null) continue;
            topMenus.add(menu);
        }
        return topMenus;
    }

    public MenuComponent getMenu(String menuName) {
        return (MenuComponent)this.menus.get((Object)menuName);
    }

    public MenuDisplayerMapping getMenuDisplayerMapping(String displayerName) {
        return (MenuDisplayerMapping)this.displayers.get((Object)displayerName);
    }

    protected Digester initDigester() {
        Digester digester = new Digester();
        digester.setClassLoader(Thread.currentThread().getContextClassLoader());
        digester.push((Object)this);
        digester.addObjectCreate("MenuConfig/Menus/Menu", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu");
        digester.addSetNext("MenuConfig/Menus/Menu", "addMenu");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item/Item", "net.sf.navigator.menu.MenuComponent", "type");
        digester.addSetProperties("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item/Item");
        digester.addSetNext("MenuConfig/Menus/Menu/Item/Item/Item/Item/Item/Item", "addMenuComponent", "net.sf.navigator.menu.MenuComponent");
        digester.addObjectCreate("MenuConfig/Displayers/Displayer", "net.sf.navigator.displayer.MenuDisplayerMapping", "mapping");
        digester.addSetProperties("MenuConfig/Displayers/Displayer");
        digester.addSetNext("MenuConfig/Displayers/Displayer", "addMenuDisplayerMapping", "net.sf.navigator.displayer.MenuDisplayerMapping");
        digester.addSetProperty("MenuConfig/Displayers/Displayer/SetProperty", "property", "value");
        return digester;
    }

    public void addMenu(MenuComponent menu) {
        if (this.menus.containsKey((Object)menu.getName())) {
            List children;
            if (log.isDebugEnabled()) {
                log.warn((Object)("Menu '" + menu.getName() + "' already exists in repository"));
            }
            if ((children = this.getMenu(menu.getName()).getComponents()) != null && menu.getComponents() != null) {
                for (MenuComponent child : children) {
                    menu.addMenuComponent(child);
                }
            }
        }
        this.menus.put((Object)menu.getName(), (Object)menu);
    }

    public void removeMenu(String name) {
        this.menus.remove((Object)name);
    }

    public void removeAllMenus() {
        this.menus.clear();
    }

    public void addMenuDisplayerMapping(MenuDisplayerMapping displayerMapping) {
        this.displayers.put((Object)displayerMapping.getName(), (Object)displayerMapping);
        if (displayerMapping.getType().equals(VelocityMenuDisplayer.class.getName())) {
            if (this.servletContext == null) {
                log.error((Object)"ServletContext not set - can't initialize Velocity");
            } else {
                VelocityMenuDisplayer.initialize(this.servletContext);
            }
        }
    }

    public LinkedMap getDisplayers() {
        return this.displayers;
    }

    public void setDisplayers(LinkedMap displayers) {
        this.displayers = displayers;
    }

    public void load() throws LoadableResourceException {
        if (this.getServletContext() == null) {
            throw new LoadableResourceException("no reference to servlet context found");
        }
        InputStream input = null;
        Digester digester = this.initDigester();
        try {
            try {
                input = this.getServletContext().getResourceAsStream(this.config);
                digester.parse(input);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LoadableResourceException("Error parsing resource file: " + this.config + " nested exception is: " + e.getMessage());
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public void reload() throws LoadableResourceException {
        this.menus.clear();
        this.displayers.clear();
        this.load();
    }

    public void setLoadParam(String loadParam) {
        this.config = loadParam;
    }

    public String getLoadParam() {
        return this.config;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    public MenuComponent getMenu(String menuName, String delimiter) {
        MenuComponent parent = null;
        StringTokenizer st = new StringTokenizer(menuName, delimiter);
        boolean firstMenu = true;
        while (st.hasMoreTokens()) {
            if (firstMenu) {
                parent = this.getMenu(st.nextToken());
                firstMenu = false;
                continue;
            }
            MenuComponent child = null;
            String name = st.nextToken();
            int a = 0;
            while (a < parent.getComponents().size()) {
                if (name.equals(((MenuComponent)parent.getComponents().get(a)).getName())) {
                    child = (MenuComponent)parent.getComponents().get(a);
                    a = parent.getComponents().size();
                }
                ++a;
            }
            if (child != null) {
                parent = child;
                continue;
            }
            parent = null;
            break;
        }
        return parent;
    }

    public int getMenuDepth(String menuName) {
        MenuComponent menu = this.getMenu(menuName);
        if (menu == null) {
            return -1;
        }
        if (menu.getMenuComponents() == null) {
            return 1;
        }
        return menu.getMenuDepth();
    }

    public int getMenuDepth() {
        int currentDepth = 0;
        List topMenus = this.getTopMenus();
        if (topMenus == null) {
            return -1;
        }
        Iterator menu = topMenus.iterator();
        while (menu.hasNext()) {
            int depth = ((MenuComponent)menu.next()).getMenuDepth();
            if (currentDepth >= depth) continue;
            currentDepth = depth;
        }
        return currentDepth;
    }

    public MenuComponent[] getTopMenusAsArray() {
        List menuList = this.getTopMenus();
        MenuComponent[] menus = new MenuComponent[menuList.size()];
        int a = 0;
        while (a < menuList.size()) {
            menus[a] = (MenuComponent)menuList.get(a);
            ++a;
        }
        return menus;
    }

    public List getTopMenusNames() {
        List menus = this.getTopMenus();
        ArrayList<String> names = new ArrayList<String>();
        for (MenuComponent menu : menus) {
            names.add(menu.getName());
        }
        return names;
    }

    public void setBreadCrumbDelimiter(String string) {
        this.breadCrumbDelimiter = string;
    }

    public void buildBreadCrumbs() {
        if (this.breadCrumbDelimiter == null) {
            throw new NullPointerException("No breadCrumbDelimiter present");
        }
        ArrayList menus = (ArrayList)this.getTopMenus();
        for (MenuComponent menu : menus) {
            menu.setBreadCrumb(this.breadCrumbDelimiter);
        }
    }

    public void buildBreadCrumbs(String delimiter) {
        this.breadCrumbDelimiter = delimiter;
        this.buildBreadCrumbs();
    }
}

