/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.menu;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sf.navigator.menu.MenuComponent;
import net.sf.navigator.menu.PermissionsAdapter;

public class RolesPermissionsAdapter
implements PermissionsAdapter {
    private Pattern delimiters = Pattern.compile("(?<!\\\\),");
    private HttpServletRequest request;

    public RolesPermissionsAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public boolean isAllowed(MenuComponent menu) {
        if (menu.getRoles() == null) {
            return true;
        }
        String[] allowedRoles = this.delimiters.split(menu.getRoles());
        int i = 0;
        while (i < allowedRoles.length) {
            if (this.request.isUserInRole(allowedRoles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

