/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.taglib;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.navigator.displayer.MenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import net.sf.navigator.menu.MenuRepository;
import net.sf.navigator.taglib.UseMenuDisplayerTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

public class DisplayMenuTag
extends TagSupport {
    protected static final Log log = LogFactory.getLog(DisplayMenuTag.class);
    private String name;
    private String target;

    public void setName(String name) {
        this.name = name;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int doStartTag() throws JspException {
        MenuDisplayer displayer = (MenuDisplayer)this.pageContext.getAttribute("net.sf.navigator.taglib.DISPLAYER");
        if (displayer == null) {
            throw new JspException("Could not retrieve the menu displayer.");
        }
        MenuRepository repository = (MenuRepository)this.pageContext.getAttribute("net.sf.navigator.repositoryKey");
        if (repository == null) {
            throw new JspException("Could not obtain the menu repository");
        }
        MenuComponent menu = repository.getMenu(this.name);
        if (menu != null) {
            try {
                if (this.target != null) {
                    displayer.setTarget(this.target);
                }
                try {
                    this.setPageLocation(menu);
                }
                catch (MalformedURLException m) {
                    log.error((Object)("Incorrect action or forward: " + m.getMessage()));
                    log.warn((Object)("Menu '" + menu.getName() + "' location set to #"));
                    menu.setLocation("#");
                }
                displayer.display(menu);
                displayer.setTarget(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JspException((Throwable)e);
            }
        }
        String error = String.valueOf(UseMenuDisplayerTag.messages.getString("menu.not.found")) + " " + this.name;
        log.warn((Object)error);
        try {
            this.pageContext.getOut().write(error);
        }
        catch (IOException io) {
            throw new JspException(error);
        }
        return 0;
    }

    protected void setPageLocation(MenuComponent menu) throws MalformedURLException, JspException {
        MenuComponent[] subMenus;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.setLocation(menu);
        String url = menu.getLocation();
        if (url != null && url.indexOf("${") > -1) {
            String queryString = null;
            if (url.indexOf("?") > -1) {
                queryString = url.substring(url.indexOf("?") + 1);
                url = url.substring(0, url.indexOf(queryString));
            }
            if (queryString != null) {
                menu.setUrl(String.valueOf(url) + this.parseString(queryString, request));
            } else {
                menu.setUrl(this.parseString(queryString, request).toString());
            }
        } else {
            menu.setUrl(url);
        }
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        if (menu.getUrl() != null) {
            menu.setUrl(response.encodeURL(menu.getUrl()));
        }
        if ((subMenus = menu.getMenuComponents()).length > 0) {
            int i = 0;
            while (i < subMenus.length) {
                this.setPageLocation(subMenus[i]);
                ++i;
            }
        }
    }

    protected void setLocation(MenuComponent menu) throws MalformedURLException {
        block9: {
            if (menu.getLocation() == null) {
                try {
                    if (menu.getPage() != null) {
                        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
                        menu.setLocation(String.valueOf(request.getContextPath()) + this.getPage(menu.getPage()));
                    } else if (menu.getForward() != null) {
                        menu.setLocation(TagUtils.getInstance().computeURL(this.pageContext, menu.getForward(), null, null, null, menu.getModule(), null, null, false));
                    } else if (menu.getAction() != null) {
                        menu.setLocation(TagUtils.getInstance().computeURL(this.pageContext, null, null, null, menu.getAction(), menu.getModule(), null, null, false));
                    }
                }
                catch (NoClassDefFoundError e) {
                    if (menu.getForward() != null) {
                        throw new MalformedURLException("forward '" + menu.getForward() + "' invalid - no struts.jar");
                    }
                    if (menu.getAction() == null) break block9;
                    throw new MalformedURLException("action '" + menu.getAction() + "' invalid - no struts.jar");
                }
            }
        }
    }

    protected String getPage(String page) {
        if (page.startsWith("/")) {
            return page;
        }
        page = "/" + page;
        return page;
    }

    private StringBuffer parseString(String str, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        while (str.indexOf("${") >= 0) {
            sb.append(str.substring(0, str.indexOf("${")));
            String variable = str.substring(str.indexOf("${") + 2, str.indexOf("}"));
            String value = (String)this.pageContext.findAttribute(variable);
            if (value == null) {
                value = request.getParameter(variable);
            }
            if (value == null) {
                log.warn((Object)("Value for '" + variable + "' not found in pageContext or as a request parameter"));
            }
            sb.append(value);
            str = str.substring(str.indexOf("}") + 1, str.length());
        }
        return sb.append(str);
    }

    public void release() {
        this.name = null;
        this.target = null;
    }
}

