/*
 * Decompiled with CFR 0.152.
 */
package org.webtree.view;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.webtree.TreeMessage;
import org.webtree.TreeView;

public class BaseTreeView
implements TreeView {
    protected Hashtable openNodes = new Hashtable();
    protected Hashtable selectedNodes = new Hashtable();
    protected Properties properties = new Properties();
    protected String theme;
    public String imagePath = "/images/tree/";
    public String selfHref = "tree.jsp";
    protected String customExpandListener;
    protected String customCollapseListener;
    protected String customSelectListener;

    public BaseTreeView() {
    }

    public BaseTreeView(String selfHref, String imagePath) {
        this();
        this.selfHref = selfHref;
        this.imagePath = imagePath;
    }

    public boolean addOpenNode(String nodeId) {
        return this.openNodes.put(nodeId, nodeId) != null;
    }

    public boolean removeOpenNode(String nodeId) {
        return this.openNodes.remove(nodeId) != null;
    }

    public boolean isNodeOpen(String nodeId) {
        return this.openNodes.get(nodeId) != null;
    }

    public String[] getOpenNodes() {
        int openNodeCount = this.openNodes.size();
        String[] openNodesIds = new String[openNodeCount];
        int i = 0;
        Enumeration e = this.openNodes.keys();
        while (e.hasMoreElements()) {
            openNodesIds[i++] = (String)e.nextElement();
        }
        return openNodesIds;
    }

    public int getOpenNodeCount() {
        return this.openNodes.size();
    }

    public boolean addSelectedNode(String nodeId) {
        return this.selectedNodes.put(nodeId, nodeId) != null;
    }

    public boolean removeSelectedNode(String nodeId) {
        return this.selectedNodes.remove(nodeId) != null;
    }

    public void removeSelectedNodes() {
        this.selectedNodes.clear();
    }

    public boolean isNodeSelected(String nodeId) {
        return this.selectedNodes.get(nodeId) != null;
    }

    public int getSelectedNodeCount() {
        return this.selectedNodes.size();
    }

    public String[] getSelectedNodes() {
        int selectedNodeCount = this.selectedNodes.size();
        String[] selectedNodesIds = new String[selectedNodeCount];
        int i = 0;
        Enumeration e = this.selectedNodes.keys();
        while (e.hasMoreElements()) {
            selectedNodesIds[i++] = (String)e.nextElement();
        }
        return selectedNodesIds;
    }

    public String getSelectedNode() {
        Enumeration e = this.selectedNodes.keys();
        if (e.hasMoreElements()) {
            return (String)e.nextElement();
        }
        return null;
    }

    public String[] getPropertyNames() {
        Enumeration<?> e = this.properties.propertyNames();
        String[] propNames = new String[this.properties.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            propNames[i++] = (String)e.nextElement();
        }
        return propNames;
    }

    public boolean hasProperty(String propName) {
        return this.properties.getProperty(propName) != null;
    }

    public String getProperty(String propName) {
        return this.properties.getProperty(propName);
    }

    public String getProperty(String propName, String defaultValue) {
        return this.properties.getProperty(propName, defaultValue);
    }

    public String[] getPropertyArray(String propName) {
        String val = this.properties.getProperty(propName);
        if (val == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(val, ",");
        String[] retVal = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            retVal[i] = st.nextToken();
        }
        return retVal;
    }

    public boolean isPropertyArray(String propName) {
        String[] retVal = this.getPropertyArray(propName);
        return retVal.length > 0;
    }

    public void setProperty(String propName, String propValue) {
        this.properties.setProperty(propName, propValue);
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setSelfHref(String selfHref) {
        this.selfHref = selfHref;
    }

    public String getSelfHref() {
        return this.selfHref;
    }

    public void processTreeMessage(TreeMessage message) {
        if (message == null) {
            return;
        }
        switch (message.getType()) {
            case 1: {
                this.removeOpenNode(message.getId());
                break;
            }
            case 2: {
                this.addOpenNode(message.getId());
                break;
            }
            case 3: {
                this.removeSelectedNodes();
                this.addSelectedNode(message.getId());
            }
        }
    }

    public void setCustomExpandListener(String jsFunctionName) {
        this.customExpandListener = jsFunctionName;
    }

    public void setCustomCollapseListener(String jsFunctionName) {
        this.customCollapseListener = jsFunctionName;
    }

    public void setCustomSelectListener(String jsFunctionName) {
        this.customSelectListener = jsFunctionName;
    }

    public String getCustomCollapseListener() {
        return this.customCollapseListener;
    }

    public String getCustomExpandListener() {
        return this.customExpandListener;
    }

    public String getCustomSelectListener() {
        return this.customSelectListener;
    }
}

