/*
 * Decompiled with CFR 0.152.
 */
package com.twc.isa.PackageModule;

import com.n2bb.utils.N2BBDebug;
import com.twc.isa.PackageModule.Package;
import com.twc.isa.PackageModule.PackageFactory;
import com.twc.isa.PackageModule.PackageFactoryHelper;
import com.twc.isa.PackageModule.PackageHelper;
import com.twc.isa.PackageModule.TransferException;
import com.twc.isa.PackageModule.VersionException;
import com.twc.isa.PackageModule.XmlProcessingException;
import com.twc.isa.ServerModule.AdministrativeState;
import com.twc.isa.ServerModule.DuplicateServant;
import com.twc.isa.ServerModule.InvalidName;
import com.twc.isa.ServerModule.InvalidStateChange;
import com.twc.isa.ServerModule.OutOfService;
import com.twc.isa.ServerModule.ProvisioningFailed;
import com.twc.isa.ServerModule.ServantBase_impl;
import com.twc.isa.ServerModule.ServantCreateFailed;
import com.twc.isa.ServerModule.UnspecifiedException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class PackageClient {
    public static final boolean TRY_TO_FIND_FIRST = true;

    public static void main(String[] args) {
        if (args.length < 2) {
            N2BBDebug.log(1, "usage: PackageClient packageName packageURL (nameService)");
        } else {
            String packageName = args[0];
            String strURLName = args[1];
            try {
                if (args.length > 2) {
                    String nameService = args[2];
                    PackageClient.provision(packageName, strURLName, nameService);
                } else {
                    PackageClient.provision(packageName, strURLName);
                }
            }
            catch (Exception e) {
                N2BBDebug.err(1, "Exception = " + e.getMessage());
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    N2BBDebug.err(1, "Cause = " + e.getCause().getMessage());
                }
                N2BBDebug.logStackTrace(e);
            }
        }
    }

    public static void provision(String packageName, String strURLName) throws ProvisioningFailed, UnspecifiedException, DuplicateServant, OutOfService, TransferException, ServantCreateFailed, InvalidName, XmlProcessingException, VersionException, InvalidStateChange {
        PackageClient.provision(packageName, strURLName, null);
    }

    public static void provision(String packageName, String strURLName, String nameService) throws ProvisioningFailed, UnspecifiedException, DuplicateServant, OutOfService, TransferException, ServantCreateFailed, InvalidName, XmlProcessingException, VersionException, InvalidStateChange {
        ORB orb = null;
        String[] args = null;
        if (nameService == null) {
            N2BBDebug.log(1, "nameService is null");
            args = new String[]{};
        } else {
            N2BBDebug.log(1, "nameService =" + nameService);
            args = new String[]{"-ORBInitRef", "NameService=" + nameService};
        }
        N2BBDebug.log(1, "Envoking orb_main on ServantBase_impl.");
        orb = ServantBase_impl.orb_main(args);
        String[] strFullPath = new String[]{"Factories", "PackageFactory"};
        Object obj = ServantBase_impl.getFactoryObject(orb, strFullPath);
        if (obj == null) {
            throw new NullPointerException("Factory object from ISA is null");
        }
        PackageFactory Packagefactory = PackageFactoryHelper.narrow((Object)obj);
        Package package_ = null;
        try {
            package_ = PackageHelper.narrow((Object)Packagefactory.find(packageName));
        }
        catch (Exception e) {
            N2BBDebug.log(1, "Failed to locate existing package, moving on to createServant.");
        }
        if (package_ == null) {
            package_ = PackageHelper.narrow((Object)Packagefactory.createServant(packageName));
        }
        package_.provision(AdministrativeState.as_InService, strURLName);
        N2BBDebug.log(1, "Provision Completed.");
    }
}

