/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.core;

import com.tandbergtv.watchpoint.watchfolder.core.DirectoryEntry;
import com.tandbergtv.watchpoint.watchfolder.core.DirectoryMonitor;
import com.tandbergtv.watchpoint.watchfolder.core.FTPDirectoryMonitor;
import com.tandbergtv.watchpoint.watchfolder.core.LocalDirectoryMonitor;
import com.tandbergtv.watchpoint.watchfolder.core.Processor;
import com.tandbergtv.watchpoint.watchfolder.core.WPFileFilter;
import com.tandbergtv.watchpoint.watchfolder.core.WatchfolderConfiguration;
import com.tandbergtv.watchpoint.watchfolder.core.WatchfolderConfigurationReader;
import com.tandbergtv.watchpoint.watchfolder.util.WatchfolderProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class WatchFolderManager {
    private static Logger logger = Logger.getLogger(WatchFolderManager.class);
    private static WatchFolderManager instance = new WatchFolderManager();
    private Map<String, DirectoryMonitor> monitors = new HashMap<String, DirectoryMonitor>();
    private boolean isInitialized = false;
    private static final String FTP_URL_PREFIX = "ftp:";
    private Set<Timer> timers = new HashSet<Timer>();
    private List<Processor> processors = new ArrayList<Processor>();
    private String configuration;

    private WatchFolderManager() {
    }

    public static WatchFolderManager getInstance() {
        return instance;
    }

    public synchronized void initialize() {
        this.initializeWatchfolderManager();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    private void initializeWatchfolderManager() {
        if (this.isInitialized) {
            return;
        }
        logger.info((Object)"Initializing the WatchfolderManager...");
        try {
            WatchfolderProperties.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load WatchFolder properties.", e);
        }
        WatchfolderConfigurationReader reader = new WatchfolderConfigurationReader();
        WatchfolderConfiguration config = reader.readConfiguration(this.configuration);
        List<DirectoryEntry> directories = config.getDirectories();
        for (DirectoryEntry dir : directories) {
            this.processDirectoryEntry(dir);
        }
        HashSet<String> startedMonitors = new HashSet<String>();
        for (DirectoryEntry dir : directories) {
            if (startedMonitors.contains(dir.getName())) continue;
            this.startDirectoryMonitors(dir);
            logger.info((Object)("DirectoryMonitor for " + dir.getName() + " started"));
            startedMonitors.add(dir.getName());
        }
        this.isInitialized = true;
    }

    private void startDirectoryMonitors(DirectoryEntry dir) {
        DirectoryMonitor monitor = this.monitors.get(dir.getName());
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)monitor, new Date(), (long)(1000 * dir.getFrequency()));
    }

    private void processDirectoryEntry(DirectoryEntry dir) {
        String dirName = dir.getName();
        if (!dirName.toLowerCase().startsWith(FTP_URL_PREFIX)) {
            this.processLocalDirectoryEntry(dir);
        } else {
            this.processFTPDirectoryEntry(dir);
        }
    }

    private Processor createProcessor(DirectoryEntry dir) {
        String processName = dir.getProcessClass();
        String events = dir.getEvents();
        Map<String, String> parameterList = dir.getParameterList();
        Processor processor = new Processor(processName, dir.getNumThreads(), events, parameterList);
        this.processors.add(processor);
        return processor;
    }

    private void processLocalDirectoryEntry(DirectoryEntry dir) {
        LocalDirectoryMonitor monitor;
        String dirName = dir.getName();
        String fileFilters = dir.getFileFilter();
        Processor processor = this.createProcessor(dir);
        HashSet<WPFileFilter> ffSet = new HashSet<WPFileFilter>();
        StringTokenizer st = new StringTokenizer(fileFilters, ",");
        if (st.countTokens() > 0) {
            while (st.hasMoreTokens()) {
                String filter = st.nextToken();
                WPFileFilter wpFF = new WPFileFilter(filter);
                ffSet.add(wpFF);
            }
        } else {
            WPFileFilter wpFF = new WPFileFilter();
            ffSet.add(wpFF);
        }
        if (!this.monitors.containsKey(dirName)) {
            monitor = new LocalDirectoryMonitor(dirName, ffSet, processor);
            this.monitors.put(dirName, monitor);
        } else {
            monitor = (LocalDirectoryMonitor)this.monitors.get(dirName);
            monitor.register(ffSet, processor);
        }
    }

    private void processFTPDirectoryEntry(DirectoryEntry dir) {
        FTPDirectoryMonitor monitor;
        String dirName = dir.getName();
        String fileFilters = dir.getFileFilter();
        Processor processor = this.createProcessor(dir);
        HashSet<WPFileFilter> ffSet = new HashSet<WPFileFilter>();
        StringTokenizer st = new StringTokenizer(fileFilters, ",");
        if (st.countTokens() > 0) {
            while (st.hasMoreTokens()) {
                String filter = st.nextToken();
                WPFileFilter wpFF = new WPFileFilter(filter);
                ffSet.add(wpFF);
            }
        } else {
            ffSet.add(new WPFileFilter(new String()));
        }
        if (!this.monitors.containsKey(dirName)) {
            monitor = new FTPDirectoryMonitor(dirName, ffSet, processor);
            this.monitors.put(dirName, monitor);
        } else {
            monitor = (FTPDirectoryMonitor)this.monitors.get(dirName);
            monitor.register(ffSet, processor);
        }
    }

    public void shutdown() {
        logger.debug((Object)"Shutting down WatchFolder Manager");
        for (Timer timer : this.timers) {
            timer.cancel();
        }
        HashSet<DirectoryMonitor> timerTasks = new HashSet<DirectoryMonitor>(this.monitors.values());
        for (DirectoryMonitor task : timerTasks) {
            task.cancel();
        }
        for (Processor processor : this.processors) {
            processor.shutdown();
        }
        logger.debug((Object)"WatchFolder Manager is shutdown");
    }
}

