/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.mstv;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import com.tandbergtv.metadatamanager.specimpl.mstv.MSTVIdentifier;
import java.util.HashMap;
import java.util.Map;

public class MSTVSpecHandler
extends SingleTitleSpecHandler {
    private static final String MSTV_ROOTELEMENT_NAME = "assetPackages";

    public MSTVSpecHandler() {
        this.alias = "MSTV";
        this.rootElementName = MSTV_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        MSTVIdentifier id = new MSTVIdentifier();
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        id.setSearchService(this.getSearchService());
        HashMap<String, String> idValues = new HashMap<String, String>();
        Map<String, String> idXPaths = id.getTTVPaths();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        MSTVIdentifier identifier = new MSTVIdentifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }
}

