<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
<xsl:import href="from/rating.xsl"/>

<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'TITLE']">
	<metadata>
		<assetID><xsl:value-of select="../../tns:TTVSpec/tns:Group[@type = 'PACKAGE']/tns:Fields/tns:Identifier/tns:Id" /></assetID>
		<title>
			<xsl:attribute name="language">
				<xsl:value-of select="tns:Fields/tns:Title/tns:DisplayTitle/tns:Language/@value" />
			</xsl:attribute>
			<xsl:value-of select="tns:Fields/tns:Title/tns:DisplayTitle/tns:Value" />
		</title>
		<xsl:if test="tns:Fields/tns:Title/tns:SortTitle/tns:Value">
			<sortTitle>
				<xsl:attribute name="language">
					<xsl:value-of select="tns:Fields/tns:Title/tns:SortTitle/tns:Language/@value" />
				</xsl:attribute>
				<xsl:value-of select="tns:Fields/tns:Title/tns:SortTitle/tns:Value" />
			</sortTitle>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Title/tns:ShortTitle/tns:Value">
			<reducedTitle>
				<xsl:attribute name="language">
					<xsl:value-of select="tns:Fields/tns:Title/tns:ShortTitle/tns:Language/@value" />
				</xsl:attribute>
				<xsl:value-of select="tns:Fields/tns:Title/tns:ShortTitle/tns:Value" />
			</reducedTitle>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Title/tns:OriginalTitle/tns:Value">
			<originalTitle>
				<xsl:attribute name="language">
					<xsl:value-of select="tns:Fields/tns:Title/tns:OriginalTitle/tns:Language/@value" />
				</xsl:attribute>
				<xsl:value-of select="tns:Fields/tns:Title/tns:OriginalTitle/tns:Value" />
			</originalTitle>
		</xsl:if>
		<summary>
			<xsl:attribute name="language">
				<xsl:value-of select="tns:Fields/tns:Summary/tns:DisplaySummary/tns:Language/@value" />
			</xsl:attribute>
			<xsl:value-of select="tns:Fields/tns:Summary/tns:DisplaySummary/tns:Value" />
		</summary>
		<xsl:if test="tns:Fields/tns:Summary/tns:ShortSummary/tns:Value">
			<shortSummary>
				<xsl:attribute name="language">
					<xsl:value-of select="tns:Fields/tns:Summary/tns:ShortSummary/tns:Language/@value" />
				</xsl:attribute>
				<xsl:value-of select="tns:Fields/tns:Summary/tns:ShortSummary/tns:Value" />
			</shortSummary>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Episode/tns:Name/tns:Value">
			<episodeTitle>
				<xsl:attribute name="language">
					<xsl:value-of select="tns:Fields/tns:Episode/tns:Name/tns:Language/@value" />
				</xsl:attribute>
				<xsl:value-of select="tns:Fields/tns:Episode/tns:Name/tns:Value" />
			</episodeTitle>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Episode/tns:Number">
			<episodeNumber>
				<xsl:value-of select="tns:Fields/tns:Episode/tns:Number" />
			</episodeNumber>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Copyright/tns:MacroVisionLevel">
			<macrovisionLevel>
				<xsl:value-of select="tns:Fields/tns:Copyright/tns:MacroVisionLevel" />
			</macrovisionLevel>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Copyright/tns:CGMSA">
			<cgmsaLevel>
				<xsl:value-of select="tns:Fields/tns:Copyright/tns:CGMSA" />
			</cgmsaLevel>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Copyright/tns:disableHDCP">
			<disableHDCP>
				<xsl:value-of select="tns:Fields/tns:Copyright/tns:disableHDCP" />
			</disableHDCP>
		</xsl:if>
		<xsl:apply-templates select="tns:Fields/tns:Rating" />
		<xsl:if test="tns:Fields/tns:Categorization/tns:Category">
			<categorization>
				<xsl:for-each select="tns:Fields/tns:Categorization/tns:Category">
					<category1>
						<xsl:attribute name="name">
							<xsl:value-of select="tns:Text" />
						</xsl:attribute>
						<category2>
							<xsl:attribute name="name">
								<xsl:value-of select="tns:Category/tns:Text" />
							</xsl:attribute>
						</category2>
					</category1>
				</xsl:for-each>
			</categorization>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Duration/tns:Duration">
			<runTimeMinutes>
				<xsl:choose>
					<xsl:when test="not(matches(tns:Fields/tns:Duration/tns:Duration, '\d{2}:\d{2}:\d{2}'))">
						<xsl:value-of select="tns:Fields/tns:Duration/tns:Duration"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="round((number(substring-before(tns:Fields/tns:Duration/tns:Duration, ':')) * 60 
						+ number(substring-before(substring-after(tns:Fields/tns:Duration/tns:Duration, ':'), ':')) 
						+ number(substring-after(substring-after(tns:Fields/tns:Duration/tns:Duration, ':'), ':')) div 60) * 100) div 100" />
				</xsl:otherwise>
				</xsl:choose>
			</runTimeMinutes>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:CreationInfo/tns:PublicationDate">
			<release_year>
				<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:PublicationDate" />
			</release_year>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:CreationInfo/tns:Place/tns:Country">
			<countryRegionCode>
				<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Place/tns:Country" />
			</countryRegionCode>
		</xsl:if>
		<xsl:for-each select="tns:Fields/tns:Source">
			<person>
				<xsl:attribute name="role">
					<xsl:if test="tns:Role/tns:Name!='GUESTSTAR'">
						<xsl:value-of select="translate(tns:Role/tns:Name, $uppercase, $smallcase)" />
					</xsl:if>
					<xsl:if test="tns:Role/tns:Name='GUESTSTAR'">guestStar</xsl:if>
				</xsl:attribute>
				<xsl:attribute name="lname">
					<xsl:value-of select="tns:Contact/tns:LastName" />
				</xsl:attribute>
				<xsl:attribute name="fname">
					<xsl:value-of select="tns:Contact/tns:FirstName" />
				</xsl:attribute>
				<xsl:attribute name="mname">
					<xsl:value-of select="tns:Contact/tns:MiddleName" />
				</xsl:attribute>
			</person>
		</xsl:for-each>
		<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name">
			<studio>
				<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name" />
			</studio>
		</xsl:if>
		<xsl:for-each select="tns:Fields/tns:Category/tns:Text">
			<category>
				<xsl:value-of select="." />
			</category>
		</xsl:for-each>
		<xsl:if test="tns:Fields/tns:RdpApp/tns:Text">
			<RdpApp>
				<xsl:attribute name="isWebApplication">
					<xsl:value-of select="tns:Fields/tns:RdpApp/tns:Text" />
				</xsl:attribute>
			</RdpApp>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Locator/tns:Uri">
			<url>
				<xsl:value-of select="tns:Fields/tns:Locator/tns:Uri" />
			</url>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Locator/tns:PipUri">
			<pipurl>
				<xsl:value-of select="tns:Fields/tns:Locator/tns:PipUri" />
			</pipurl>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:PropagationPriority">
			<importPriority>
				<xsl:value-of select="tns:Fields/tns:PropagationPriority" />
			</importPriority>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoImport">
			<autoImport>
				<xsl:value-of select="tns:Fields/tns:AutoImport" />
			</autoImport>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoDeploy">
			<autoDeploy>
				<xsl:value-of select="tns:Fields/tns:AutoDeploy" />
			</autoDeploy>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoDelete">
			<autoDelete>
				<xsl:value-of select="tns:Fields/tns:AutoDelete" />
			</autoDelete>
		</xsl:if>
	</metadata>
	<businessMetadata>
		<xsl:if test="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value">
			<suggestedPrice>
				<xsl:value-of select="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value" />
			</suggestedPrice>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Currency">
			<currency_iso3166-2>
				<xsl:value-of select="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Currency" />
			</currency_iso3166-2>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:BillingInfo/tns:CreateOffer">
			<createOffer>
				<xsl:value-of select="tns:Fields/tns:BillingInfo/tns:CreateOffer" />
			</createOffer>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:BillingInfo/tns:AggregatorId/tns:Id">
			<billingIDAggregator>
				<xsl:value-of select="tns:Fields/tns:BillingInfo/tns:AggregatorId/tns:Id" />
			</billingIDAggregator>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:BillingInfo/tns:ProviderId/tns:Id">
			<billingIDProvider>
				<xsl:value-of select="tns:Fields/tns:BillingInfo/tns:ProviderId/tns:Id" />
			</billingIDProvider>
		</xsl:if>
	</businessMetadata>
	<rightsMetadata>
		<licensingWindowStart>
			<xsl:value-of select="if(contains(tns:Fields/tns:Rights/tns:LicensingWindowStart, '.'))
									then substring-before(tns:Fields/tns:Rights/tns:LicensingWindowStart, '.')
									else tns:Fields/tns:Rights/tns:LicensingWindowStart" />
		</licensingWindowStart>
		<licensingWindowEnd>
			<xsl:value-of select="if(contains(tns:Fields/tns:Rights/tns:LicensingWindowEnd, '.'))
									then substring-before(tns:Fields/tns:Rights/tns:LicensingWindowEnd, '.')
									else tns:Fields/tns:Rights/tns:LicensingWindowEnd" />
		</licensingWindowEnd>
		<xsl:if test="tns:Fields/tns:Rights/tns:AvailabilityWindowStart">
			<availabilityWindowStart>
				<xsl:value-of select="if(contains(tns:Fields/tns:Rights/tns:AvailabilityWindowStart, '.'))
										then substring-before(tns:Fields/tns:Rights/tns:AvailabilityWindowStart, '.')
										else tns:Fields/tns:Rights/tns:AvailabilityWindowStart" />
			</availabilityWindowStart>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:AvailabilityWindowEnd">
			<availabilityWindowEnd>
				<xsl:value-of select="if(contains(tns:Fields/tns:Rights/tns:AvailabilityWindowEnd, '.'))
										then substring-before(tns:Fields/tns:Rights/tns:AvailabilityWindowEnd, '.')
										else tns:Fields/tns:Rights/tns:AvailabilityWindowEnd" />
			</availabilityWindowEnd>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:NewReleaseWindow">
			<newReleaseWindow>
				<xsl:value-of select="tns:Fields/tns:Rights/tns:NewReleaseWindow" />
			</newReleaseWindow>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:MaxPlayCount">
			<maximumPlayCount>
				<xsl:value-of select="tns:Fields/tns:Rights/tns:MaxPlayCount" />
			</maximumPlayCount>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:DisplayAsLastChance">
			<lastChanceWindow>
				<xsl:value-of select="tns:Fields/tns:Rights/tns:DisplayAsLastChance" />
			</lastChanceWindow>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:MaxViewingLimit">
			<maximumViewingLimit>
				<xsl:value-of select="tns:Fields/tns:Rights/tns:MaxViewingLimit" />
			</maximumViewingLimit>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:MinViewingLimit">
			<minimumViewingLimit>
				<xsl:value-of select="tns:Fields/tns:Rights/tns:MinViewingLimit" />
			</minimumViewingLimit>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration">
			<previewPeriod>
				<xsl:value-of select="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration" />
			</previewPeriod>
		</xsl:if>
	</rightsMetadata>
</xsl:template>
</xsl:stylesheet>
