<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:import href="to/idMetadata.xsl"/>
	<xsl:import href="to/commonMetadata.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="metadata" mode="asset_metadata">
		<xsl:apply-templates mode="id_metadata" select="*"/>
		<xsl:apply-templates mode="common_metadata" select="*"/>
		<xsl:if test="screenFormat or HD">
			<xsl:element name="tns:Video">
				<xsl:apply-templates select="screenFormat" mode="video_metadata"/>
				<xsl:apply-templates select="HD" mode="video_metadata"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="count(language_iso639) &gt; 0">
			<xsl:for-each select="language_iso639">
				<xsl:element name="tns:Language">
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="count(audio) &gt; 0">
			<xsl:for-each select="audio">
				<xsl:element name="tns:Audio">
					<xsl:element name="tns:Type">
						<xsl:value-of select="."/>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="count(subtitleLanguage_iso639) &gt; 0">
			<xsl:for-each select="subtitleLanguage_iso639">
				<xsl:element name="tns:SubTitleLanguage">
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="count(dubbedLanguage_iso639) &gt; 0">
			<xsl:for-each select="dubbedLanguage_iso639">
				<xsl:element name="tns:DubbedLanguage">
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		<xsl:apply-templates select="*" mode="asset_metadata"/>
	</xsl:template>
	<xsl:template match="providerId" mode="asset_metadata">
		<xsl:element name="tns:ProviderInfo">
			<xsl:element name="tns:Identifier">
				<xsl:element name="tns:Id">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="screenFormat" mode="video_metadata">
		<xsl:element name="tns:ScreenFormat">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="HD" mode="video_metadata">
		<xsl:element name="tns:HDContent">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="asset_metadata"/>
</xsl:stylesheet>
