<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema"  xmlns:xs="http://www.w3.org/2001/XMLSchema"
 version="1.0">
	<xsl:import href="to/commonMetadata.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<!-- rightsMetadata optional -->
	<xsl:template match="rightsMetadata" mode="package_metadata">
		<xsl:element name="tns:Rights">
			<xsl:element name="tns:LicensingWindowStart">
				<xsl:value-of select="licensingWindowStart"/>
			</xsl:element>
			<xsl:element name="tns:LicensingWindowEnd">
				<xsl:value-of select="licensingWindowEnd"/>
			</xsl:element>
			<xsl:apply-templates select="*" mode="rightsMetadataOptional"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="availabilityWindowStart" mode="rightsMetadataOptional">
		<xsl:element name="tns:AvailabilityWindowStart">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="availabilityWindowEnd" mode="rightsMetadataOptional">
		<xsl:element name="tns:AvailabilityWindowEnd">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="newReleaseWindow" mode="rightsMetadataOptional">
		<xsl:element name="tns:NewReleaseWindow">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="maximumPlayCount" mode="rightsMetadataOptional">
		<xsl:element name="tns:MaxPlayCount">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="lastChanceWindow" mode="rightsMetadataOptional">
		<xsl:element name="tns:DisplayAsLastChance">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="maximumViewingLimit" mode="rightsMetadataOptional">
		<xsl:element name="tns:MaxViewingLimit"><xsl:value-of select="."/></xsl:element>
	</xsl:template>
	<xsl:template match="minimumViewingLimit" mode="rightsMetadataOptional">
		<xsl:element name="tns:MinViewingLimit"><xsl:value-of select="."/></xsl:element>
	</xsl:template>
	<xsl:template match="previewPeriod" mode="rightsMetadataOptional">
		<xsl:element name="tns:PreviewPeriod">
			<xsl:element name="tns:Duration">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="rightsMetadataOptional"/>
	<!-- end -->
	<xsl:template match="businessMetadata" mode="package_metadata">
		<xsl:element name="tns:BillingInfo">
			<xsl:if test="createOffer">
				<xsl:element name="tns:CreateOffer">
					<xsl:value-of select="createOffer"/>
				</xsl:element>
			</xsl:if>
			<xsl:if test="suggestedPrice or currency_iso3166-2">
				<xsl:element name="tns:SuggestedPrice">
					<xsl:apply-templates select="*" mode="suggestedPriceOptional"/>
				</xsl:element>
			</xsl:if>
			<xsl:if test="billingIDAggregator">
				<xsl:element name="tns:AggregatorId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="billingIDAggregator"/>
					</xsl:element>
				</xsl:element>
			</xsl:if>
			<xsl:if test="billingIDProvider">
				<xsl:element name="tns:ProviderId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="billingIDProvider"/>
					</xsl:element>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="metadata" mode="package_metadata">
		<xsl:apply-templates mode="common_metadata" select="*"/>
		<xsl:element name="tns:Summary">
			<xsl:apply-templates select="shortSummary" mode="summary_optional"/>
			<xsl:element name="tns:DisplaySummary">
				<xsl:apply-templates select="summary/@language" mode="language"/>
				<xsl:if test="summary">
					<xsl:element name="tns:Value">
						<xsl:value-of select="summary"/>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:Title">
			<xsl:element name="tns:DisplayTitle">
				<xsl:apply-templates select="title/@language" mode="language"/>
				<xsl:if test="title">
					<xsl:element name="tns:Value">
						<xsl:value-of select="title"/>
					</xsl:element>
				</xsl:if>
			</xsl:element>
			<xsl:apply-templates select="*" mode="title_optional"/>
		</xsl:element>
		<xsl:if test="episodeTitle or episodeNumber">
			<xsl:element name="tns:Episode">
				<xsl:apply-templates select="*" mode="episode_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="macrovisionLevel or cgmsaLevel or disableHDCP">
			<xsl:element name="tns:Copyright">
				<xsl:apply-templates select="*" mode="copyright_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="url or pipurl">
			<xsl:element name="tns:Locator">
				<xsl:apply-templates select="*" mode="url_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:element name="tns:Categorization">
			<xsl:for-each select="categorization/category1">
				<xsl:element name="tns:Category">
					<xsl:element name="tns:Text">
						<xsl:value-of select="@name"/>
					</xsl:element>
					<xsl:element name="tns:Category">
						<xsl:element name="tns:Text">
							<xsl:value-of select="category2/@name"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
		<xsl:if test="release_year or countryRegionCode">
			<xsl:element name="tns:CreationInfo">
				<xsl:apply-templates select="*" mode="creationInfoOptional"/>
			</xsl:element>
		</xsl:if>
		<xsl:for-each select="category">
			<xsl:element name="tns:Category">
				<xsl:element name="tns:Text">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:element>
		</xsl:for-each>
		<xsl:apply-templates select="*" mode="metadata_optional"/>
	</xsl:template>
	<xsl:template match="*" mode="package_metadata"/>
	<!-- suggestedPrice optional -->
	<xsl:template match="suggestedPrice" mode="suggestedPriceOptional">
		<xsl:element name="tns:Value">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="currency_iso3166-2" mode="suggestedPriceOptional">
		<xsl:element name="tns:Currency">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="suggestedPriceOptional"/>
	<!-- end -->
	<!-- creationInfo optional -->
	<xsl:template match="release_year" mode="creationInfoOptional">
		<xsl:element name="tns:PublicationDate"><xsl:value-of select="."/></xsl:element>
	</xsl:template>
	<xsl:template match="countryRegionCode" mode="creationInfoOptional">
		<xsl:element name="tns:Place">
			<xsl:element name="tns:Country">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="studio" mode="creationInfoOptional">
		<xsl:element name="tns:Studio">
			<xsl:element name="tns:Name">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="creationInfoOptional"/>
	<!-- end -->
	<!-- metadata optional -->
	<xsl:template match="runTimeMinutes" mode="metadata_optional">
		<xsl:element name="tns:Duration">
			<xsl:element name="tns:Duration"> 
				<xsl:variable name="minutes" select="number(.) mod 60"/>
				<xsl:variable name="hours" select="(number(.) - $minutes) div 60"/>
				<xsl:choose>
					<xsl:when test="not(string(.) castable as xs:integer) or number(.) &lt; 0  ">
						<xsl:value-of select="."/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
						<xsl:when test="$hours &lt; 10">
							<xsl:choose>
								<xsl:when test="$minutes &lt; 10">
									<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), concat('0', $minutes)), ':00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), $minutes), ':00')"/>
								</xsl:otherwise>
							</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$minutes &lt; 10">
										<xsl:value-of select="concat(concat(concat($hours, ':'), concat('0', $minutes)), ':00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="concat(concat(concat($hours, ':'), $minutes), ':00')"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="person" mode="metadata_optional">
		<xsl:element name="tns:Source">
			<xsl:element name="tns:Role">
				<xsl:element name="tns:Name">
					<xsl:value-of select="translate(@role,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name="tns:Contact">
				<xsl:element name="tns:LastName">
					<xsl:value-of select="@lname"/>
				</xsl:element>
				<xsl:element name="tns:MiddleName">
					<xsl:value-of select="@mname"/>
				</xsl:element>
				<xsl:element name="tns:FirstName">
					<xsl:value-of select="@fname"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="RdpApp" mode="metadata_optional">
		<xsl:element name="tns:RdpApp">
			<xsl:value-of select="@isWebApplication"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="importPriority" mode="metadata_optional">
		<xsl:element name="tns:PropagationPriority">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="autoImport" mode="metadata_optional">
		<xsl:element name="tns:AutoImport">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="autoDeploy" mode="metadata_optional">
		<xsl:element name="tns:AutoDeploy">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="autoDelete" mode="metadata_optional">
		<xsl:element name="tns:AutoDelete">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="metadata_optional"/>
	<!-- end -->
	<!-- url optional -->
	<xsl:template match="url" mode="url_optional">
		<xsl:element name="tns:Uri">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="pipurl" mode="url_optional">
		<xsl:element name="tns:PipUri">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="url_optional"/>
	<!-- end -->
	<!-- copyright optional -->
	<xsl:template match="macrovisionLevel" mode="copyright_optional">
		<xsl:element name="tns:MacroVisionLevel">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="cgmsaLevel" mode="copyright_optional">
		<xsl:element name="tns:CGMSA">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="disableHDCP" mode="copyright_optional">
		<xsl:element name="tns:disableHDCP">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="copyright_optional"/>
	<!-- end -->
	<!-- episode optional -->
	<xsl:template match="episodeNumber" mode="episode_optional">
		<xsl:if test="string-length(.) &gt; 0">
			<xsl:element name="tns:Number">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="episodeTitle" mode="episode_optional">
		<xsl:element name="tns:Name">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="episode_optional"/>
	<!-- end -->
	<!-- summary optional -->
	<xsl:template match="shortSummary" mode="summary_optional">
		<xsl:element name="tns:ShortSummary">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<!-- end -->
	<!-- title optional -->
	<xsl:template match="reducedTitle" mode="title_optional">
		<xsl:element name="tns:ShortTitle">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="sortTitle" mode="title_optional">
		<xsl:element name="tns:SortTitle">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="originalTitle" mode="title_optional">
		<xsl:element name="tns:OriginalTitle">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="title_optional"/>
	<!-- end -->
	<!-- asset -->
	<xsl:template name="assetTemplate">
		<xsl:param name="assetId"/>
		<xsl:variable name="el_name">
			<xsl:choose>
				<xsl:when test="@type = 'feature' or @type = 'trailer'">tns:Group</xsl:when>
				<xsl:otherwise>tns:Item</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:element name="{$el_name}">
			<xsl:attribute name="type"><xsl:if test="@type = 'feature'"><xsl:text>MOVIE</xsl:text></xsl:if><xsl:if test="@type = 'trailer'"><xsl:text>PREVIEW</xsl:text></xsl:if><xsl:if test="@type = 'poster'"><xsl:text>POSTER</xsl:text></xsl:if></xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="$assetId"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:ProviderInfo">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="/assetPackages/assetPackage[1]/@providerID"/>
						</xsl:element>
					</xsl:element>
					<xsl:if test="/assetPackages/assetPackage[1]/@providerName">
						<xsl:element name="tns:Name">
							<xsl:value-of select="/assetPackages/assetPackage[1]/@providerName"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
				<xsl:apply-templates select="metadata" mode="asset_metadata"/>
				<xsl:element name="tns:AssetName">
					<xsl:value-of select="@asset_name"/>
				</xsl:element>
				<xsl:apply-templates select="@*" mode="assetFieldsOptional"/>
				<xsl:element name="tns:Content">
					<xsl:element name="tns:Locator">
						<xsl:element name="tns:Uri">
							<xsl:value-of select="content"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="asset"/>
	<!-- assetFieldsOptional -->
	<xsl:template match="@profile" mode="assetFieldsOptional">
		<xsl:element name="tns:Profile">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@product" mode="assetFieldsOptional">
		<xsl:element name="tns:ProductInfo">
			<xsl:element name="tns:Name">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@autoImport" mode="assetFieldsOptional">
		<xsl:element name="tns:AutoImport">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@autoDeploy" mode="assetFieldsOptional">
		<xsl:element name="tns:AutoDeploy">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@autoDelete" mode="assetFieldsOptional">
		<xsl:element name="tns:AutoDelete">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@verb" mode="assetFieldsOptional">
		<xsl:element name="tns:Verb">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*" mode="assetFieldsOptional"/>
	<!-- end -->
	<!-- end -->
</xsl:stylesheet>
