/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.osvod;

import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class OpenStreamVODIdentifier
extends IdentifierBase
implements IIdentifier {
    private static final long serialVersionUID = -1933336632860939768L;
    public static String ASSETID_XPATH = "Asset_ID";
    public static String PROVIDERID_XPATH = "Provider_ID";
    private String assetId;
    private String providerId;

    public OpenStreamVODIdentifier() {
    }

    public OpenStreamVODIdentifier(String assetId, String providerId) {
        this.setAssetId(assetId);
        this.setProviderId(providerId);
    }

    public Map<String, String> getTTVPaths() {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        URL mappingResourceURL = this.getMappingResourceUrl();
        String assetXpath = MappingFileParser.getMapping((URL)mappingResourceURL, (String)ASSETID_XPATH);
        if (assetXpath == null || assetXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + ASSETID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(ASSETID_XPATH, assetXpath);
        String providerXpath = MappingFileParser.getMapping((URL)mappingResourceURL, (String)PROVIDERID_XPATH);
        if (providerXpath == null || providerXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + PROVIDERID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(PROVIDERID_XPATH, providerXpath);
        return ttvPaths;
    }

    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROVIDERID_XPATH, this.providerId);
        map.put(ASSETID_XPATH, this.assetId);
        return map;
    }

    public void setSpecIdentifiers(Map<String, String> identifiers) {
        String assetId = null;
        String providerId = null;
        if (identifiers != null) {
            assetId = identifiers.get(ASSETID_XPATH);
            providerId = identifiers.get(PROVIDERID_XPATH);
        }
        this.setAssetId(assetId);
        this.setProviderId(providerId);
    }

    public boolean isValidIdentifier() {
        return !this.isBlank(this.getAssetId()) && !this.isBlank(this.getProviderId());
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public int hashCode() {
        if (!this.isValidIdentifier()) {
            return super.hashCode();
        }
        int prime = 37;
        int result = 3;
        result = 37 * result + (this.assetId == null ? 0 : this.assetId.hashCode());
        result = 37 * result + (this.providerId == null ? 0 : this.providerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.isValidIdentifier()) {
            return false;
        }
        if (obj instanceof OpenStreamVODIdentifier) {
            OpenStreamVODIdentifier other = (OpenStreamVODIdentifier)((Object)obj);
            if (this.assetId != null && this.providerId != null) {
                return this.assetId.equals(other.getAssetId()) && this.providerId.equals(other.getProviderId());
            }
        }
        return false;
    }
}

