<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<xsl:template name="derived_original_asset">
<xsl:param name="type" />
<xsl:param name="app_name" />

<xsl:choose>
<!-- Movie asset -->
<xsl:when test="$type = 'movie'">
	<xsl:for-each select="/tns:TTVSpec/tns:Group[@type = 'MOVIE'][position() = 1]">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Source_Asset_ID</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
			</xsl:attribute>
		</App_Data>
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Source_Provider_ID</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id" />
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>
</xsl:when>
<!-- Preview asset -->
<xsl:when test="$type = 'preview'">
	<xsl:for-each select="/tns:TTVSpec/tns:Group[@type = 'PREVIEW'][position() = 1]">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Source_Asset_ID</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
			</xsl:attribute>
		</App_Data>
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Source_Provider_ID</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id" />
			</xsl:attribute>
		</App_Data>
	</xsl:for-each>
</xsl:when>
<xsl:otherwise/>
</xsl:choose>

</xsl:template>
</xsl:stylesheet>
