<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/encrypted_original_asset.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'ENCRYPTED']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">encrypted</xsl:attribute>
			</AMS>

			<!-- Process reference to original asset (copy metadata from original asset) -->
			<xsl:call-template name="encrypted_original_asset">
				<xsl:with-param name="asset_uri" select="tns:Fields/tns:Content/tns:Locator/tns:Uri" />
			</xsl:call-template>

			<!-- Vendor -->
			<xsl:if test="tns:Fields/tns:Vendor/tns:Name">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet" >
					<xsl:attribute name="Name">Vendor_Name</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Vendor/tns:Name" /></xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Receiver -->			
			<xsl:if test="tns:Fields/tns:Receiver/tns:Type">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Receiver_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Receiver/tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Receiver/tns:Version/tns:Value">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Receiver_Version</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="fn:floor(tns:Fields/tns:Receiver/tns:Version/tns:Value)" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption -->			
			<xsl:if test="tns:Fields/tns:Encryption/tns:Value">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Value" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Type">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Algorithm">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Algorithm</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Algorithm" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Date">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Date</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Date" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:Time">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Time</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Time" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:SystemInfo">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encrypting_System_Info</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:SystemInfo" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Encryption/tns:KeyBlock">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Key_Block</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:KeyBlock" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Resolution -->			
			<xsl:if test="tns:Fields/tns:Content/tns:Resolution">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Resolution</xsl:attribute>
					<xsl:attribute name="Value">
						<xsl:value-of select="tns:Fields/tns:Content/tns:Resolution" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			
			<!-- Bit Rate -->
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Bit_Rate</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Video/tns:BitRate/@value" /></xsl:attribute>
				</App_Data>
			</xsl:if>
		
			<!-- File Size -->
			<xsl:if test="tns:Fields/tns:Content/tns:Size/tns:length">
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Content_FileSize</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:Size/tns:length" /></xsl:attribute>
			</App_Data>
			</xsl:if>
		
			<!-- Checksum -->
			<xsl:if test="tns:Fields/tns:Content/tns:Checksum">
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Content_CheckSum</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:Checksum" /></xsl:attribute>
			</App_Data>
			</xsl:if>
			
			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>