<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/movie_preview_common.xsl"/>
<xsl:import href="from/movie_common.xsl"/>
<xsl:import href="from/preview_common.xsl"/>

<xsl:template name="encrypted_original_asset">
<xsl:param name="asset_uri" />

<!-- Try to find a movie with asset_uri from template parameter -->
<xsl:for-each select="/tns:TTVSpec/tns:Group[@type = 'MOVIE' and tns:Fields/tns:Content/tns:Locator/tns:Uri = $asset_uri]">
	<!-- It should be only one source movie, but let's do extra validation-->
	<xsl:if test="position() = 1">
	
		<!-- Reference to original asset -->
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Asset_Encrypted</xsl:attribute>
			<xsl:attribute name="Value">
			    <xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
			</xsl:attribute>
		</App_Data>
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Type</xsl:attribute>
			<xsl:attribute name="Value">movie</xsl:attribute>
		</App_Data>
		
		<!-- Common metadata -->
		<xsl:call-template name="movie_preview_common">
			<xsl:with-param name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
			<xsl:with-param name="asset" select="." />
		</xsl:call-template>
		<xsl:call-template name="movie_common">
			<xsl:with-param name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
			<xsl:with-param name="asset" select="." />
		</xsl:call-template>
	</xsl:if>
</xsl:for-each>

<!-- Try to find a preview with asset_uri from template parameter -->
<xsl:for-each select="/tns:TTVSpec/tns:Group[@type = 'PREVIEW' and tns:Fields/tns:Content/tns:Locator/tns:Uri = $asset_uri]">
	<!-- It should be only one source preview, but let's do extra validation-->
	<xsl:if test="position() = 1">

		<!-- Reference to original asset -->
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Asset_Encrypted</xsl:attribute>
			<xsl:attribute name="Value">
			    <xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
			</xsl:attribute>
		</App_Data>
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Type</xsl:attribute>
			<xsl:attribute name="Value">preview</xsl:attribute>
		</App_Data>

		<!-- Common metadata -->
		<xsl:call-template name="movie_preview_common">
			<xsl:with-param name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
			<xsl:with-param name="asset" select="." />
		</xsl:call-template>
		<xsl:call-template name="preview_common">
			<xsl:with-param name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
			<xsl:with-param name="asset" select="." />
		</xsl:call-template>
	</xsl:if>
</xsl:for-each>

</xsl:template>

</xsl:stylesheet>
