<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!--
	Common fields for MOVIE, PREVIEW and ENCRYPTED asset types.
	These fields have to be copied from source MOVIE or PREVIEW asset to ENCRYPTED asset.   
 -->

<!-- Imports -->
<xsl:import href="from/common.xsl"/>

<xsl:template name="movie_preview_common">
<xsl:param name="app_name" />
<xsl:param name="asset" />

	<!-- Audio Type -->
	<xsl:for-each select="$asset/tns:Fields/tns:Audio">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Audio_Type</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="tns:Type" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- Screen Format -->
	<xsl:if test="$asset/tns:Fields/tns:Video/tns:ScreenFormat">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Screen_Format</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Video/tns:ScreenFormat" /></xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Language -->
	<xsl:for-each select="$asset/tns:Fields/tns:Language">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Languages</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	<xsl:for-each select="$asset/tns:Fields/tns:SubTitleLanguage">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Subtitle_Languages</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	<xsl:for-each select="$asset/tns:Fields/tns:DubbedLanguage">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Dubbed_Languages</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!-- Trick Modes Restricted -->
	<xsl:if test="$asset/tns:Fields/tns:TrickMode">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">trickModesRestricted</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:TrickMode" /></xsl:attribute>
		</App_Data>
	</xsl:if>

</xsl:template>
</xsl:stylesheet>
