<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!--
	Common fields for PREVIEW and ENCRYPTED asset types.
	These fields have to be copied from source PREVIEW asset to ENCRYPTED asset.   
 -->

<!-- Imports -->
<xsl:import href="from/common.xsl"/>

<xsl:template name="preview_common">
<xsl:param name="app_name" />
<xsl:param name="asset" />

	<!-- Rating -->
	<xsl:for-each select="$asset/tns:Fields/tns:Rating/tns:Value">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Rating</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!-- MSO Rating -->
	<xsl:for-each select="$asset/tns:Fields/tns:Rating/tns:MSORating">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">MSORating</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- Audience -->
	<xsl:for-each select="$asset/tns:Fields/tns:Rating/tns:TargetAudience">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Audience</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!-- Run time -->
	<xsl:if test="$asset/tns:Fields/tns:Duration/tns:Duration">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Run_Time</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Duration/tns:Duration" /></xsl:attribute>
		</App_Data>
	</xsl:if>
		
</xsl:template>
</xsl:stylesheet>
