<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	version="1.0">
	<xsl:import href="to/mappedCustomFields.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<!-- Trial use fields mapped to TTV custom fields -->
	<xsl:template
		match="App_Data[@Name = 'TitleArtist'
						or @Name = 'SongTitle'
						or @Name = 'TitleLanguage'
						or @Name = 'TitleLicenseWindowEndSec'
						or @Name = 'TitleLicenseWindowStartSec'
						or @Name = 'TitleRatingSec'
						or @Name = 'TitlePriceSec'
						or @Name = 'TestBoolean1'
						or @Name = 'TestBoolean2']"
		mode="mappedCustomFields_optional">
		<xsl:element name="tns:CustomField">
			<xsl:attribute name="name">
				<xsl:value-of select="@Name" />
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@Name = 'TestBoolean1' 
										or @Name = 'TestBoolean2'">
						<xsl:choose>
							<xsl:when test="@Value = 'Y'">true</xsl:when>
							<xsl:when test="@Value = 'N'">false</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
				    </xsl:when>
				    <xsl:otherwise>
				    	<xsl:value-of select="@Value" />
				    </xsl:otherwise>
			    </xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<!-- Unmapped trial use fields -->
	<xsl:template 
		match="App_Data[@Name='CL11_Trial'
						or @Name='CL11_Trial2']"
		mode="unMappedCustomFields_optional">
		<xsl:element name="tns:CustomField">
			<xsl:attribute name="name">
				<xsl:value-of select="@Name" />
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="@Value" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
