/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import org.objectweb.carol.rmi.jrmp.interceptor.JContextStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPServerRequestInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInfo;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JServiceContext;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JServerInterceptorHelper
extends JInterceptorHelper {
    private static InheritableThreadLocal threadCtx = new InheritableThreadLocal();

    public static void receive_request(ObjectInput in, JServerRequestInterceptor[] sis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            if (sis == null || sis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JServerInterceptorHelper receive request without interceptors");
                }
                JServerInterceptorHelper.getRequestServerContextFromInput(in, ctxValue, jsr);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JServerInterceptorHelper receive request contexts");
                }
                JServerRequestInfo ri = JServerInterceptorHelper.getRequestServerContextFromInput(in, ctxValue, jsr);
                for (int i = 0; i < sis.length; ++i) {
                    sis[i].receive_request(ri);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void send_reply(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send reply without context");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            for (int i = 0; i < sis.length; ++i) {
                sis[i].send_reply(jsr);
            }
            JServerInterceptorHelper.setServerContextInOutput(out, jsr, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
        out.flush();
    }

    public static void send_exception(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send exception without context");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send exception contexts");
            }
            for (int i = 0; i < sis.length; ++i) {
                sis[i].send_exception(jsr);
            }
            JServerInterceptorHelper.setServerContextInOutput(out, jsr, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
        out.flush();
    }

    public static void send_other(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send other with no contexts");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            for (int i = 0; i < sis.length; ++i) {
                sis[i].send_other(jsr);
            }
            JServerInterceptorHelper.setServerContextInOutput(out, jsr, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
        out.flush();
    }

    public static JServerRequestInfo getRequestServerContextFromInput(ObjectInput in, int ctxValue, JServerRequestInfo jsr) throws ClassNotFoundException, IOException {
        if (ctxValue == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper receive no context");
            }
            return jsr;
        }
        if (ctxValue == 1) {
            int sz = in.readInt();
            for (int i = 0; i < sz; ++i) {
                jsr.add_reply_service_context((JServiceContext)in.readObject());
            }
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper receive remote contexts");
                Iterator i = jsr.get_all_reply_service_context().iterator();
                while (i.hasNext()) {
                    TraceCarol.debugRmiCarol("ctx:" + i.next());
                }
            }
            return jsr;
        }
        if (ctxValue == 2) {
            JServerInterceptorHelper.setLocal();
            int id = in.readInt();
            jsr.add_all_reply_service_context((Collection)JContextStore.getObject(id));
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper receive local contexts id(" + id + ")");
                Iterator i = jsr.get_all_reply_service_context().iterator();
                while (i.hasNext()) {
                    TraceCarol.debugRmiCarol("ctx:" + i.next());
                }
            }
            return jsr;
        }
        throw new IOException("Unknow context type:" + ctxValue);
    }

    public static void setServerContextInOutput(ObjectOutput out, JServerRequestInfo ri, boolean locRef) throws IOException {
        if (!ri.hasContexts()) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send without contexts");
            }
            out.writeInt(0);
        } else if (locRef) {
            Collection ctx = ri.get_all_reply_service_context();
            int k = JContextStore.storeObject(ctx);
            out.writeInt(2);
            out.writeInt(k);
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send with local contexts id(" + k + ")");
            }
        } else {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send with remote contexts");
            }
            out.writeInt(1);
            Collection allCtx = ri.get_all_reply_service_context();
            out.writeInt(allCtx.size());
            Iterator i = allCtx.iterator();
            while (i.hasNext()) {
                out.writeObject(i.next());
            }
        }
    }

    public static void setLocal() {
        threadCtx.set("local");
    }

    public static boolean isLocal() {
        return threadCtx.get() != null;
    }
}

