/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.objectweb.carol.irmi.ClientInterceptor;
import org.objectweb.carol.irmi.Interceptor;
import org.objectweb.carol.irmi.PRO;
import org.objectweb.carol.irmi.Server;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPClientRequestInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPServerRequestInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JServiceContext;
import org.objectweb.carol.rmi.util.PortNumber;
import org.objectweb.carol.util.configuration.ConfigurationRepository;

public class IrmiPRODelegate
extends PRO {
    private static Server getServer(boolean usingCmi) {
        int port = 0;
        Properties prop = ConfigurationRepository.getProperties();
        if (!usingCmi && prop != null) {
            String propertyName = "carol.jrmp.server.port";
            port = PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
        return new Server(port, (ClientInterceptor)new ClientInterceptorImpl(JInterceptorStore.getLocalClientInterceptors()), (Interceptor)new ServerInterceptorImpl(JInterceptorStore.getLocalServerInterceptors()));
    }

    public IrmiPRODelegate(boolean usingCmi) {
        super(IrmiPRODelegate.getServer(usingCmi));
    }

    public IrmiPRODelegate() {
        this(false);
    }

    private static class ClientInterceptorImpl
    implements ClientInterceptor {
        private JClientRequestInterceptor[] cis;

        public ClientInterceptorImpl(JClientRequestInterceptor[] cis) {
            this.cis = cis;
        }

        public void send(byte code, ObjectOutput out) throws IOException {
            JRMPClientRequestInfoImpl info = new JRMPClientRequestInfoImpl();
            for (int i = 0; i < this.cis.length; ++i) {
                this.cis[i].send_request(info);
            }
            Collection c = info.get_all_request_service_context();
            out.writeShort(c.size());
            Iterator it = c.iterator();
            while (it.hasNext()) {
                out.writeObject(it.next());
            }
        }

        public void receive(byte code, ObjectInput in) throws IOException, ClassNotFoundException {
            int i;
            JRMPClientRequestInfoImpl info = new JRMPClientRequestInfoImpl();
            int len = in.readShort();
            for (i = 0; i < len; ++i) {
                info.add_request_service_context((JServiceContext)in.readObject());
            }
            block5: for (i = 0; i < this.cis.length; ++i) {
                switch (code) {
                    case 1: {
                        this.cis[i].receive_reply(info);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        this.cis[i].receive_exception(info);
                    }
                }
            }
        }
    }

    private static class ServerInterceptorImpl
    implements Interceptor {
        private JServerRequestInterceptor[] sis;

        public ServerInterceptorImpl(JServerRequestInterceptor[] sis) {
            this.sis = sis;
        }

        public void receive(byte code, ObjectInput in) throws IOException, ClassNotFoundException {
            int i;
            JRMPServerRequestInfoImpl info = new JRMPServerRequestInfoImpl();
            int len = in.readShort();
            for (i = 0; i < len; ++i) {
                info.add_reply_service_context((JServiceContext)in.readObject());
            }
            for (i = 0; i < this.sis.length; ++i) {
                this.sis[i].receive_request(info);
            }
        }

        public void send(byte code, ObjectOutput out) throws IOException {
            JRMPServerRequestInfoImpl info = new JRMPServerRequestInfoImpl();
            block4: for (int i = 0; i < this.sis.length; ++i) {
                switch (code) {
                    case 1: {
                        this.sis[i].send_reply(info);
                        continue block4;
                    }
                    case 2: 
                    case 3: {
                        this.sis[i].send_exception(info);
                    }
                }
            }
            Collection c = info.get_all_reply_service_context();
            out.writeShort(c.size());
            Iterator it = c.iterator();
            while (it.hasNext()) {
                out.writeObject(it.next());
            }
        }
    }
}

