/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private String[] derivedGauge = new String[16];
    private long[] derivedGaugeTimestamp = new long[16];
    private int[] status = new int[16];
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient Timer timer = null;

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (StringMonitor.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        if (this.isActive) {
            if (StringMonitor.isTraceOn()) {
                this.trace("start", "the string monitor is already activated");
            }
            return;
        }
        this.isActive = true;
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (StringMonitor.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (!this.isActive) {
                if (StringMonitor.isTraceOn()) {
                    this.trace("stop", "the string monitor is already deactivated");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    synchronized void insertSpecificElementAt(int n) {
        if (n != this.elementCount) {
            throw new Error("Internal error: index != elementCount");
        }
        if (this.elementCount >= this.derivedGauge.length) {
            this.derivedGauge = this.expandArray(this.derivedGauge);
            this.derivedGaugeTimestamp = this.expandArray(this.derivedGaugeTimestamp);
            this.status = this.expandArray(this.status);
        }
        this.derivedGauge[n] = "";
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        this.status[n] = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        String string3 = null;
        Object var8_7 = null;
        Object object = null;
        String string4 = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (!this.isActive) {
                return;
            }
            if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                return;
            }
            try {
                object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                if (object == null) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.alreadyNotified(n, 8)) {
                    return;
                }
                string4 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n, 8);
                string2 = "The string monitor must be registered in the MBean server.";
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.alreadyNotified(n, 1)) {
                    return;
                }
                string4 = "jmx.monitor.error.mbean";
                this.setAlreadyNotified(n, 1);
                string2 = "The observed object must be registered in the MBean server.";
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.alreadyNotified(n, 2)) {
                    return;
                }
                string4 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n, 2);
                string2 = "The observed attribute must be accessible in the observed object.";
            }
            catch (MBeanException mBeanException) {
                if (this.alreadyNotified(n, 8)) {
                    return;
                }
                string4 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n, 8);
                string2 = mBeanException.getMessage();
            }
            catch (ReflectionException reflectionException) {
                if (this.alreadyNotified(n, 2)) {
                    return;
                }
                string4 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n, 2);
                string2 = reflectionException.getMessage();
            }
            if (string2 == null && !(object instanceof String)) {
                if (this.alreadyNotified(n, 4)) {
                    return;
                }
                string4 = "jmx.monitor.error.type";
                this.setAlreadyNotified(n, 4);
                string2 = "The observed attribute type must be a string type.";
            }
            if (string2 == null) {
                this.resetAllAlreadyNotified(n);
                this.updateDerivedGauge(object, n);
                this.updateNotifications(n);
            } else {
                l = this.derivedGaugeTimestamp[n];
                string3 = this.derivedGauge[n];
                this.status[n] = 2;
            }
        }
        if (string2 != null) {
            this.sendNotification(string, l, string2, string3, null, n);
        }
    }

    synchronized void removeSpecificElementAt(int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        this.removeElementAt(this.derivedGauge, n);
        this.removeElementAt(this.derivedGaugeTimestamp, n);
        this.removeElementAt(this.status, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            if (this.status[n] == 2) {
                if (this.derivedGauge[n].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        bl = true;
                        string = "jmx.monitor.string.matches";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        string3 = this.derivedGauge[n];
                        string4 = this.stringToCompare;
                    }
                    this.status[n] = 1;
                } else {
                    if (this.notifyDiffer) {
                        bl = true;
                        string = "jmx.monitor.string.differs";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        string3 = this.derivedGauge[n];
                        string4 = this.stringToCompare;
                    }
                    this.status[n] = 0;
                }
            } else if (this.status[n] == 0) {
                if (this.derivedGauge[n].equals(this.stringToCompare)) {
                    if (this.notifyMatch) {
                        bl = true;
                        string = "jmx.monitor.string.matches";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        string3 = this.derivedGauge[n];
                        string4 = this.stringToCompare;
                    }
                    this.status[n] = 1;
                }
            } else if (this.status[n] == 1 && !this.derivedGauge[n].equals(this.stringToCompare)) {
                if (this.notifyDiffer) {
                    bl = true;
                    string = "jmx.monitor.string.differs";
                    l = this.derivedGaugeTimestamp[n];
                    string2 = "";
                    string3 = this.derivedGauge[n];
                    string4 = this.stringToCompare;
                }
                this.status[n] = 0;
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, string3, string4, n);
        }
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        super.setGranularityPeriod(l);
        if (this.isActive) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public synchronized void setNotifyDiffer(boolean bl) {
        this.notifyDiffer = bl;
    }

    public synchronized void setNotifyMatch(boolean bl) {
        this.notifyMatch = bl;
    }

    private synchronized void updateDerivedGauge(Object object, int n) {
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        this.derivedGauge[n] = (String)object;
    }

    public synchronized String getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    String makeDebugTag() {
        return "StringMonitor";
    }

    public synchronized void setStringToCompare(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null string to compare");
        }
        this.stringToCompare = string;
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGaugeTimestamp[n];
        }
        return 0L;
    }

    public synchronized String getDerivedGauge(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGauge[n];
        }
        return null;
    }

    private static class StringAlarmClock
    extends TimerTask {
        StringMonitor listener = null;

        public void run() {
            if (this.listener.isActive) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }

        public StringAlarmClock(StringMonitor stringMonitor) {
            this.listener = stringMonitor;
        }
    }
}

