/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IAssetVisitor;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.Relation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;

public class AssetUtil {
    public Asset convertedAsset;

    public static Asset deleteEmptyFields(Asset asset) {
        if (asset != null) {
            ArrayList<Field> blankFields = new ArrayList<Field>();
            for (Field f : asset.getFields()) {
                if (f.getValue() == null || !f.getValue().equals("")) continue;
                blankFields.add(f);
            }
            asset.getFields().removeAll(blankFields);
            for (Relation r : asset.getRelations()) {
                AssetUtil.deleteEmptyFields(r.getTargetAsset());
            }
        }
        return asset;
    }

    public Asset unWrap(Asset a) {
        IAssetVisitor visitor = null;
        if (a.isInstance(Group.class)) {
            visitor = new IAssetVisitor(){

                @Override
                public void unWrap(Asset a) {
                    AssetUtil.this.convertedAsset = (Group)a;
                }
            };
        } else if (a.isInstance(Item.class)) {
            visitor = new IAssetVisitor(){

                @Override
                public void unWrap(Asset a) {
                    AssetUtil.this.convertedAsset = (Item)a;
                }
            };
        } else if (a.isInstance(File.class)) {
            visitor = new IAssetVisitor(){

                @Override
                public void unWrap(Asset a) {
                    AssetUtil.this.convertedAsset = (File)a;
                }
            };
        }
        a.accept(visitor);
        return this.convertedAsset;
    }

    public static void copyFieldsToFieldRevisions(Asset asset, NextRevision nextRevision) {
        List<Field> fields = asset.getFields();
        List<FieldRevision> fieldRevisions = asset.getFieldRevisions();
        if (!AssetUtil.isCollectionEmpty(fields) && AssetUtil.isCollectionEmpty(fieldRevisions)) {
            fieldRevisions = new ArrayList<FieldRevision>();
            for (Field field : fields) {
                FieldRevision fieldRevision = new FieldRevision(field, nextRevision);
                asset.addFieldRevision(fieldRevision, nextRevision);
            }
        }
        for (Relation currentRelation : asset.getRelations()) {
            AssetUtil.copyFieldsToFieldRevisions(currentRelation.getTargetAsset(), nextRevision);
        }
    }

    public static boolean isCollectionEmpty(Collection<?> anyCollection) {
        return anyCollection == null || anyCollection.size() == 0;
    }

    public static void evictAssetTree(Asset asset, Session session) {
        for (Relation targetRelation : asset.getRelations()) {
            AssetUtil.evictAssetTree(targetRelation.getTargetAsset(), session);
            session.evict((Object)targetRelation);
        }
        session.evict((Object)asset);
    }
}

