/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class MappingFileParser {
    private static String MAPPING_DELIMITER = ",";

    public static Map<String, String> readFieldMapping(String mappingResource) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(MappingFileParser.class.getClassLoader().getResourceAsStream(mappingResource)));
        MappingFileParser.readInputStream(mappings, br);
        return mappings;
    }

    public static Map<String, String> readFieldMapping(InputStream mappingResourceStream) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(mappingResourceStream));
        MappingFileParser.readInputStream(mappings, br);
        return mappings;
    }

    public static Map<String, Boolean> readFieldMappingWithBooleanValue(InputStream mappingResourceStream) {
        HashMap<String, Boolean> mappings = new HashMap<String, Boolean>();
        BufferedReader br = new BufferedReader(new InputStreamReader(mappingResourceStream));
        MappingFileParser.readInputStreamWithBooleanValue(mappings, br);
        return mappings;
    }

    public static Map<String, String> readFieldMapping(URL mappingResourceUrl) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            URLConnection conn = mappingResourceUrl.openConnection();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MappingFileParser.readInputStream(mappings, br);
        return mappings;
    }

    public static Map<String, String> readFieldMapping(File mappingResourceFile) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(mappingResourceFile)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        MappingFileParser.readInputStream(mappings, br);
        return mappings;
    }

    private static void readInputStream(Map<String, String> mappings, BufferedReader br) throws RuntimeException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] fieldMapping = line.split(MAPPING_DELIMITER);
                mappings.put(fieldMapping[0].trim(), fieldMapping[1].trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void readInputStreamWithBooleanValue(Map<String, Boolean> mappings, BufferedReader br) throws RuntimeException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] fieldMapping = line.split(MAPPING_DELIMITER);
                mappings.put(fieldMapping[0].trim(), Boolean.valueOf(fieldMapping[1].trim()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMapping(String mappingResource, String field) {
        Map<String, String> fields = MappingFileParser.readFieldMapping(mappingResource);
        return fields.containsKey(field) ? fields.get(field) : "";
    }

    public static String getMapping(URL mappingResourceUrl, String field) {
        Map<String, String> fields = MappingFileParser.readFieldMapping(mappingResourceUrl);
        return fields.containsKey(field) ? fields.get(field) : "";
    }
}

