/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CNamedTypeAccessor;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CStatement
extends OracleStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:36_PST_2006";

    T2CStatement(T2CConnection t2CConnection, int n, int n2) throws SQLException {
        this(t2CConnection, n, n2, -1, -1);
        this.connection = t2CConnection;
    }

    T2CStatement(T2CConnection t2CConnection, int n, int n2, int n3, int n4) throws SQLException {
        super(t2CConnection, n, n2, n3, n4);
        this.userResultSetType = n3;
        this.userResultSetConcur = n4;
        this.connection = t2CConnection;
    }

    static native int t2cParseExecuteDescribe(OracleStatement var0, long var1, int var3, int var4, int var5, boolean var6, boolean var7, boolean var8, boolean var9, byte[] var10, int var11, byte var12, int var13, int var14, short[] var15, int var16, byte[] var17, char[] var18, int var19, int var20, short[] var21, int var22, int var23, byte[] var24, char[] var25, int var26, int var27, int[] var28, short[] var29, byte[] var30, int var31, int var32, int var33, int var34, boolean var35, boolean var36, Accessor[] var37, byte[][][] var38, long[] var39, byte[] var40, int var41, char[] var42, int var43, short[] var44, int var45, boolean var46);

    static native int t2cDefineExecuteFetch(OracleStatement var0, long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, byte[] var9, int var10, byte var11, int var12, int var13, short[] var14, int var15, byte[] var16, char[] var17, int var18, int var19, short[] var20, byte[] var21, int var22, int var23, boolean var24, boolean var25, Accessor[] var26, byte[][][] var27, long[] var28, byte[] var29, int var30, char[] var31, int var32, short[] var33, int var34);

    static native int t2cDescribe(long var0, short[] var2, byte[] var3, int var4, int var5, int var6, int var7);

    static native int t2cDefineFetch(long var0, int var2, short[] var3, byte[] var4, int var5, int var6, Accessor[] var7, byte[] var8, int var9, char[] var10, int var11, short[] var12, int var13, long[] var14);

    static native int t2cFetch(long var0, boolean var2, int var3, Accessor[] var4, byte[] var5, int var6, char[] var7, int var8, short[] var9, int var10, long[] var11);

    static native int t2cCloseStatement(long var0);

    static native int t2cEndToEndUpdate(long var0, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, int var10);

    static native int t2cGetRowsDmlReturned(long var0);

    static native int t2cFetchDmlReturnParams(long var0, Accessor[] var2, byte[] var3, char[] var4, short[] var5);

    String bytes2String(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.connection.conversion.CharBytesToString(byArray2, n2);
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int n = this.connection.queryMetaData1Offset;
        int n2 = this.connection.queryMetaData2Offset;
        short[] sArray = this.connection.queryMetaData1;
        byte[] byArray = this.connection.queryMetaData2;
        int n3 = 0;
        while (n3 < this.numberOfDefinePositions) {
            Accessor accessor;
            short s = sArray[n + 0];
            short s2 = sArray[n + 1];
            short s3 = sArray[n + 11];
            boolean bl = sArray[n + 2] != 0;
            short s4 = sArray[n + 3];
            short s5 = sArray[n + 4];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            short s6 = sArray[n + 5];
            short s7 = sArray[n + 6];
            String string = this.bytes2String(byArray, n2, s7);
            short s8 = sArray[n + 12];
            String string2 = null;
            OracleTypeADT oracleTypeADT = null;
            n2 += s7;
            if (s8 > 0) {
                string2 = this.bytes2String(byArray, n2, s8);
                n2 += s8;
                oracleTypeADT = new OracleTypeADT(string2, (Connection)this.connection);
                oracleTypeADT.tdoCState = ((long)sArray[n + 7] & 0xFFFFL) << 48 | ((long)sArray[n + 8] & 0xFFFFL) << 32 | ((long)sArray[n + 9] & 0xFFFFL) << 16 | (long)sArray[n + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[n3]) != null && !accessor.useForDescribeIfPossible(s, s2, bl, n4, s4, s5, n5, n6, s6, string2)) {
                accessor = null;
            }
            if (accessor == null) {
                switch (s) {
                    case 1: {
                        accessor = new VarcharAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        if (s3 <= 0) break;
                        accessor.setDisplaySize(s3);
                        break;
                    }
                    case 96: {
                        accessor = new CharAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        if (s3 <= 0) break;
                        accessor.setDisplaySize(s3);
                        break;
                    }
                    case 2: {
                        accessor = new NumberAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 23: {
                        accessor = new RawAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 100: {
                        accessor = new BinaryFloatAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 101: {
                        accessor = new BinaryDoubleAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 8: {
                        accessor = new LongAccessor(this, n3 + 1, s2, bl, n4, s4, s5, n5, n6, s6);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 24: {
                        accessor = new LongRawAccessor(this, n3 + 1, s2, bl, n4, s4, s5, n5, n6, s6);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 104: {
                        accessor = new RowidAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 102: 
                    case 116: {
                        accessor = new T2CResultSetAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 12: {
                        accessor = new DateAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 180: {
                        accessor = new TimestampAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 181: {
                        accessor = new TimestamptzAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 231: {
                        accessor = new TimestampltzAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 182: {
                        accessor = new IntervalymAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 183: {
                        accessor = new IntervaldsAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 112: {
                        accessor = new ClobAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 113: {
                        accessor = new BlobAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 114: {
                        accessor = new BfileAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 109: {
                        accessor = new NamedTypeAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6, string2, oracleTypeADT);
                        break;
                    }
                    case 111: {
                        accessor = new RefTypeAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6, string2, oracleTypeADT);
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown or unimplemented accessor type: " + s);
                    }
                }
                this.accessors[n3] = accessor;
            } else if (oracleTypeADT != null) {
                accessor.initMetadata();
            }
            accessor.columnName = string;
            ++n3;
            n += 13;
        }
    }

    void doDescribe(boolean bl) throws SQLException {
        boolean bl2;
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.described) {
            return;
        }
        if (!this.isOpen) {
            DatabaseError.throwSqlException(144);
        }
        do {
            bl2 = false;
            this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size);
            if (this.numberOfDefinePositions == -1) {
                this.connection.checkError(this.numberOfDefinePositions);
            }
            if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
            bl2 = true;
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
        } while (bl2);
        this.processDescribeData();
    }

    void executeForDescribe() throws SQLException {
        boolean bl;
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        boolean bl2 = !this.described;
        boolean bl3 = false;
        do {
            bl = false;
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            int n = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, 0, 0, false, this.needToParse, bl2, bl3, byArray, byArray.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, true, true, this.accessors, null, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
            this.validRows = (int)this.t2cOutput[1];
            if (n == -1) {
                this.connection.checkError(n);
            } else if (n == T2C_EXTEND_BUFFER) {
                n = this.connection.queryMetaData1Size * 2;
            }
            if (this.t2cOutput[3] != 0L) {
                this.foundPlsqlCompilerWarning();
            } else if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.needToParse = false;
            bl3 = true;
            if (this.sqlKind == 0) {
                this.numberOfDefinePositions = n;
                if (this.numberOfDefinePositions <= this.connection.queryMetaData1Size) continue;
                bl = true;
                bl3 = true;
                this.connection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                continue;
            }
            this.numberOfDefinePositions = 0;
            this.validRows = n;
        } while (bl);
        this.processDescribeData();
    }

    void pushEndToEndValues() throws SQLException {
        T2CConnection t2CConnection = this.connection;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        if (t2CConnection.endToEndValues != null) {
            String string;
            if (t2CConnection.endToEndHasChanged[0]) {
                string = t2CConnection.endToEndValues[0];
                if (string != null) {
                    byArray = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[0] = false;
            }
            if (t2CConnection.endToEndHasChanged[1]) {
                string = t2CConnection.endToEndValues[1];
                if (string != null) {
                    byArray2 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[1] = false;
            }
            if (t2CConnection.endToEndHasChanged[2]) {
                string = t2CConnection.endToEndValues[2];
                if (string != null) {
                    byArray3 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[2] = false;
            }
            if (t2CConnection.endToEndHasChanged[3]) {
                string = t2CConnection.endToEndValues[3];
                if (string != null) {
                    byArray4 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[3] = false;
            }
            T2CStatement.t2cEndToEndUpdate(this.c_state, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, t2CConnection.endToEndECIDSequenceNumber);
        }
    }

    void executeForRows(boolean bl) throws SQLException {
        if (this.connection.endToEndAnyChanged) {
            this.pushEndToEndValues();
            this.connection.endToEndAnyChanged = false;
        }
        if (!bl) {
            if (this.numberOfDefinePositions > 0) {
                this.doDefineExecuteFetch();
            } else {
                this.executeForDescribe();
            }
        } else if (this.numberOfDefinePositions > 0) {
            this.doDefineFetch();
        }
        this.needToPrepareDefineBuffer = false;
    }

    void setupForDefine() throws SQLException {
        short[] sArray = this.connection.queryMetaData1;
        int n = this.connection.queryMetaData1Offset;
        int n2 = 0;
        while (n2 < this.numberOfDefinePositions) {
            Accessor accessor = this.accessors[n2];
            if (accessor == null) {
                DatabaseError.throwSqlException(21);
            }
            sArray[n + 0] = (short)accessor.defineType;
            sArray[n + 11] = (short)accessor.charLength;
            sArray[n + 1] = (short)accessor.byteLength;
            sArray[n + 5] = accessor.formOfUse;
            if (accessor.internalOtype != null) {
                long l = ((OracleTypeADT)accessor.internalOtype).getTdoCState();
                sArray[n + 7] = (short)((l & 0xFFFF000000000000L) >> 48);
                sArray[n + 8] = (short)((l & 0xFFFF00000000L) >> 32);
                sArray[n + 9] = (short)((l & 0xFFFF0000L) >> 16);
                sArray[n + 10] = (short)(l & 0xFFFFL);
            }
            ++n2;
            n += 13;
        }
    }

    void doDefineFetch() throws SQLException {
        if (!this.needToPrepareDefineBuffer) {
            throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
        }
        this.setupForDefine();
        this.t2cOutput[2] = 0L;
        this.validRows = T2CStatement.t2cDefineFetch(this.c_state, this.rowPrefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
    }

    void doDefineExecuteFetch() throws SQLException {
        short[] sArray = null;
        if (this.needToPrepareDefineBuffer || this.needToParse) {
            this.setupForDefine();
            sArray = this.connection.queryMetaData1;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, 0, 0, false, this.needToParse, byArray, byArray.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, sArray, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, true, true, this.accessors, null, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
        this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
        this.needToParse = false;
    }

    void fetch() throws SQLException {
        if (this.numberOfDefinePositions > 0) {
            if (this.needToPrepareDefineBuffer) {
                this.doDefineFetch();
            } else {
                this.t2cOutput[2] = 0L;
                this.validRows = T2CStatement.t2cFetch(this.c_state, this.needToPrepareDefineBuffer, this.rowPrefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
                if (this.validRows == -1) {
                    this.connection.checkError(this.validRows);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
            }
        }
    }

    void doClose() throws SQLException {
        int n;
        if (this.defineBytes != null) {
            this.defineBytes = null;
            this.accessorByteOffset = 0;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
            this.accessorCharOffset = 0;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
            this.accessorShortOffset = 0;
        }
        if ((n = T2CStatement.t2cCloseStatement(this.c_state)) != 0) {
            this.connection.checkError(n);
        }
        this.t2cOutput = null;
    }

    void closeQuery() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        if (n == 109) {
            if (string == null) {
                if (bl) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                } else {
                    DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                }
            }
            T2CNamedTypeAccessor t2CNamedTypeAccessor = new T2CNamedTypeAccessor(this, string, s, n2, bl, n3 - 1);
            ((Accessor)t2CNamedTypeAccessor).initMetadata();
            return t2CNamedTypeAccessor;
        }
        if (n == 116 || n == 102) {
            if (bl && string != null) {
                DatabaseError.throwSqlException(12, "sqlType=" + n2);
            }
            T2CResultSetAccessor t2CResultSetAccessor = new T2CResultSetAccessor(this, n4, s, n2, bl);
            return t2CResultSetAccessor;
        }
        return super.allocateAccessor(n, n2, n3, n4, s, string, bl);
    }

    void closeUsedStreams(int n) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            this.nextStream = this.nextStream.nextStream;
        }
        if (this.nextStream != null) {
            try {
                this.nextStream.needBytes();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
    }

    void fetchDmlReturnParams() throws SQLException {
        this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
        if (this.rowsDmlReturned != 0) {
            this.allocateDmlReturnStorage();
            int n = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this.returnParamAccessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
        }
        this.returnParamsFetched = true;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.numberOfBindPositions * 5;
    }
}

