/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.cl1_1;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import com.tandbergtv.metadatamanager.specimpl.cl1_1.CL1_1_Identifier;
import java.util.HashMap;
import java.util.Map;

public class CL1_1SpecHandler
extends SingleTitleSpecHandler {
    private static final String ADI_ROOTELEMENT_NAME = "ADI";

    public CL1_1SpecHandler() {
        this.alias = "CL1_1";
        this.rootElementName = ADI_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        CL1_1_Identifier id = new CL1_1_Identifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        CL1_1_Identifier identifier = new CL1_1_Identifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
        if (!supperResult && ttvXPath != null && ttvXPath.contains("tns:CustomField")) {
            return true;
        }
        return supperResult;
    }
}

