<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema"  xmlns:xs="http://www.w3.org/2001/XMLSchema"
 version="1.0">
	<xsl:import href="to/commonMetadata.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<!-- rightsMetadata optional -->
	<xsl:template match="rightsMetadata" mode="package_metadata">
		<xsl:element name="tns:Rights">
			<xsl:element name="tns:LicensingWindowStart">
				<xsl:value-of select="licensingWindowStart"/>
			</xsl:element>
			<xsl:element name="tns:LicensingWindowEnd">
				<xsl:value-of select="licensingWindowEnd"/>
			</xsl:element>
			<xsl:apply-templates select="*" mode="rightsMetadataOptional"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="availabilityWindowStart" mode="rightsMetadataOptional">
		<xsl:element name="tns:AvailabilityWindowStart">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="availabilityWindowEnd" mode="rightsMetadataOptional">
		<xsl:element name="tns:AvailabilityWindowEnd">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="previewPeriodInSeconds" mode="rightsMetadataOptional">
		<xsl:element name="tns:PreviewPeriod">
			<xsl:element name="tns:DurationSeconds">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="daystoLastChance" mode="rightsMetadataOptional">
		<xsl:element name="tns:DaysToLastChance">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="newReleaseWindow" mode="rightsMetadataOptional">
		<xsl:element name="tns:NewReleaseWindow">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="maximumPlayCount" mode="rightsMetadataOptional">
		<xsl:element name="tns:MaxPlayCount">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="lastChanceWindow" mode="rightsMetadataOptional">
		<xsl:element name="tns:DisplayAsLastChance">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="maximumViewingLimit" mode="rightsMetadataOptional">
		<xsl:element name="tns:MaxViewingLimit"><xsl:value-of select="."/></xsl:element>
	</xsl:template>
	<xsl:template match="minimumViewingLimit" mode="rightsMetadataOptional">
		<xsl:element name="tns:MinViewingLimit"><xsl:value-of select="."/></xsl:element>
	</xsl:template>
	<xsl:template match="previewPeriod" mode="rightsMetadataOptional">
		<xsl:element name="tns:PreviewPeriod">
			<xsl:element name="tns:Duration">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="rightsMetadataOptional"/>
	<!-- end -->
	<xsl:template match="businessMetadata" mode="package_metadata">
		<xsl:if test="createOffer or suggestedPrice or currency_iso3166-2 or billingID or billingIDAggregator or billingIDProvider or quoteProviderID or adAvail">
			<xsl:element name="tns:BillingInfo">
				<xsl:if test="createOffer">
					<xsl:element name="tns:CreateOffer">
						<xsl:choose>
							<xsl:when test="createOffer = '1'">true</xsl:when>
							<xsl:when test="createOffer = '0'">false</xsl:when>
							<xsl:otherwise><xsl:value-of select="createOffer"/></xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:if>
				<xsl:if test="suggestedPrice or currency_iso3166-2">
					<xsl:element name="tns:SuggestedPrice">
						<xsl:apply-templates select="*" mode="suggestedPriceOptional"/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="billingID">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="billingID"/>
						</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="billingIDAggregator">
					<xsl:element name="tns:AggregatorId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="billingIDAggregator"/>
						</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="billingIDProvider">
					<xsl:element name="tns:ProviderId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="billingIDProvider"/>
						</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="quoteProviderID">
					<xsl:element name="tns:QuoteProviderId">
						<xsl:value-of select="quoteProviderID"/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="contentReference">
					<xsl:element name="tns:ContentReference">
						<xsl:element name="tns:AssetId"><xsl:value-of select="contentReference/@assetId"/></xsl:element>
						<xsl:element name="tns:ProviderId"><xsl:value-of select="contentReference/@providerId"/></xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="adAvail">
					<xsl:element name="tns:AdAvail">
						<xsl:element name="tns:Time"><xsl:value-of select="adAvail/@time"/></xsl:element>
						<xsl:element name="tns:DurationInMilliSeconds"><xsl:value-of select="adAvail/@durationInMilliSeconds"/></xsl:element>
						<xsl:element name="tns:Count"><xsl:value-of select="adAvail/@count"/></xsl:element>
						<xsl:element name="tns:Action"><xsl:value-of select="adAvail/@action"/></xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:if>
		<xsl:if test="distributorName or distributorRoyaltyPercentage or distributorRoyaltyMinimum">
			<xsl:element name="tns:Distributor">
				<xsl:if test="distributorName">
					<xsl:element name="tns:Name">
						<xsl:value-of select="distributorName"/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="distributorRoyaltyPercentage or distributorRoyaltyMinimum">
					<xsl:element name="tns:RoyaltyInfo">
						<xsl:if test="distributorRoyaltyPercentage">
							<xsl:element name="tns:RoyaltyPercent">
								<xsl:value-of select="distributorRoyaltyPercentage"/>
							</xsl:element>
						</xsl:if>
						<xsl:if test="distributorRoyaltyMinimum">
							<xsl:element name="tns:RoyaltyMinimum">
								<xsl:value-of select="distributorRoyaltyMinimum"/>
							</xsl:element>
						</xsl:if>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="metadata" mode="package_metadata">
		<xsl:if test="rating">
			<xsl:element name="tns:Rating">
				<xsl:apply-templates mode="rating_metadata" select="rating"/>
			</xsl:element>
		</xsl:if>
		<xsl:apply-templates mode="common_metadata" select="*"/>
		<xsl:element name="tns:Summary">
			<xsl:apply-templates select="shortSummary" mode="summary_optional"/>
			<xsl:element name="tns:DisplaySummary">
				<xsl:apply-templates select="summary/@language" mode="language"/>
				<xsl:if test="summary">
					<xsl:element name="tns:Value">
						<xsl:value-of select="summary"/>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:Title">
			<xsl:element name="tns:DisplayTitle">
				<xsl:apply-templates select="title/@language" mode="language"/>
				<xsl:if test="title">
					<xsl:element name="tns:Value">
						<xsl:value-of select="title"/>
					</xsl:element>
				</xsl:if>
			</xsl:element>
			<xsl:apply-templates select="*" mode="title_optional"/>
		</xsl:element>
		<xsl:if test="episodeTitle or episodeNumber">
			<xsl:element name="tns:Episode">
				<xsl:apply-templates select="*" mode="episode_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="macrovisionLevel or cgmsaLevel or disableHDCP">
			<xsl:element name="tns:Copyright">
				<xsl:apply-templates select="*" mode="copyright_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="url or pipurl">
			<xsl:element name="tns:Locator">
				<xsl:apply-templates select="*" mode="url_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:element name="tns:Categorization">
			<xsl:for-each select="categorization/category1">
				<xsl:element name="tns:Category">
					<xsl:element name="tns:Text">
						<xsl:value-of select="@name"/>
					</xsl:element>
					<xsl:element name="tns:Category">
						<xsl:element name="tns:Text">
							<xsl:value-of select="category2/@name"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
		<xsl:for-each select="category">
			<xsl:element name="tns:Category">
				<xsl:element name="tns:Text">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:element>
		</xsl:for-each>
		<xsl:apply-templates select="*" mode="metadata_optional"/>
	</xsl:template>
	<xsl:template match="*" mode="package_metadata"/>
	<!-- suggestedPrice optional -->
	<xsl:template match="suggestedPrice" mode="suggestedPriceOptional">
		<xsl:element name="tns:Value">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="currency_iso3166-2" mode="suggestedPriceOptional">
		<xsl:element name="tns:Currency">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="suggestedPriceOptional"/>
	<!-- end -->
	<!-- metadata optional -->
	<xsl:template match="runTimeMinutes" mode="metadata_optional">
		<xsl:element name="tns:Duration">
			<xsl:element name="tns:Duration"> 
				<xsl:variable name="minutes" select="number(.) mod 60"/>
				<xsl:variable name="hours" select="(number(.) - $minutes) div 60"/>
				<xsl:choose>
					<xsl:when test="not(string(.) castable as xs:integer) or number(.) &lt; 0  ">
						<xsl:value-of select="."/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
						<xsl:when test="$hours &lt; 10">
							<xsl:choose>
								<xsl:when test="$minutes &lt; 10">
									<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), concat('0', $minutes)), ':00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="concat(concat(concat(concat('0', $hours), ':'), $minutes), ':00')"/>
								</xsl:otherwise>
							</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$minutes &lt; 10">
										<xsl:value-of select="concat(concat(concat($hours, ':'), concat('0', $minutes)), ':00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="concat(concat(concat($hours, ':'), $minutes), ':00')"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="person" mode="metadata_optional">
		<xsl:element name="tns:Source">
			<xsl:element name="tns:Role">
				<xsl:element name="tns:Name">
					<xsl:value-of select="translate(@role,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
				</xsl:element>
			</xsl:element>
			<xsl:element name="tns:Contact">
				<xsl:element name="tns:LastName">
					<xsl:value-of select="@lname"/>
				</xsl:element>
				<xsl:element name="tns:MiddleName">
					<xsl:value-of select="@mname"/>
				</xsl:element>
				<xsl:element name="tns:FirstName">
					<xsl:value-of select="@fname"/>
				</xsl:element>
			</xsl:element>
			<xsl:if test="characterName">
				<xsl:element name="tns:CharacterName">
					<xsl:value-of select="characterName"/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="tvIdentifier" mode="metadata_optional">
		<xsl:element name="tns:TvId">
			<xsl:if test="showtime/@startTimeInUTC or showtime/@originalAirDate">
				<xsl:element name="tns:Showtime">
					<xsl:if test="showtime/@startTimeInUTC">
						<xsl:element name="tns:StartTimeInUtc">
							<xsl:value-of select="showtime/@startTimeInUTC"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="showtime/@originalAirDate">
						<xsl:element name="tns:OriginalAirDate">
							<xsl:value-of select="showtime/@originalAirDate"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
			</xsl:if>
			<xsl:apply-templates select="@*" mode="tvIdentifier_optional"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="genre" mode="metadata_optional">
		<xsl:element name="tns:Genre">
			<xsl:element name="tns:Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="keyword" mode="metadata_optional">
		<xsl:element name="tns:Keyword">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="resultFilter" mode="metadata_optional">
		<xsl:element name="tns:ResultFilter">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="targetingProfileID" mode="metadata_optional">
		<xsl:element name="tns:TargetingProfileId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="RdpApp" mode="metadata_optional">
		<xsl:element name="tns:RdpApp">
			<xsl:value-of select="@isWebApplication"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="importPriority" mode="metadata_optional">
		<xsl:element name="tns:PropagationPriority">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="autoImport" mode="metadata_optional">
		<xsl:element name="tns:AutoImport">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="autoDeploy" mode="metadata_optional">
		<xsl:element name="tns:AutoDeploy">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="autoDelete" mode="metadata_optional">
		<xsl:element name="tns:AutoDelete">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="policyProfileId" mode="metadata_optional">
		<xsl:element name="tns:PolicyProfileId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="deviceRestrictionProfileId" mode="metadata_optional">
		<xsl:element name="tns:DeviceRestrictionProfileId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="flag" mode="metadata_optional">
		<xsl:element name="tns:Flag">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="providerReference" mode="metadata_optional">
		<xsl:element name="tns:ProviderInfo">
			<xsl:element name="tns:ReferenceIdentifier">
				<xsl:element name="tns:Id">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="showType" mode="metadata_optional">
		<xsl:element name="tns:TV">
			<xsl:element name="tns:ShowType">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="ISAN" mode="metadata_optional">
		<xsl:element name="tns:ISAN">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="AD-Id" mode="metadata_optional">
		<xsl:element name="tns:AdId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="ISCI-Id" mode="metadata_optional">
		<xsl:element name="tns:ISCI">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="resourceref" mode="metadata_optional">
		<xsl:element name="tns:ResourceReference">
			<xsl:element name="tns:ResourceType"><xsl:value-of select="@resourceType"/></xsl:element>
			<xsl:element name="tns:Relation"><xsl:value-of select="@Relation"/></xsl:element>
			<xsl:element name="tns:ExternalIdScope"><xsl:value-of select="@externalIdScope"/></xsl:element>
			<xsl:element name="tns:ExternalId"><xsl:value-of select="@externalID"/></xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="metadata_optional"/>
	<!-- end -->
	<!-- tv identifier optional -->
	<xsl:template match="@authority" mode="tvIdentifier_optional">
		<xsl:element name="tns:Authority">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@programId" mode="tvIdentifier_optional">
		<xsl:element name="tns:ProgramId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@stationId" mode="tvIdentifier_optional">
		<xsl:element name="tns:StationId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@seriesId" mode="tvIdentifier_optional">
		<xsl:element name="tns:SeriesId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@network" mode="tvIdentifier_optional">
		<xsl:element name="tns:Network">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@callSign" mode="tvIdentifier_optional">
		<xsl:element name="tns:CallSign">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@liveServiceId" mode="tvIdentifier_optional">
		<xsl:element name="tns:LiveServiceId">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@programNumber" mode="tvIdentifier_optional">
		<xsl:element name="tns:ProgramNumber">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@episodeSeasonNumber" mode="tvIdentifier_optional">
		<xsl:element name="tns:EpisodeSeasonNumber">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="tvIdentifier_optional"/>
	<!-- end -->
	<!-- url optional -->
	<xsl:template match="url" mode="url_optional">
		<xsl:element name="tns:Uri">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="pipurl" mode="url_optional">
		<xsl:element name="tns:PipUri">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="url_optional"/>
	<!-- end -->
	<!-- episode optional -->
	<xsl:template match="episodeNumber" mode="episode_optional">
		<xsl:if test="string-length(.) &gt; 0">
			<xsl:element name="tns:Number">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="episodeTitle" mode="episode_optional">
		<xsl:element name="tns:Name">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="episode_optional"/>
	<!-- end -->
	<!-- summary optional -->
	<xsl:template match="shortSummary" mode="summary_optional">
		<xsl:element name="tns:ShortSummary">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<!-- end -->
	<!-- title optional -->
	<xsl:template match="reducedTitle" mode="title_optional">
		<xsl:element name="tns:ShortTitle">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="sortTitle" mode="title_optional">
		<xsl:element name="tns:SortTitle">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="originalTitle" mode="title_optional">
		<xsl:element name="tns:OriginalTitle">
			<xsl:apply-templates select="@language" mode="language"/>
			<xsl:if test=".">
				<xsl:element name="tns:Value">
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="title_optional"/>
	<!-- end -->
	<!-- asset -->
	<xsl:template name="assetTemplate">
		<xsl:param name="assetId"/>
		<xsl:variable name="el_name">
			<xsl:choose>
				<xsl:when test="@type = 'feature' or @type = 'trailer'">tns:Group</xsl:when>
				<xsl:otherwise>tns:Item</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:element name="{$el_name}">
			<xsl:attribute name="type"><xsl:if test="@type = 'feature'"><xsl:text>MOVIE</xsl:text></xsl:if><xsl:if test="@type = 'trailer'"><xsl:text>PREVIEW</xsl:text></xsl:if><xsl:if test="@type = 'poster'"><xsl:text>POSTER</xsl:text></xsl:if></xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="$assetId"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:ProviderInfo">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="/assetPackages/assetPackage[1]/@providerID"/>
						</xsl:element>
					</xsl:element>
					<xsl:if test="/assetPackages/assetPackage[1]/@providerName">
						<xsl:element name="tns:Name">
							<xsl:value-of select="/assetPackages/assetPackage[1]/@providerName"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
				<xsl:apply-templates select="metadata" mode="asset_metadata"/>
				<xsl:element name="tns:AssetName">
					<xsl:value-of select="@asset_name"/>
				</xsl:element>
				<xsl:apply-templates select="@*" mode="assetFieldsOptional"/>
				<xsl:element name="tns:Content">
					<xsl:element name="tns:Locator">
						<xsl:element name="tns:Uri">
							<xsl:value-of select="content"/>
						</xsl:element>
					</xsl:element>
					<xsl:if test="content/@wasPitched">
						<xsl:element name="tns:WasPitched">
							<xsl:value-of select="content/@wasPitched"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@lastPitchDate">
						<xsl:element name="tns:LastPitchDate">
							<xsl:value-of select="content/@lastPitchDate"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@pitchedFilename">
						<xsl:element name="tns:PitchedFilename">
							<xsl:value-of select="content/@pitchedFilename"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@sizeInBytes">
						<xsl:element name="tns:SizeInBytes">
							<xsl:value-of select="content/@sizeInBytes"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@type">
						<xsl:element name="tns:Type">
							<xsl:value-of select="content/@type"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@networkType">
						<xsl:element name="tns:NetworkType">
							<xsl:value-of select="content/@networkType"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@Playready">
						<xsl:element name="tns:PlayReady">
							<xsl:value-of select="content/@Playready"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@webInitiatorUrl">
						<xsl:element name="tns:WebInitiatorUrl">
							<xsl:value-of select="content/@webInitiatorUrl"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="content/@licenseServerProxyUrl">
						<xsl:element name="tns:LicenseServerProxyUrl">
							<xsl:value-of select="content/@licenseServerProxyUrl"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="asset"/>
	<!-- assetFieldsOptional -->
	<xsl:template match="@profile" mode="assetFieldsOptional">
		<xsl:element name="tns:Profile">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@product" mode="assetFieldsOptional">
		<xsl:element name="tns:ProductInfo">
			<xsl:element name="tns:Name">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@autoImport" mode="assetFieldsOptional">
		<xsl:element name="tns:AutoImport">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@autoDeploy" mode="assetFieldsOptional">
		<xsl:element name="tns:AutoDeploy">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@autoDelete" mode="assetFieldsOptional">
		<xsl:element name="tns:AutoDelete">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@verb" mode="assetFieldsOptional">
		<xsl:element name="tns:Verb">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@version" mode="assetFieldsOptional">
		<xsl:element name="tns:Version">
			<xsl:element name="tns:Major">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*" mode="assetFieldsOptional"/>
	<!-- end -->
	<!-- end -->
</xsl:stylesheet>
