/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionMultiplicity;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.ParameterMultiplicity;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelParameterDef;
import org.java.plugin.registry.xml.ParameterValueParser;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtensionPointImpl
extends PluginElementImpl<ExtensionPoint>
implements ExtensionPoint {
    private final ModelExtensionPoint model;
    private Map<String, Extension> connectedExtensions;
    private Map<String, Extension> availableExtensions;
    private List<ExtensionPoint.ParameterDefinition> parameterDefinitions;
    private Boolean isValid;
    private boolean paramDefsMerged = false;
    private List<ExtensionPoint> descendants;

    ExtensionPointImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelExtensionPoint modelExtensionPoint) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelExtensionPoint.getId(), modelExtensionPoint.getDocumentation());
        this.model = modelExtensionPoint;
        if (this.model.getParentPointId() != null && this.model.getParentPluginId() == null) {
            this.log.warn((Object)("parent plug-in ID not specified together with parent extension point ID, using declaring plug-in ID, extension point is " + this.getUniqueId()));
            this.model.setParentPluginId(pluginDescriptorImpl.getId());
        }
        this.parameterDefinitions = new ArrayList<ExtensionPoint.ParameterDefinition>(this.model.getParamDefs().size());
        HashSet<String> hashSet = new HashSet<String>();
        for (ModelParameterDef modelParameterDef : this.model.getParamDefs()) {
            ParameterDefinitionImpl parameterDefinitionImpl = new ParameterDefinitionImpl(null, modelParameterDef);
            if (hashSet.contains(parameterDefinitionImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{parameterDefinitionImpl.getId(), this.getId(), pluginDescriptorImpl.getId()});
            }
            hashSet.add(parameterDefinitionImpl.getId());
            this.parameterDefinitions.add(parameterDefinitionImpl);
        }
        this.parameterDefinitions = Collections.unmodifiableList(this.parameterDefinitions);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    @Override
    public ExtensionMultiplicity getMultiplicity() {
        return this.model.getExtensionMultiplicity();
    }

    private void updateExtensionsLists() {
        this.connectedExtensions = new HashMap<String, Extension>();
        this.availableExtensions = new HashMap<String, Extension>();
        for (PluginDescriptor pluginDescriptor : this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors()) {
            for (Extension extension : pluginDescriptor.getExtensions()) {
                if (!this.getDeclaringPluginDescriptor().getId().equals(extension.getExtendedPluginId()) || !this.getId().equals(extension.getExtendedPointId())) continue;
                this.availableExtensions.put(extension.getUniqueId(), extension);
                if (extension.isValid()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("extension " + extension + " connected to point " + this));
                    }
                    this.connectedExtensions.put(extension.getUniqueId(), extension);
                    continue;
                }
                this.log.warn((Object)("extension " + extension.getUniqueId() + " is invalid and doesn't connected to" + " extension point " + this.getUniqueId()));
            }
        }
    }

    @Override
    public Collection<Extension> getAvailableExtensions() {
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        return Collections.unmodifiableCollection(this.availableExtensions.values());
    }

    @Override
    public Extension getAvailableExtension(String string) {
        Extension extension;
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        if ((extension = this.availableExtensions.get(string)) == null) {
            throw new IllegalArgumentException("extension " + string + " not available in point " + this.getUniqueId());
        }
        return extension;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        return this.availableExtensions.containsKey(string);
    }

    @Override
    public Collection<Extension> getConnectedExtensions() {
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        return Collections.unmodifiableCollection(this.connectedExtensions.values());
    }

    @Override
    public Extension getConnectedExtension(String string) {
        Extension extension;
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        if ((extension = this.connectedExtensions.get(string)) == null) {
            throw new IllegalArgumentException("extension " + string + " not connected to point " + this.getUniqueId());
        }
        return extension;
    }

    @Override
    public boolean isExtensionConnected(String string) {
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        return this.connectedExtensions.containsKey(string);
    }

    @Override
    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection<IntegrityCheckReport.ReportItem> validate() {
        if (this.model.getParentPluginId() != null && this.model.getParentPointId() != null) {
            try {
                if (!this.isExtensionPointAvailable(this.model.getParentPluginId(), this.model.getParentPointId())) {
                    this.isValid = Boolean.FALSE;
                    return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "parentExtPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId()}));
                }
            }
            catch (Throwable throwable) {
                this.isValid = Boolean.FALSE;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("failed checking availability of extension point " + this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId())), throwable);
                }
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "parentExtPointAvailabilityCheckFailed", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId(), throwable}));
            }
        }
        switch (this.getMultiplicity()) {
            case ANY: {
                this.isValid = Boolean.TRUE;
                return Collections.emptyList();
            }
            case ONE: {
                this.isValid = this.getAvailableExtensions().size() == 1;
                if (this.isValid.booleanValue()) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "toManyOrFewExtsConnected", this.getUniqueId()));
            }
            case NONE: {
                this.isValid = this.getAvailableExtensions().size() == 0;
                if (this.isValid.booleanValue()) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "extsConnectedToAbstractExtPoint", this.getUniqueId()));
            }
            case ONE_PER_PLUGIN: {
                this.isValid = Boolean.TRUE;
                HashSet<String> hashSet = new HashSet<String>();
                for (Extension extension : this.getAvailableExtensions()) {
                    String string = extension.getDeclaringPluginDescriptor().getId();
                    if (hashSet.add(string)) continue;
                    this.isValid = Boolean.FALSE;
                    return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION_POINT, "toManyExtsConnected", this.getUniqueId()));
                }
                break;
            }
        }
        return Collections.emptyList();
    }

    private boolean isExtensionPointAvailable(String string, String string2) {
        PluginRegistry pluginRegistry = this.getDeclaringPluginDescriptor().getRegistry();
        if (!pluginRegistry.isPluginDescriptorAvailable(string)) {
            return false;
        }
        for (ExtensionPoint extensionPoint : pluginRegistry.getPluginDescriptor(string).getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ExtensionPoint.ParameterDefinition> getParameterDefinitions() {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null || this.paramDefsMerged) {
            return this.parameterDefinitions;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collection<ExtensionPoint.ParameterDefinition> collection = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).getParameterDefinitions();
        ArrayList<ExtensionPoint.ParameterDefinition> arrayList = new ArrayList<ExtensionPoint.ParameterDefinition>(this.parameterDefinitions.size() + collection.size());
        for (ExtensionPoint.ParameterDefinition parameterDefinition : this.parameterDefinitions) {
            hashSet.add(parameterDefinition.getId());
            arrayList.add(parameterDefinition);
        }
        for (ExtensionPoint.ParameterDefinition parameterDefinition : collection) {
            if (hashSet.contains(parameterDefinition.getId())) continue;
            arrayList.add(parameterDefinition);
        }
        this.paramDefsMerged = true;
        this.parameterDefinitions = Collections.unmodifiableList(arrayList);
        return this.parameterDefinitions;
    }

    @Override
    public ExtensionPoint.ParameterDefinition getParameterDefinition(String string) {
        for (ExtensionPoint.ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
            ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)parameterDefinition;
            if (!parameterDefinitionImpl.getId().equals(string)) continue;
            return parameterDefinitionImpl;
        }
        throw new IllegalArgumentException("parameter definition with ID " + string + " not found in extension point " + this.getUniqueId() + " and all it parents");
    }

    @Override
    public String getParentPluginId() {
        return this.model.getParentPluginId();
    }

    @Override
    public String getParentExtensionPointId() {
        return this.model.getParentPointId();
    }

    @Override
    public boolean isSuccessorOf(ExtensionPoint extensionPoint) {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null) {
            return false;
        }
        if (this.model.getParentPluginId().equals(extensionPoint.getDeclaringPluginDescriptor().getId()) && this.model.getParentPointId().equals(extensionPoint.getId())) {
            return true;
        }
        try {
            return this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).isSuccessorOf(extensionPoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private void collectDescendants() {
        this.descendants = new LinkedList<ExtensionPoint>();
        for (PluginDescriptor pluginDescriptor : this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors()) {
            for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
                if (!extensionPoint.isSuccessorOf(this)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("extension point " + extensionPoint + " is descendant of point " + this));
                }
                this.descendants.add(extensionPoint);
            }
        }
        this.descendants = Collections.unmodifiableList(this.descendants);
    }

    @Override
    public Collection<ExtensionPoint> getDescendants() {
        if (this.descendants == null) {
            this.collectDescendants();
        }
        return this.descendants;
    }

    public String toString() {
        return "{ExtensionPoint: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
        this.connectedExtensions = null;
        this.availableExtensions = null;
        this.descendants = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParameterDefinitionImpl
    extends PluginElementImpl<ExtensionPoint.ParameterDefinition>
    implements ExtensionPoint.ParameterDefinition {
        private List<ExtensionPoint.ParameterDefinition> subDefinitions;
        private final ParameterDefinitionImpl superDefinition;
        private final ModelParameterDef modelParamDef;
        private final ParameterValueParser valueParser;

        ParameterDefinitionImpl(ParameterDefinitionImpl parameterDefinitionImpl, ModelParameterDef modelParameterDef) throws ManifestProcessingException {
            super(ExtensionPointImpl.this.getDeclaringPluginDescriptor(), ExtensionPointImpl.this.getDeclaringPluginFragment(), modelParameterDef.getId(), modelParameterDef.getDocumentation());
            this.superDefinition = parameterDefinitionImpl;
            this.modelParamDef = modelParameterDef;
            this.valueParser = new ParameterValueParser(this.getDeclaringPluginDescriptor().getRegistry(), this, this.modelParamDef.getDefaultValue());
            if (!this.valueParser.isParsingSucceeds()) {
                this.log.warn((Object)("parsing default value for parameter definition " + this + " failed, message is: " + this.valueParser.getParsingMessage()));
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidDefaultValueAttribute", new Object[]{this.modelParamDef.getDefaultValue(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
            if (ParameterType.ANY == this.modelParamDef.getType()) {
                this.subDefinitions = Collections.emptyList();
            } else {
                this.subDefinitions = new ArrayList<ExtensionPoint.ParameterDefinition>(this.modelParamDef.getParamDefs().size());
                HashSet<String> hashSet = new HashSet<String>();
                for (ModelParameterDef modelParameterDef2 : this.modelParamDef.getParamDefs()) {
                    ParameterDefinitionImpl parameterDefinitionImpl2 = new ParameterDefinitionImpl(this, modelParameterDef2);
                    if (hashSet.contains(parameterDefinitionImpl2.getId())) {
                        throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{parameterDefinitionImpl2.getId(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
                    }
                    hashSet.add(parameterDefinitionImpl2.getId());
                    this.subDefinitions.add(parameterDefinitionImpl2);
                }
                this.subDefinitions = Collections.unmodifiableList(this.subDefinitions);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("object instantiated: " + this));
            }
        }

        ParameterValueParser getValueParser() {
            return this.valueParser;
        }

        @Override
        public ExtensionPoint getDeclaringExtensionPoint() {
            return ExtensionPointImpl.this;
        }

        @Override
        public ParameterMultiplicity getMultiplicity() {
            return this.modelParamDef.getMultiplicity();
        }

        @Override
        public Collection<ExtensionPoint.ParameterDefinition> getSubDefinitions() {
            return this.subDefinitions;
        }

        @Override
        public ExtensionPoint.ParameterDefinition getSuperDefinition() {
            return this.superDefinition;
        }

        @Override
        public ExtensionPoint.ParameterDefinition getSubDefinition(String string) {
            for (ExtensionPoint.ParameterDefinition parameterDefinition : this.subDefinitions) {
                ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)parameterDefinition;
                if (!parameterDefinitionImpl.getId().equals(string)) continue;
                return parameterDefinitionImpl;
            }
            throw new IllegalArgumentException("parameter definition with ID " + string + " not found in extension point " + ExtensionPointImpl.this.getUniqueId());
        }

        @Override
        public ParameterType getType() {
            return this.modelParamDef.getType();
        }

        @Override
        public String getCustomData() {
            return this.modelParamDef.getCustomData();
        }

        @Override
        public String getDefaultValue() {
            return this.modelParamDef.getDefaultValue();
        }

        public String toString() {
            return "{PluginExtensionPoint.ParameterDefinition: extPointUid=" + this.getDeclaringExtensionPoint().getUniqueId() + "; id=" + this.getId() + "}";
        }

        @Override
        protected boolean isEqualTo(Identity identity) {
            if (!super.isEqualTo(identity)) {
                return false;
            }
            ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)identity;
            if (this.getSuperDefinition() == null && parameterDefinitionImpl.getSuperDefinition() == null) {
                return true;
            }
            if (this.getSuperDefinition() == null || parameterDefinitionImpl.getSuperDefinition() == null) {
                return false;
            }
            return this.getSuperDefinition().equals(parameterDefinitionImpl.getSuperDefinition());
        }
    }
}

