/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.xml.ManifestHandler;
import org.java.plugin.registry.xml.ManifestInfoHandler;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.PluginRegistryImpl;
import org.java.plugin.util.IoUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ManifestParser {
    static Log log = LogFactory.getLog(ManifestParser.class);
    static final String PLUGIN_DTD_1_0 = ManifestParser.loadPluginDtd("1_0");
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private final EntityResolver entityResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadPluginDtd(String string) {
        String string2;
        InputStreamReader inputStreamReader = new InputStreamReader(PluginRegistryImpl.class.getResourceAsStream("plugin_" + string + ".dtd"), "UTF-8");
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[64];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)inputStreamReader).close();
                throw throwable;
            }
            catch (IOException iOException) {
                log.error((Object)("can't read plug-in DTD file of version " + string), (Throwable)iOException);
                return null;
            }
        }
        ((Reader)inputStreamReader).close();
        return string2;
    }

    private static EntityResolver getDtdEntityResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                if (string == null) {
                    log.debug((Object)("can't resolve entity, public ID is NULL, systemId=" + string2));
                    return null;
                }
                if (PLUGIN_DTD_1_0 == null) {
                    return null;
                }
                if (string.equals("-//JPF//Java Plug-in Manifest 1.0") || string.equals("-//JPF//Java Plug-in Manifest 0.7") || string.equals("-//JPF//Java Plug-in Manifest 0.6") || string.equals("-//JPF//Java Plug-in Manifest 0.5") || string.equals("-//JPF//Java Plug-in Manifest 0.4") || string.equals("-//JPF//Java Plug-in Manifest 0.3") || string.equals("-//JPF//Java Plug-in Manifest 0.2")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("entity resolved to plug-in manifest DTD, publicId=" + string + ", systemId=" + string2));
                    }
                    return new InputSource(new StringReader(PLUGIN_DTD_1_0));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("entity not resolved, publicId=" + string + ", systemId=" + string2));
                }
                return null;
            }
        };
    }

    ManifestParser(boolean bl) {
        this.parserFactory.setValidating(bl);
        this.entityResolver = bl ? ManifestParser.getDtdEntityResolver() : null;
        log.info((Object)("got SAX parser factory - " + this.parserFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelPluginManifest parseManifest(URL uRL) throws ParserConfigurationException, SAXException, IOException {
        ManifestHandler manifestHandler = new ManifestHandler(this.entityResolver);
        InputStream inputStream = IoUtil.getResourceInputStream(uRL);
        try {
            this.parserFactory.newSAXParser().parse(inputStream, (DefaultHandler)manifestHandler);
        }
        finally {
            inputStream.close();
        }
        ModelPluginManifest modelPluginManifest = manifestHandler.getResult();
        modelPluginManifest.setLocation(uRL);
        return modelPluginManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelManifestInfo parseManifestInfo(URL uRL) throws ParserConfigurationException, SAXException, IOException {
        ManifestInfoHandler manifestInfoHandler = new ManifestInfoHandler(this.entityResolver);
        InputStream inputStream = IoUtil.getResourceInputStream(uRL);
        try {
            this.parserFactory.newSAXParser().parse(inputStream, (DefaultHandler)manifestInfoHandler);
        }
        finally {
            inputStream.close();
        }
        return manifestInfoHandler.getResult();
    }
}

