/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.w3c.util.DateParser;

public abstract class FieldBase
implements IField {
    protected String ttvXPath;
    protected String value;
    protected String largeValue;
    protected Date dateValue;
    protected Long intValue;
    protected Float floatValue;
    protected List<Integer> indices;
    protected Asset root;
    protected long id;
    protected String dataType;
    protected Asset parentAsset;
    protected Boolean parsable = true;
    private static final Logger logger = Logger.getLogger(Field.class);

    public FieldBase() {
        this.indices = new ArrayList<Integer>();
    }

    public FieldBase(String ttvXPath, String value) {
        this();
        this.setTtvXPath(ttvXPath);
        this.value = value;
    }

    public FieldBase(IField copyFromField) {
        this.setTtvXPath(copyFromField.getTtvXPath());
        if (copyFromField.getDataType() != null) {
            this.dataType = copyFromField.getDataType();
        }
        this.setValue(copyFromField.getValue());
        this.setIndices(copyFromField.getIndices());
        if (copyFromField.getRoot() != null) {
            this.setRoot(copyFromField.getRoot());
        }
        if (copyFromField.getParentAsset() != null) {
            this.setParentAsset(copyFromField.getParentAsset());
        }
    }

    @Override
    public String getTtvXPath() {
        return this.ttvXPath;
    }

    @Override
    public void setTtvXPath(String ttvXPath) {
        this.ttvXPath = ttvXPath;
        this.checkAndSetDataType();
        if (this.value != null) {
            this.setValue(this.value);
        }
    }

    @Override
    public String getValue() {
        if (this.largeValue != null && !this.largeValue.equals("")) {
            return this.largeValue;
        }
        try {
            if (this.dataType.equals("integer")) {
                if (this.intValue != null) {
                    return String.valueOf(this.intValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.value;
                }
                return "";
            }
            if (this.dataType.equals("float")) {
                if (this.floatValue != null) {
                    return String.valueOf(this.floatValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.value;
                }
                return "";
            }
            if (this.dataType.equals("date")) {
                if (this.dateValue != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    return sdf.format(this.dateValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.value;
                }
                return "";
            }
            return this.value;
        }
        catch (Exception e) {
            return this.value;
        }
    }

    @Override
    public Object getTypedValue() {
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        try {
            if (!this.parsable.booleanValue()) {
                logger.debug((Object)("For xpath: " + this.ttvXPath + ", dataType: " + this.dataType + ", value: " + this.value + " returning unparseable value"));
                return value;
            }
            if (this.dataType.equals("string")) {
                return value;
            }
            if (this.dataType.equals("integer")) {
                return Long.parseLong(value);
            }
            if (this.dataType.equals("boolean")) {
                return Boolean.parseBoolean(value);
            }
            if (this.dataType.equals("float")) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (this.dataType.equals("time")) {
                return value;
            }
            if (this.dataType.equals("date")) {
                return DateUtil.convertDate(value);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("For xpath: " + this.ttvXPath + ", dataType: " + this.dataType + ", value: " + this.value + " returning null"));
            return null;
        }
        return null;
    }

    @Override
    public void setTypedValue(Object value) {
        String stringValue = null;
        if (value instanceof Date) {
            stringValue = DateParser.getIsoDateNoMillis((Date)value);
        } else if (value instanceof Boolean || value instanceof Long || value instanceof Float || value instanceof String) {
            stringValue = value.toString();
        }
        this.setValue(stringValue);
    }

    @Override
    public void setValue(String value) {
        if (value != null && value.length() > 2000) {
            this.largeValue = value;
            this.value = value.substring(0, 2000);
        } else {
            this.largeValue = "";
            try {
                if (this.dataType.equals("integer")) {
                    this.intValue = Long.parseLong(value);
                    this.value = null;
                } else if (this.dataType.equals("float")) {
                    this.floatValue = Float.valueOf(Float.parseFloat(value));
                    this.value = null;
                } else if (this.dataType.equals("date")) {
                    this.dateValue = DateUtil.convertDate(value);
                    this.value = null;
                } else {
                    this.value = value;
                }
                this.parsable = true;
            }
            catch (Exception e) {
                logger.debug((Object)"There was an error converting the value into the specified datatype. Defaulting to Error");
                this.value = value;
                this.parsable = false;
            }
        }
    }

    @Override
    public List<Integer> getIndices() {
        return this.indices;
    }

    @Override
    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    @Override
    public Asset getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Asset root) {
        this.root = root;
    }

    @Override
    public String getStoredIndices() {
        StringBuilder sb = new StringBuilder();
        for (Integer index : this.indices) {
            sb.append("#");
            try {
                sb.append(index);
            }
            catch (Exception e) {}
        }
        return sb.toString();
    }

    private void setStoredIndices(String indices) {
        String[] split = indices.split("#");
        boolean first = true;
        for (String index : split) {
            if (first) {
                first = false;
                continue;
            }
            try {
                this.indices.add(Integer.parseInt(index));
            }
            catch (Exception e) {
                this.indices.add(null);
            }
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.checkAndSetDataType();
    }

    protected void checkAndSetDataType() {
        if (this.ttvXPath != null && !this.ttvXPath.equals("")) {
            String type = DataTypeMappingReader.getInstance().determineDataType(this.ttvXPath);
            if (type == null || type.equals("")) {
                if (this.dataType == null || this.dataType.equals("")) {
                    this.dataType = "string";
                }
            } else {
                this.dataType = type;
            }
        }
    }

    @Override
    public Asset getParentAsset() {
        return this.parentAsset;
    }

    @Override
    public void setParentAsset(Asset parentAsset) {
        this.parentAsset = parentAsset;
    }

    @Override
    public String toString() {
        return "[" + this.id + "] " + this.getTtvXPath() + ", " + this.getValue() + " " + this.getStoredIndices();
    }

    private String getLargeValue() {
        return this.largeValue;
    }

    private void setLargeValue(String largeValue) {
        this.largeValue = largeValue;
    }

    public Boolean getParsable() {
        return this.parsable;
    }

    public void setParsable(Boolean parsable) {
        this.parsable = parsable;
    }

    public String getTtvXPathWithIndices() {
        return FieldBase.buildTtvXPathWithIndices(this.ttvXPath, this.indices);
    }

    public static String buildTtvXPathWithIndices(String xpath, List<Integer> indices) {
        StringTokenizer strTok = new StringTokenizer(xpath, "/");
        String str = "";
        int i = 0;
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (i > 0) {
                str = str + "/";
            }
            if (!token.startsWith("@")) {
                token = token + "[" + indices.get(i) + "]";
                ++i;
            }
            str = str + token;
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (obj.getClass().getSuperclass().equals(FieldBase.class)) {
            FieldBase f = (FieldBase)obj;
            if (f.id > 0L && this.id > 0L) {
                return f.id == this.id;
            }
            return f.dataType.equals(this.dataType) && f.getTtvXPath().equals(this.getTtvXPath()) && f.getValue().equals(this.getValue());
        }
        return false;
    }
}

