/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.carol.util.configuration.ConfigurationException;
import org.objectweb.carol.util.configuration.TraceCarol;

public class ServerConfiguration {
    private Properties properties = null;
    private boolean startNS = false;
    private boolean startJNDI = false;
    private boolean startRMI = false;

    protected ServerConfiguration(Properties properties) throws ConfigurationException {
        String key;
        this.properties = properties;
        if (properties == null) {
            throw new ConfigurationException("Cannot build a server configuration withotu properties");
        }
        this.startNS = this.getBooleanValue("carol.start.ns");
        this.startRMI = this.getBooleanValue("carol.start.rmi");
        this.startJNDI = this.getBooleanValue("carol.start.jndi");
        Properties jvmProperties = new Properties();
        if (this.startRMI) {
            jvmProperties.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.objectweb.carol.rmi.multi.MultiPRODelegate");
        }
        if (this.startJNDI) {
            jvmProperties.setProperty("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
        }
        String protocols = properties.getProperty("carol.protocols");
        boolean isMultiProtocols = false;
        if (protocols != null) {
            isMultiProtocols = protocols.split(",").length > 1;
        }
        String jndiPrefix = "carol.jndi";
        String multiJvmPrefix = "multi.carol.jvm";
        String singleJvmPrefix = "carol.jvm";
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String newKey;
            key = (String)e.nextElement();
            if (key.startsWith(jndiPrefix)) {
                jvmProperties.setProperty(key.substring(jndiPrefix.length() + 1), properties.getProperty(key));
            }
            if (key.startsWith(multiJvmPrefix) && isMultiProtocols) {
                newKey = key.substring(multiJvmPrefix.length() + 1);
                jvmProperties.setProperty(newKey, "");
            }
            if (!key.startsWith(singleJvmPrefix)) continue;
            newKey = key.substring(singleJvmPrefix.length() + 1);
            jvmProperties.setProperty(newKey, properties.getProperty(key));
        }
        e = jvmProperties.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            String value = jvmProperties.getProperty(key);
            System.setProperty(key, value);
            if (!TraceCarol.isDebugCarol()) continue;
            TraceCarol.debugCarol("Set the JVM property '" + key + "' with the value '" + value + "'.");
        }
    }

    protected boolean getBooleanValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return new Boolean(s.trim());
    }

    public boolean isStartingJNDI() {
        return this.startJNDI;
    }

    public boolean isStartingNS() {
        return this.startNS;
    }

    public boolean isStartingRMI() {
        return this.startRMI;
    }
}

