/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private List observedObjects = new ArrayList();
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server = null;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    boolean isActive = false;
    long sequenceNumber = 0L;

    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void postDeregister() {
    }

    public void preDeregister() throws Exception {
        if (Monitor.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public abstract void start();

    public abstract void stop();

    synchronized void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    static boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)4);
    }

    static boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)4);
    }

    void insertSpecificElementAt(int n) {
    }

    void removeSpecificElementAt(int n) {
    }

    synchronized void resetAllAlreadyNotified(int n) {
        this.alreadyNotifieds[n] = 0;
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized void resetAlreadyNotified(int n, int n2) {
        int n3 = n;
        this.alreadyNotifieds[n3] = this.alreadyNotifieds[n3] & ~n2;
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized void setAlreadyNotified(int n, int n2) {
        int n3 = n;
        this.alreadyNotifieds[n3] = this.alreadyNotifieds[n3] | n2;
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized boolean alreadyNotified(int n, int n2) {
        return (this.alreadyNotifieds[n] & n2) != 0;
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("Nonpositive granularity period");
        }
        this.granularityPeriod = l;
    }

    int[] expandArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length + 16];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    synchronized void removeElementAt(int[] nArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(nArray, n + 1, nArray, n, n2);
        }
    }

    long[] expandArray(long[] lArray) {
        long[] lArray2 = new long[lArray.length + 16];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    synchronized void removeElementAt(long[] lArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(lArray, n + 1, lArray, n, n2);
        }
    }

    boolean[] expandArray(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length + 16];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    synchronized void removeElementAt(boolean[] blArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(blArray, n + 1, blArray, n, n2);
        }
    }

    public void postRegister(Boolean bl) {
    }

    synchronized void removeElementAt(Object[] objectArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(objectArray, n + 1, objectArray, n, n2);
        }
        objectArray[this.elementCount - 1] = null;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null observed attribute");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.observedAttribute = string;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getObservedObject() {
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedObjects.isEmpty()) {
                return null;
            }
            return (ObjectName)this.observedObjects.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getObservedObjects() {
        ObjectName[] objectNameArray;
        Monitor monitor = this;
        synchronized (monitor) {
            objectNameArray = new ObjectName[this.elementCount];
            for (int i = 0; i < this.elementCount; ++i) {
                objectNameArray[i] = (ObjectName)this.observedObjects.get(i);
            }
        }
        return objectNameArray;
    }

    synchronized ObjectName getObservedObject(int n) throws ArrayIndexOutOfBoundsException {
        return (ObjectName)this.observedObjects.get(n);
    }

    synchronized int indexOf(ObjectName objectName) {
        return this.observedObjects.indexOf(objectName);
    }

    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.observedObjects.contains(objectName)) {
            return;
        }
        this.observedObjects.add(objectName);
        int n = 0;
        n &= 0xFFFFFFF8;
        if (this.alreadyNotifieds.length >= this.elementCount) {
            this.alreadyNotifieds = this.expandArray(this.alreadyNotifieds);
        }
        this.alreadyNotifieds[this.elementCount] = n;
        this.updateDeprecatedAlreadyNotified();
        this.insertSpecificElementAt(this.elementCount);
        ++this.elementCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservedObject(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n = this.observedObjects.indexOf(objectName);
            if (n >= 0) {
                this.observedObjects.remove(n);
                this.removeElementAt(this.alreadyNotifieds, n);
                this.updateDeprecatedAlreadyNotified();
                this.removeSpecificElementAt(n);
                --this.elementCount;
            }
        }
    }

    public synchronized void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        while (!this.observedObjects.isEmpty()) {
            this.removeObservedObject((ObjectName)this.observedObjects.get(0));
        }
        this.addObservedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObservedObject(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            return this.observedObjects.contains(objectName);
        }
    }

    Number[] expandArray(Number[] numberArray) {
        Number[] numberArray2 = new Number[numberArray.length + 16];
        System.arraycopy(numberArray, 0, numberArray2, 0, numberArray.length);
        return numberArray2;
    }

    void debug(String string, String string2) {
        Monitor.debug(this.dbgTag, string, string2);
    }

    void trace(String string, String string2) {
        Monitor.trace(this.dbgTag, string, string2);
    }

    String[] expandArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 16];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    static void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)4, (String)string, (String)string2, (String)string3);
    }

    static void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)4, (String)string, (String)string2, (String)string3);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (Monitor.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = mBeanServer;
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(String string, long l, String string2, Object object, Object object2, int n) {
        long l2;
        if (Monitor.isTraceOn()) {
            this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.getObservedObject(n) + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + object);
        }
        Monitor monitor = this;
        synchronized (monitor) {
            l2 = this.sequenceNumber++;
        }
        this.sendNotification(new MonitorNotification(string, this, l2, l, string2, this.getObservedObject(n), this.observedAttribute, object, object2));
    }
}

