/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginRegistry;

class ParameterValueParser {
    private Object value;
    private final boolean isParsingSucceeds;
    private String parsingMessage;

    private static ExtensionPoint getExtensionPoint(PluginRegistry pluginRegistry, String string) {
        String string2 = pluginRegistry.extractPluginId(string);
        if (!pluginRegistry.isPluginDescriptorAvailable(string2)) {
            return null;
        }
        String string3 = pluginRegistry.extractId(string);
        for (ExtensionPoint extensionPoint : pluginRegistry.getPluginDescriptor(string2).getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string3)) continue;
            return extensionPoint;
        }
        return null;
    }

    ParameterValueParser(PluginRegistry pluginRegistry, ExtensionPoint.ParameterDefinition parameterDefinition, String string) {
        if (parameterDefinition == null) {
            this.parsingMessage = "parameter definition is NULL";
            this.isParsingSucceeds = false;
            return;
        }
        if (string == null) {
            this.isParsingSucceeds = true;
            return;
        }
        if (ParameterType.ANY == parameterDefinition.getType() || ParameterType.NULL == parameterDefinition.getType()) {
            this.isParsingSucceeds = true;
            return;
        }
        if (ParameterType.STRING == parameterDefinition.getType()) {
            this.value = string;
            this.isParsingSucceeds = true;
            return;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            this.isParsingSucceeds = true;
            return;
        }
        switch (parameterDefinition.getType()) {
            case BOOLEAN: {
                if ("true".equals(string2)) {
                    this.value = Boolean.TRUE;
                    break;
                }
                if ("false".equals(string2)) {
                    this.value = Boolean.FALSE;
                    break;
                }
                this.isParsingSucceeds = false;
                return;
            }
            case NUMBER: {
                try {
                    this.value = NumberFormat.getInstance(Locale.ENGLISH).parse(string2);
                    break;
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case DATE: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                try {
                    this.value = simpleDateFormat.parse(string2);
                    break;
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case TIME: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
                try {
                    this.value = simpleDateFormat.parse(string2);
                    break;
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case DATE_TIME: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                try {
                    this.value = simpleDateFormat.parse(string2);
                    break;
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case PLUGIN_ID: {
                try {
                    this.value = pluginRegistry.getPluginDescriptor(string2);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.parsingMessage = "unknown plug-in ID " + string2;
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case EXTENSION_POINT_ID: {
                this.value = ParameterValueParser.getExtensionPoint(pluginRegistry, string2);
                if (this.value == null) {
                    this.parsingMessage = "unknown extension point UID " + string2;
                    this.isParsingSucceeds = false;
                    return;
                }
                if (parameterDefinition.getCustomData() == null) break;
                ExtensionPoint extensionPoint = ParameterValueParser.getExtensionPoint(pluginRegistry, parameterDefinition.getCustomData());
                if (extensionPoint == null) {
                    this.parsingMessage = "unknown extension point UID " + parameterDefinition.getCustomData() + " provided as custom data";
                    this.isParsingSucceeds = false;
                    return;
                }
                if (((ExtensionPoint)this.value).isSuccessorOf(extensionPoint)) break;
                this.parsingMessage = "extension point with UID " + string2 + " doesn't \"inherit\" point that is defined" + " according to custom data in parameter" + " definition - " + parameterDefinition.getCustomData();
                this.isParsingSucceeds = false;
                return;
            }
            case EXTENSION_ID: {
                String string3 = pluginRegistry.extractId(string2);
                for (Extension object2 : pluginRegistry.getPluginDescriptor(pluginRegistry.extractPluginId(string2)).getExtensions()) {
                    if (!object2.getId().equals(string3)) continue;
                    this.value = object2;
                    break;
                }
                if (this.value == null) {
                    this.parsingMessage = "unknown extension UID " + string2;
                    this.isParsingSucceeds = false;
                    return;
                }
                if (parameterDefinition.getCustomData() == null) break;
                ExtensionPoint extensionPoint = ParameterValueParser.getExtensionPoint(pluginRegistry, parameterDefinition.getCustomData());
                if (extensionPoint == null) {
                    this.parsingMessage = "unknown extension point UID " + parameterDefinition.getCustomData() + " provided as custom data in parameter definition " + parameterDefinition;
                    this.isParsingSucceeds = false;
                    return;
                }
                String string4 = pluginRegistry.makeUniqueId(((Extension)this.value).getExtendedPluginId(), ((Extension)this.value).getExtendedPointId());
                ExtensionPoint extensionPoint2 = ParameterValueParser.getExtensionPoint(pluginRegistry, string4);
                if (extensionPoint2 == null) {
                    this.parsingMessage = "extension point " + string4 + " is unknown for extension " + ((Extension)this.value).getUniqueId();
                    this.isParsingSucceeds = false;
                    return;
                }
                if (extensionPoint2.equals(extensionPoint) || extensionPoint2.isSuccessorOf(extensionPoint)) break;
                this.parsingMessage = "extension with UID " + string2 + " extends point that not allowed according" + " to custom data defined in parameter" + " definition - " + parameterDefinition.getCustomData();
                this.isParsingSucceeds = false;
                return;
            }
            case FIXED: {
                StringTokenizer stringTokenizer = new StringTokenizer(parameterDefinition.getCustomData(), "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!string2.equals(stringTokenizer.nextToken().trim())) continue;
                    this.value = string2;
                    this.isParsingSucceeds = true;
                    return;
                }
                this.parsingMessage = "not allowed value " + string2;
                this.isParsingSucceeds = false;
                return;
            }
            case RESOURCE: {
                try {
                    this.value = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    this.parsingMessage = "can't parse value " + string2 + " as an absolute URL, will treat it as relative URL";
                    this.value = null;
                }
                this.isParsingSucceeds = true;
                return;
            }
            case ANY: {
                break;
            }
            case NULL: {
                break;
            }
        }
        this.isParsingSucceeds = true;
    }

    Object getValue() {
        return this.value;
    }

    String getParsingMessage() {
        return this.parsingMessage;
    }

    boolean isParsingSucceeds() {
        return this.isParsingSucceeds;
    }
}

