/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

public class RangeFieldInfo
extends FieldInfo {
    SearchOperator operator;
    String rangeStart;
    String rangeEnd;

    public RangeFieldInfo() {
        this.operator = SearchOperator.IN;
        this.isConjunction = true;
    }

    public RangeFieldInfo(String ttvxpath, String rangeStart, String rangeEnd) {
        this.ttvxpath = ttvxpath;
        this.operator = SearchOperator.IN;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.isConjunction = true;
    }

    public RangeFieldInfo(String ttvxpath, String rangeStart, String rangeEnd, boolean isConjunction) {
        this.ttvxpath = ttvxpath;
        this.operator = SearchOperator.IN;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.isConjunction = isConjunction;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public String getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(String rangeStart) {
        this.rangeStart = rangeStart;
    }

    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(String rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    @Override
    public void createEntity(String property, Entity assetEntity) {
        String valueColumnName = "";
        SearchType searchType = SearchType.STRING;
        Entity field = new Entity("field", property, "f");
        if (this.ttvxpath.contains("CustomField[@name")) {
            this.handleCustomFieldValueParameter(field);
            field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
        } else {
            field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
            valueColumnName = this.getValueColumnName();
            searchType = this.getSearchTypeBasedOnColumn(valueColumnName);
            RangeParameter rangeParam = new RangeParameter(valueColumnName, searchType);
            rangeParam.setFrom(this.getRangeStart());
            rangeParam.setTo(this.getRangeEnd());
            field.addParameter((SearchParameterBase)rangeParam);
        }
        ValueParameter assetTypeParam = this.addAssetTypeCriteria();
        if (assetTypeParam != null) {
            field.addParameter((SearchParameterBase)assetTypeParam);
        }
        assetEntity.addParameter((SearchParameterBase)field, this.isConjunction());
    }

    private void handleCustomFieldValueParameter(Entity field) {
        RangeParameter rangeParam;
        boolean isInt = true;
        boolean isFloat = true;
        boolean isDate = false;
        boolean isString = false;
        try {
            Integer.parseInt(this.getRangeStart());
            rangeParam = new RangeParameter("intValue", SearchType.NUMERIC);
            rangeParam.setFrom(this.getRangeStart());
            rangeParam.setTo(this.getRangeEnd());
            field.addParameter((SearchParameterBase)rangeParam);
        }
        catch (NumberFormatException e) {
            isInt = false;
        }
        if (!isInt) {
            try {
                Float.parseFloat(this.getRangeStart());
                rangeParam = new RangeParameter("floatValue", SearchType.NUMERIC);
                rangeParam.setFrom(this.getRangeStart());
                rangeParam.setTo(this.getRangeEnd());
                field.addParameter((SearchParameterBase)rangeParam);
            }
            catch (NumberFormatException e) {
                isFloat = false;
            }
            if (!isFloat) {
                try {
                    DateParser.parse(this.getRangeStart());
                    rangeParam = new RangeParameter("dateValue", SearchType.DATE);
                    rangeParam.setFrom(this.getRangeStart());
                    rangeParam.setTo(this.getRangeEnd());
                    field.addParameter((SearchParameterBase)rangeParam);
                }
                catch (NumberFormatException e) {
                    isDate = false;
                }
                catch (InvalidDateException e) {
                    isDate = false;
                }
                if (!isDate) {
                    rangeParam = new RangeParameter("value", SearchType.STRING);
                    rangeParam.setFrom(this.getRangeStart());
                    rangeParam.setTo(this.getRangeEnd());
                    field.addParameter((SearchParameterBase)rangeParam);
                    isString = true;
                }
            }
        }
        if (!isString) {
            rangeParam = new RangeParameter("value", SearchType.STRING);
            rangeParam.setFrom(this.getRangeStart());
            rangeParam.setTo(this.getRangeEnd());
            field.addParameter((SearchParameterBase)rangeParam, false);
        }
    }
}

