/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobWriter
extends Writer {
    DBConversion dbConversion;
    CLOB clob;
    long lobOffset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:31_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleClobWriter(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getInternalConnection()).getDefaultStreamChunkSize() / 3, 1L);
    }

    public OracleClobWriter(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || cLOB.getJavaSqlConnection() == null || l2 < 1L) {
            throw new IllegalArgumentException();
        }
        this.dbConversion = ((PhysicalConnection)cLOB.getInternalConnection()).conversion;
        this.clob = cLOB;
        this.lobOffset = l2;
        this.charBuf = new char[n2];
        this.nativeBuf = new byte[n2 * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = n2;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n4 = n2;
            int n5 = n4 + Math.min(n3, cArray.length - n2);
            while (n4 < n5) {
                int n6 = Math.min(this.chunkSize - this.count, n5 - n4);
                System.arraycopy(cArray, n4, this.charBuf, this.count, n6);
                n4 += n6;
                this.count += n6;
                if (this.count < this.chunkSize) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.count > 0) {
                    this.clob.setString(this.lobOffset, new String(this.charBuf, 0, this.count));
                    this.lobOffset += (long)this.count;
                    this.count = 0;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

