/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.sql.Datum;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibServer;
import oracle.sql.LnxLibThin;

public class NUMBER
extends Datum {
    static byte[] MAX_LONG = NUMBER.toBytes(Long.MAX_VALUE);
    static byte[] MIN_LONG = NUMBER.toBytes(Long.MIN_VALUE);
    private static final int CHARACTER_ZERO = 48;
    private static final BigDecimal BIGDEC_NEGZERO = new BigDecimal("-0");
    private static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDEC_ONE = BigDecimal.valueOf(1L);
    private static final BigInteger BIGINT_ZERO = BigInteger.valueOf(0L);
    private static final BigInteger BIGINT_HUND = BigInteger.valueOf(100L);
    private static final byte DIGEND = 21;
    private static final byte ODIGEND = 9;
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final double BIGRATIO = 0.1505149978319906;
    private static final int BIGLENMAX = 22;
    static final byte LNXM_NUM = 22;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final double ORANUM_FBASE = 100.0;
    static final int LNXBASE = 100;
    static final byte IEEE_DBL_DIG = 15;
    private static final byte IEEE_FLT_DIG = 6;
    static final int LNXEXPMX = 127;
    static final int LNXEXPMN = 0;
    static final int LNXMXOUT = 40;
    static final int LNXMXFMT = 64;
    private static final byte BYTE_MAX_VALUE = 127;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final byte[] PI = new byte[]{-63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21};
    private static final byte[] E = new byte[]{-63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77};
    private static final byte[] LN10 = new byte[]{-63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61};
    private static LnxLib _slnxlib;
    private static LnxLib _thinlib;
    private static int DBL_MAX;
    private static int INT_MAX;
    private static float FLOAT_MAX_INT;
    private static float FLOAT_MIN_INT;
    private static double DOUBLE_MAX_INT;
    private static double DOUBLE_MIN_INT;
    private static double DOUBLE_MAX_INT_2;
    private static double DOUBLE_MIN_INT_2;
    private static Object drvType;
    private static String LANGID;

    static {
        _thinlib = null;
        DBL_MAX = 40;
        INT_MAX = 15;
        FLOAT_MAX_INT = 2.1474836E9f;
        FLOAT_MIN_INT = -2.1474836E9f;
        DOUBLE_MAX_INT = 2.147483647E9;
        DOUBLE_MIN_INT = -2.147483648E9;
        DOUBLE_MAX_INT_2 = 2.147483649E9;
        DOUBLE_MIN_INT_2 = -2.147483649E9;
        drvType = null;
        try {
            drvType = System.getProperty("oracle.jserver.version");
        }
        catch (SecurityException securityException) {
            drvType = null;
        }
        LANGID = "AMERICAN";
    }

    public NUMBER() {
        super(NUMBER._makeZero());
    }

    public NUMBER(byte by) {
        super(NUMBER.toBytes(by));
    }

    public NUMBER(double d2) throws SQLException {
        super(NUMBER.toBytes(d2));
    }

    public NUMBER(float f2) {
        super(NUMBER.toBytes(f2));
    }

    public NUMBER(int n2) {
        super(NUMBER.toBytes(n2));
    }

    public NUMBER(long l2) {
        super(NUMBER.toBytes(l2));
    }

    public NUMBER(Object object) throws SQLException {
        if (object instanceof Integer) {
            this.setShareBytes(NUMBER.toBytes((Integer)object));
        } else if (object instanceof Long) {
            this.setShareBytes(NUMBER.toBytes((Long)object));
        } else if (object instanceof Float) {
            this.setShareBytes(NUMBER.toBytes(((Float)object).floatValue()));
        } else if (object instanceof Double) {
            this.setShareBytes(NUMBER.toBytes((Double)object));
        } else if (object instanceof BigInteger) {
            this.setShareBytes(NUMBER.toBytes((BigInteger)object));
        } else if (object instanceof BigDecimal) {
            this.setShareBytes(NUMBER.toBytes((BigDecimal)object));
        } else if (object instanceof Boolean) {
            this.setShareBytes(NUMBER.toBytes((Boolean)object));
        } else if (object instanceof String) {
            this.setShareBytes(this.stringToBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public NUMBER(String string, int n2) throws SQLException {
        super(NUMBER.toBytes(string, n2));
    }

    public NUMBER(BigDecimal bigDecimal) throws SQLException {
        super(NUMBER.toBytes(bigDecimal));
    }

    public NUMBER(BigInteger bigInteger) throws SQLException {
        super(NUMBER.toBytes(bigInteger));
    }

    public NUMBER(short s2) {
        super(NUMBER.toBytes(s2));
    }

    public NUMBER(boolean bl) {
        super(NUMBER.toBytes(bl));
    }

    public NUMBER(byte[] byArray) {
        super(byArray);
    }

    private static void _byteTo2Chars(byte by, char[] cArray, int n2) {
        if (by < 0) {
            cArray[n2] = 48;
            cArray[n2 + 1] = 48;
        } else if (by < 10) {
            cArray[n2] = 48;
            cArray[n2 + 1] = (char)(48 + by);
        } else if (by < 100) {
            cArray[n2] = (char)(48 + by / 10);
            cArray[n2 + 1] = (char)(48 + by % 10);
        } else {
            cArray[n2] = 48;
            cArray[n2 + 1] = 48;
        }
    }

    private static int _byteToChars(byte by, char[] cArray, int n2) {
        if (by < 0) {
            return 0;
        }
        if (by < 10) {
            cArray[n2] = (char)(48 + by);
            return 1;
        }
        if (by < 100) {
            cArray[n2] = (char)(48 + by / 10);
            cArray[n2 + 1] = (char)(48 + by % 10);
            return 2;
        }
        cArray[n2] = 49;
        cArray[n2 + 1] = (char)(48 + by / 10 - 10);
        cArray[n2 + 2] = (char)(48 + by % 10);
        return 3;
    }

    static byte[] _fromLnxFmt(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)((byArray[0] & 0xFFFFFF7F) - 65);
            int n3 = 1;
            while (n3 < n2) {
                byArray2[n3] = (byte)(byArray[n3] - 1);
                ++n3;
            }
        } else {
            byArray2 = n2 - 1 == 20 && byArray[n2 - 1] != 102 ? new byte[n2] : new byte[n2 - 1];
            byArray2[0] = (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
            int n4 = 1;
            while (n4 < byArray2.length) {
                byArray2[n4] = (byte)(101 - byArray[n4]);
                ++n4;
            }
        }
        return byArray2;
    }

    private static LnxLib _getLnxLib() {
        block3: {
            if (_slnxlib != null) break block3;
            try {
                if (System.getProperty("oracle.jserver.version") != null) {
                    _slnxlib = new LnxLibServer();
                    break block3;
                }
                _slnxlib = new LnxLibThin();
            }
            catch (SecurityException securityException) {
                _slnxlib = new LnxLibThin();
            }
        }
        return _slnxlib;
    }

    private static LnxLib _getThinLib() {
        if (_thinlib == null) {
            _thinlib = new LnxLibThin();
        }
        return _thinlib;
    }

    static boolean _isInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101 || byArray[0] == 0 && byArray.length == 1;
    }

    private static boolean _isInt(byte[] byArray) {
        byte by;
        if (NUMBER._isZero(byArray)) {
            return true;
        }
        if (NUMBER._isInf(byArray)) {
            return false;
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        byte by2 = (byte)(byArray2.length - 1);
        return by2 <= (by = byArray2[0]) + 1;
    }

    static boolean _isNegInf(byte[] byArray) {
        return byArray[0] == 0 && byArray.length == 1;
    }

    static boolean _isPosInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101;
    }

    static boolean _isPositive(byte[] byArray) {
        return (byArray[0] & 0xFFFFFF80) != 0;
    }

    static boolean _isZero(byte[] byArray) {
        return byArray[0] == -128 && byArray.length == 1;
    }

    static byte[] _makeNegInf() {
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    static byte[] _makePosInf() {
        byte[] byArray = new byte[]{-1, 101};
        return byArray;
    }

    static byte[] _makeZero() {
        byte[] byArray = new byte[]{-128};
        return byArray;
    }

    private static void _printBytes(byte[] byArray) {
        int n2 = byArray.length;
        System.out.print(String.valueOf(n2) + ": ");
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(String.valueOf(byArray[n3]) + " ");
            ++n3;
        }
        System.out.println();
    }

    static byte[] _toLnxFmt(byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (bl) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)(byArray[0] + 128 + 64 + 1);
            int n3 = 1;
            while (n3 < n2) {
                byArray2[n3] = (byte)(byArray[n3] + 1);
                ++n3;
            }
        } else {
            byArray2 = n2 - 1 < 20 ? new byte[n2 + 1] : new byte[n2];
            byArray2[0] = (byte)(~(byArray[0] + 128 + 64 + 1));
            int n4 = 1;
            while (n4 < n2) {
                byArray2[n4] = (byte)(101 - byArray[n4]);
                ++n4;
            }
            if (n4 <= 20) {
                byArray2[n4] = 102;
            }
        }
        return byArray2;
    }

    public NUMBER abs() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxabs(this.shareBytes()));
    }

    public NUMBER acos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxacos(this.shareBytes()));
    }

    public NUMBER add(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxadd(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER asin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxasin(this.shareBytes()));
    }

    public NUMBER atan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan(this.shareBytes()));
    }

    public NUMBER atan2(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan2(this.shareBytes(), nUMBER.shareBytes()));
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        return NUMBER.toBigDecimal(this.shareBytes());
    }

    public BigInteger bigIntegerValue() throws SQLException {
        return NUMBER.toBigInteger(this.shareBytes());
    }

    public boolean booleanValue() {
        return NUMBER.toBoolean(this.shareBytes());
    }

    public byte byteValue() throws SQLException {
        return NUMBER.toByte(this.shareBytes());
    }

    public NUMBER ceil() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxceil(this.shareBytes()));
    }

    public int compareTo(NUMBER nUMBER) {
        return Datum.compareBytes(this.shareBytes(), nUMBER.shareBytes());
    }

    public NUMBER cos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcos(this.shareBytes()));
    }

    public NUMBER cosh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcsh(this.shareBytes()));
    }

    public NUMBER decrement() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdec(this.shareBytes()));
    }

    public NUMBER div(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdiv(this.shareBytes(), nUMBER.shareBytes()));
    }

    public double doubleValue() {
        return NUMBER.toDouble(this.shareBytes());
    }

    public static NUMBER e() {
        return new NUMBER(E);
    }

    public NUMBER exp() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxexp(this.shareBytes()));
    }

    public float floatValue() {
        return NUMBER.toFloat(this.shareBytes());
    }

    public NUMBER floatingPointRound(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfpr(this.shareBytes(), n2));
    }

    public NUMBER floor() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxflo(this.shareBytes()));
    }

    public static NUMBER formattedTextToNumber(String string, String string2, String string3) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfcn(string, string2, string3));
    }

    public NUMBER increment() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxinc(this.shareBytes()));
    }

    public int intValue() throws SQLException {
        return NUMBER.toInt(this.shareBytes());
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.Integer") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.lang.Float") == 0 || string.compareTo("java.lang.Double") == 0 || string.compareTo("java.math.BigInteger") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Boolean") == 0;
    }

    public boolean isInf() {
        return NUMBER._isInf(this.shareBytes());
    }

    public boolean isInt() {
        return NUMBER._isInt(this.shareBytes());
    }

    public boolean isNegInf() {
        return NUMBER._isNegInf(this.shareBytes());
    }

    public boolean isPosInf() {
        return NUMBER._isPosInf(this.shareBytes());
    }

    public static boolean isValid(byte[] byArray) {
        int n2 = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            if (n2 == 1) {
                return NUMBER._isZero(byArray);
            }
            if (byArray[0] == -1 && byArray[1] == 101) {
                return n2 == 2;
            }
            if (n2 > 21) {
                return false;
            }
            if (byArray[1] < 2 || byArray[n2 - 1] < 2) {
                return false;
            }
            int n3 = 1;
            while (n3 < n2) {
                byte by = byArray[n3];
                if (by < 1 || by > 100) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        if (n2 < 3) {
            return NUMBER._isNegInf(byArray);
        }
        if (n2 > 21) {
            return false;
        }
        if (byArray[n2 - 1] != 102) {
            if (n2 <= 20) {
                return false;
            }
        } else {
            n2 = (byte)(n2 - 1);
        }
        if (byArray[1] > 100 || byArray[n2 - 1] > 100) {
            return false;
        }
        int n4 = 1;
        while (n4 < n2) {
            byte by = byArray[n4];
            if (by < 2 || by > 101) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean isZero() {
        return NUMBER._isZero(this.shareBytes());
    }

    public NUMBER ln() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxln(this.shareBytes()));
    }

    public static NUMBER ln10() {
        return new NUMBER(LN10);
    }

    public NUMBER log(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxlog(this.shareBytes(), nUMBER.shareBytes()));
    }

    public long longValue() throws SQLException {
        return NUMBER.toLong(this.shareBytes());
    }

    public Object makeJdbcArray(int n2) {
        BigDecimal[] bigDecimalArray = new BigDecimal[n2];
        return bigDecimalArray;
    }

    public NUMBER mod(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmod(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER mul(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmul(this.shareBytes(), nUMBER.shareBytes()));
    }

    public static NUMBER negInf() {
        return new NUMBER(NUMBER._makeNegInf());
    }

    public NUMBER negate() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxneg(this.shareBytes()));
    }

    public static NUMBER pi() {
        return new NUMBER(PI);
    }

    public static NUMBER posInf() {
        return new NUMBER(NUMBER._makePosInf());
    }

    public NUMBER pow(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxpow(this.shareBytes(), n2));
    }

    public NUMBER pow(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxbex(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER round(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxrou(this.shareBytes(), n2));
    }

    public NUMBER scale(int n2, int n3, boolean[] blArray) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsca(this.shareBytes(), n2, n3, blArray));
    }

    public NUMBER shift(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxshift(this.shareBytes(), n2));
    }

    public short shortValue() throws SQLException {
        return NUMBER.toShort(this.shareBytes());
    }

    public int sign() {
        if (NUMBER._isZero(this.shareBytes())) {
            return 0;
        }
        return NUMBER._isPositive(this.shareBytes()) ? 1 : -1;
    }

    public NUMBER sin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsin(this.shareBytes()));
    }

    public NUMBER sinh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsnh(this.shareBytes()));
    }

    public NUMBER sqroot() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsqr(this.shareBytes()));
    }

    private byte[] stringToBytes(String string) throws SQLException {
        int n2 = 0;
        if ((string = string.trim()).indexOf(46) >= 0) {
            n2 = string.length() - 1 - string.indexOf(46);
        }
        return NUMBER.toBytes(string, n2);
    }

    public String stringValue() {
        return NUMBER.toString(this.shareBytes());
    }

    public NUMBER sub(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsub(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER tan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtan(this.shareBytes()));
    }

    public NUMBER tanh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtnh(this.shareBytes()));
    }

    public static NUMBER textToPrecisionNumber(String string, boolean bl, int n2, boolean bl2, int n3, String string2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcpn(string, bl, n2, bl2, n3, string2));
    }

    public static BigDecimal toBigDecimal(byte[] byArray) throws SQLException {
        int n2;
        long[] lArray = new long[10];
        int n3 = 9;
        int n4 = 1;
        int n5 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGDEC_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n6 = n2 = byArray2.length - 1;
        if ((n2 & 1) == 1) {
            lArray[n3] = byArray2[n4];
            n4 = (byte)(n4 + 1);
            --n6;
        } else {
            lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n7 = n3;
        while (n6 != 0) {
            long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
            n3 = 9;
            while (n3 >= n7) {
                lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                l2 >>= 16;
                n3 = (byte)(n3 - 1);
            }
            n7 = (byte)(n7 - 1);
            lArray[n7] = l2;
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
        byte[] byArray3 = new byte[n8];
        if ((n8 & 1) == 1) {
            byArray3[n5] = (byte)lArray[n7];
            ++n5;
        } else {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
            ++n5;
        }
        n7 = (byte)(n7 + 1);
        while (n7 <= 9) {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
            n5 += 2;
            n7 = (byte)(n7 + 1);
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        int n9 = byArray2[0] - n2 + 1;
        bigDecimal = bigDecimal.movePointRight(n9 * 2);
        if (n9 < 0 && byArray2[n2] % 10 == 0) {
            bigDecimal = bigDecimal.setScale(-(n9 * 2 + 1));
        }
        return bigDecimal;
    }

    public static BigInteger toBigInteger(byte[] byArray) throws SQLException {
        int n2;
        long[] lArray = new long[10];
        int n3 = 9;
        int n4 = 1;
        int n5 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGINT_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        if (byArray2[0] < 0) {
            return BIGINT_ZERO;
        }
        int n6 = n2 = Math.min(byArray2[0] + 1, byArray2.length - 1);
        if ((n2 & 1) == 1) {
            lArray[n3] = byArray2[n4];
            n4 = (byte)(n4 + 1);
            --n6;
        } else {
            lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n7 = n3;
        while (n6 != 0) {
            long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
            n3 = 9;
            while (n3 >= n7) {
                lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                l2 >>= 16;
                n3 = (byte)(n3 - 1);
            }
            n7 = (byte)(n7 - 1);
            lArray[n7] = l2;
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
        byte[] byArray3 = new byte[n8];
        if ((n8 & 1) == 1) {
            byArray3[n5] = (byte)lArray[n7];
            ++n5;
        } else {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
            ++n5;
        }
        n7 = (byte)(n7 + 1);
        while (n7 <= 9) {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
            n5 += 2;
            n7 = (byte)(n7 + 1);
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        int n9 = byArray2[0] - (n2 - 1);
        return bigInteger.multiply(BIGINT_HUND.pow(n9));
    }

    public static boolean toBoolean(byte[] byArray) {
        return !NUMBER._isZero(byArray);
    }

    public static byte toByte(byte[] byArray) throws SQLException {
        long l2 = 0L;
        l2 = NUMBER.toLong(byArray);
        if (l2 > 127L || l2 < -128L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (byte)l2;
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(byte by) {
        return NUMBER.toBytes((long)by);
    }

    public static byte[] toBytes(double d2) throws SQLException {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (d2 == 0.0 || d2 == -0.0) {
            return NUMBER._makeZero();
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        return NUMBER._getThinLib().lnxren(d2);
    }

    public static byte[] toBytes(float f2) {
        if (Float.isNaN(f2)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (f2 == 0.0f || f2 == -0.0f) {
            return NUMBER._makeZero();
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        String string = Float.toString(f2);
        try {
            return NUMBER._getLnxLib().lnxcpn(string, false, 0, false, 0, "AMERICAN_AMERICA");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] toBytes(int n2) {
        return NUMBER.toBytes((long)n2);
    }

    public static byte[] toBytes(long l2) {
        return NUMBER._getLnxLib().lnxmin(l2);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] toBytes(String var0, int var1_1) throws SQLException {
        block34: {
            block35: {
                var2_2 = 0;
                var3_3 = 0;
                var5_4 = new byte[22];
                var7_5 = 0;
                var9_6 = true;
                var10_7 = false;
                var11_8 = false;
                var12_9 = 0;
                var14_10 = 0;
                var15_11 = 0;
                var16_12 = 40;
                var17_13 = 0;
                var18_14 = 0;
                var19_15 = 0;
                var21_16 = 0;
                var0 = var0.trim();
                var20_17 = var0.length();
                if (var0.charAt(0) == '-') {
                    --var20_17;
                    var9_6 = false;
                    var19_15 = 1;
                }
                var2_2 = var20_17;
                var22_18 = new char[var20_17];
                var0.getChars(var19_15, var20_17 + var19_15, var22_18, 0);
                var4_19 = 0;
                while (var4_19 < var20_17) {
                    if (var22_18[var4_19] == '.') {
                        var11_8 = true;
                        break;
                    }
                    ++var4_19;
                }
                while (var3_3 < var2_2 && var22_18[var3_3] == '0') {
                    ++var3_3;
                    if (!var11_8) continue;
                    ++var21_16;
                }
                if (var3_3 == var2_2) {
                    return NUMBER._makeZero();
                }
                if (var20_17 < 2 || var22_18[var3_3] != '.') ** GOTO lbl74
                while (var2_2 > 0 && var22_18[var2_2 - 1] == '0') {
                    --var2_2;
                }
                if (++var3_3 == var2_2) {
                    return NUMBER._makeZero();
                }
                --var12_9;
                while (var3_3 < var2_2 - 1 && var22_18[var3_3] == '0' && var22_18[var3_3 + 1] == '0') {
                    --var12_9;
                    var15_11 += 2;
                    var3_3 += 2;
                }
                if (var12_9 < -65) {
                    throw new SQLException(CoreException.getMessage((byte)2));
                }
                if (var2_2 - var3_3 > var16_12) {
                    var6_20 = 2 + var16_12;
                    if (var15_11 > 0) {
                        var6_20 += var15_11;
                    }
                    if (var6_20 <= var2_2) {
                        var2_2 = var6_20;
                    }
                    var17_13 = var2_2;
                    var10_7 = true;
                }
                var7_5 = var2_2 - var3_3 >> 1;
                if ((var2_2 - var3_3) % 2 != 0) {
                    var5_4[var7_5] = (byte)(Integer.parseInt(new String(var22_18, var2_2 - 1, 1)) * 10);
                    ++var14_10;
                    --var2_2;
                }
                while (var2_2 > var3_3) {
                    var5_4[--var7_5] = (byte)Integer.parseInt(new String(var22_18, var2_2 - 2, 2));
                    var2_2 -= 2;
                    ++var14_10;
                }
                break block34;
lbl-1000:
                // 1 sources

                {
                    --var2_2;
                    --var1_1;
lbl74:
                    // 2 sources

                    ** while (var1_1 > 0 && var2_2 > 0 && var22_18[var2_2 - 1] == '0')
                }
lbl75:
                // 1 sources

                if (var1_1 != 0 || var2_2 <= 1) break block35;
                if (var22_18[var2_2 - 1] == '.') {
                    --var2_2;
                }
                if (var3_3 != var2_2) ** GOTO lbl82
                return NUMBER._makeZero();
lbl-1000:
                // 1 sources

                {
                    var2_2 -= 2;
                    ++var12_9;
lbl82:
                    // 2 sources

                    ** while (var2_2 > 1 && var22_18[var2_2 - 2] == '0' && var22_18[var2_2 - 1] == '0')
                }
            }
            if (var12_9 > 62) {
                throw new SQLException(CoreException.getMessage((byte)3));
            }
            if (var2_2 - var3_3 - (var11_8 != false ? 1 : 0) > var16_12) {
                var6_20 = var16_12 + (var11_8 != false ? 1 : 0);
                var23_21 = var2_2 - var6_20;
                var2_2 = var6_20;
                if ((var1_1 -= var23_21) < 0) {
                    var1_1 = 0;
                }
                var10_7 = true;
                var17_13 = var2_2;
            }
            v0 = var13_23 = var1_1 == 0 ? var2_2 - var3_3 : var2_2 - var1_1 - 1;
            if (var21_16 > 0) {
                var13_23 -= var21_16;
            }
            if (var13_23 % 2 != 0) {
                var18_14 = Integer.parseInt(new String(var22_18, var3_3, 1));
                ++var3_3;
                --var13_23;
                if (var2_2 - 1 == var16_12) {
                    --var1_1;
                    var10_7 = true;
                    var17_13 = --var2_2;
                }
            } else {
                var18_14 = Integer.parseInt(new String(var22_18, var3_3, 2));
                var3_3 += 2;
                var13_23 -= 2;
            }
            var5_4[var7_5] = (byte)var18_14;
            ++var7_5;
            ++var14_10;
            while (var13_23 > 0) {
                var5_4[var7_5] = (byte)Integer.parseInt(new String(var22_18, var3_3, 2));
                ++var7_5;
                var3_3 += 2;
                ++var12_9;
                var13_23 -= 2;
                ++var14_10;
            }
            if (var3_3 < var2_2) {
                if (var1_1 % 2 != 0) {
                    var5_4[var7_5 += var1_1 / 2] = (byte)(Integer.parseInt(new String(var22_18, var2_2 - 1, 1)) * 10);
                    --var2_2;
                    --var1_1;
                } else {
                    var5_4[var7_5 += var1_1 / 2 - 1] = (byte)Integer.parseInt(new String(var22_18, var2_2 - 2, 2));
                    var2_2 -= 2;
                    var1_1 -= 2;
                }
                ++var14_10;
                --var7_5;
            }
            while (var1_1 > 0) {
                var5_4[var7_5] = (byte)Integer.parseInt(new String(var22_18, var2_2 - 2, 2));
                --var7_5;
                var2_2 -= 2;
                var1_1 -= 2;
                ++var14_10;
            }
        }
        if (var10_7) {
            var23_21 = var14_10;
            var18_14 = Integer.parseInt(new String(var22_18, var17_13, 1));
            if (var18_14 >= 5) {
                v1 = --var23_21;
                var5_4[v1] = (byte)(var5_4[v1] + 1);
                while (var5_4[var23_21] == 100) {
                    if (var23_21 == 0) {
                        ++var12_9;
                        var5_4[var23_21] = 1;
                        break;
                    }
                    var5_4[var23_21] = 0;
                    v2 = --var23_21;
                    var5_4[v2] = (byte)(var5_4[v2] + 1);
                }
                var4_19 = var14_10 - 1;
                while (var4_19 >= 0) {
                    if (var5_4[var4_19] != 0) break;
                    --var14_10;
                    --var4_19;
                }
            }
        }
        var23_22 = new byte[var14_10 + 1];
        var23_22[0] = (byte)var12_9;
        System.arraycopy(var5_4, 0, var23_22, 1, var14_10);
        return NUMBER._toLnxFmt(var23_22, var9_6);
    }

    public static byte[] toBytes(BigDecimal bigDecimal) throws SQLException {
        int n2;
        long l2;
        BigDecimal bigDecimal2;
        byte[] byArray = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n3 = 21;
        int n4 = 0;
        int n5 = 21;
        int n6 = 0;
        int n7 = 0;
        BigDecimal bigDecimal3 = bigDecimal.abs();
        int n8 = 0;
        if (bigDecimal.signum() == 0) {
            return NUMBER._makeZero();
        }
        boolean bl = bigDecimal.signum() != -1;
        int n9 = bigDecimal.scale();
        if (n9 < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n9 = 0;
        }
        int n10 = bigDecimal3.compareTo(BIGDEC_ONE);
        int n11 = 0;
        if (n10 == -1) {
            while ((bigDecimal2 = bigDecimal3.movePointRight(++n11)).compareTo(BIGDEC_ONE) < 0) {
            }
            n8 = -n11;
        } else {
            while ((bigDecimal2 = bigDecimal3.movePointLeft(++n11)).compareTo(BIGDEC_ONE) >= 0) {
            }
            n8 = n11;
        }
        byte[] byArray2 = bigDecimal3.movePointRight(n9).toBigInteger().toByteArray();
        if (byArray2.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int n12 = 0;
        while (n12 < byArray2.length) {
            lArray[n12] = byArray2[n12] < 0 ? (long)(byArray2[n12] + 256) : (long)byArray2[n12];
            ++n12;
        }
        int n13 = byArray2.length;
        switch (n13 % 3) {
            case 2: {
                lArray2[n3] = (lArray[n4] << 8) + lArray[n4 + 1];
                n4 = (byte)(n4 + 2);
                n13 -= 2;
                break;
            }
            case 1: {
                lArray2[n3] = lArray[n4];
                n4 = (byte)(n4 + 1);
                --n13;
                break;
            }
            default: {
                l2 = (lArray[n4] << 16) + (lArray[n4 + 1] << 8) + lArray[n4 + 2];
                lArray2[n3] = l2 % 1000000L;
                lArray2[n3 - 1] = l2 / 1000000L;
                n5 = (byte)(n5 - (lArray2[n3 - 1] != 0L ? 1 : 0));
                n4 = (byte)(n4 + 3);
                n13 -= 3;
                break;
            }
        }
        while (n13 != 0) {
            l2 = (lArray[n4] << 4) + (lArray[n4 + 1] >> 4);
            n3 = 21;
            while (n3 >= n5) {
                lArray2[n3] = (l2 += lArray2[n3] << 12) % 1000000L;
                l2 /= 1000000L;
                n3 = (byte)(n3 - 1);
            }
            if (l2 != 0L) {
                n5 = (byte)(n5 - 1);
                lArray2[n5] = l2;
            }
            l2 = ((lArray[n4 + 1] & 0xFL) << 8) + lArray[n4 + 2];
            n3 = 21;
            while (n3 >= n5) {
                lArray2[n3] = (l2 += lArray2[n3] << 12) % 1000000L;
                l2 /= 1000000L;
                n3 = (byte)(n3 - 1);
            }
            if (l2 != 0L) {
                n5 = (byte)(n5 - 1);
                lArray2[n5] = l2;
            }
            n4 = (byte)(n4 + 3);
            n13 -= 3;
        }
        byArray[n6] = (byte)(lArray2[n5] / 10000L);
        if (byArray[n6] != 0) {
            n2 = 3 * (21 - n5) + 3;
            byArray[n6 + 1] = (byte)(lArray2[n5] % 10000L / 100L);
            byArray[n6 + 2] = (byte)(lArray2[n5] % 100L);
            n6 += 3;
        } else {
            byArray[n6] = (byte)(lArray2[n5] % 10000L / 100L);
            if (byArray[n6] != 0) {
                n2 = 3 * (21 - n5) + 2;
                byArray[n6 + 1] = (byte)(lArray2[n5] % 100L);
                n6 += 2;
            } else {
                byArray[n6] = (byte)lArray2[n5];
                n2 = 3 * (21 - n5) + 1;
                ++n6;
            }
        }
        n3 = (byte)(n5 + 1);
        while (n3 <= 21) {
            byArray[n6] = (byte)(lArray2[n3] / 10000L);
            byArray[n6 + 1] = (byte)(lArray2[n3] % 10000L / 100L);
            byArray[n6 + 2] = (byte)(lArray2[n3] % 100L);
            n6 += 3;
            n3 = (byte)(n3 + 1);
        }
        n12 = n6 - 1;
        while (n12 >= 0) {
            if (byArray[n12] != 0) break;
            --n2;
            --n12;
        }
        if (n9 > 0 && (n9 & 1) != 0) {
            int n14 = n2;
            byte[] byArray3 = new byte[n14 + 1];
            if (byArray[0] <= 9) {
                n12 = 0;
                while (n12 < n14 - 1) {
                    byArray3[n12] = (byte)(byArray[n12] % 10 * 10 + byArray[n12 + 1] / 10);
                    ++n12;
                }
                byArray3[n12] = (byte)(byArray[n12] % 10 * 10);
                if (byArray3[n14 - 1] == 0) {
                    --n2;
                }
            } else {
                byArray3[n14] = (byte)(byArray[n14 - 1] % 10 * 10);
                n12 = n14 - 1;
                while (n12 > 0) {
                    byArray3[n12] = (byte)(byArray[n12] / 10 + byArray[n12 - 1] % 10 * 10);
                    --n12;
                }
                byArray3[n12] = (byte)(byArray[n12] / 10);
                if (byArray3[n14] > 0) {
                    ++n2;
                }
            }
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        }
        if (n2 > 20) {
            n12 = 20;
            n2 = 20;
            if (byArray[n12] >= 50) {
                int n15 = --n12;
                byArray[n15] = (byte)(byArray[n15] + 1);
                while (byArray[n12] == 100) {
                    if (n12 == 0) {
                        ++n8;
                        byArray[n12] = 1;
                        break;
                    }
                    byArray[n12] = 0;
                    int n16 = --n12;
                    byArray[n16] = (byte)(byArray[n16] + 1);
                }
                n12 = n2 - 1;
                while (n12 >= 0) {
                    if (byArray[n12] != 0) break;
                    --n2;
                    --n12;
                }
            }
        }
        n7 = n8 <= 0 ? (byArray[0] < 10 ? -(2 - n8) / 2 + 1 : -(2 - n8) / 2) : (n8 - 1) / 2;
        if (n7 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (n7 <= -65) {
            throw new SQLException(CoreException.getMessage((byte)2));
        }
        byte[] byArray4 = new byte[n2 + 1];
        byArray4[0] = (byte)n7;
        System.arraycopy(byArray, 0, byArray4, 1, n2);
        return NUMBER._toLnxFmt(byArray4, bl);
    }

    public static byte[] toBytes(BigInteger bigInteger) throws SQLException {
        int n2;
        long l2;
        int n3;
        byte[] byArray;
        Object object;
        byte[] byArray2 = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n4 = 21;
        int n5 = 0;
        int n6 = 21;
        boolean bl = false;
        int n7 = 0;
        boolean bl2 = true;
        if (bigInteger.signum() == 0) {
            return NUMBER._makeZero();
        }
        if (bigInteger.signum() == -1) {
            object = bigInteger.abs();
            bl2 = false;
            byArray = ((BigInteger)object).toByteArray();
            n3 = (int)Math.floor((double)((BigInteger)object).bitLength() * 0.1505149978319906);
        } else {
            byArray = bigInteger.toByteArray();
            n3 = (int)Math.floor((double)bigInteger.bitLength() * 0.1505149978319906);
        }
        if (bigInteger.compareTo(BIGINT_HUND.pow(n3)) < 0) {
            --n3;
        }
        if (byArray.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int n8 = 0;
        while (n8 < byArray.length) {
            lArray[n8] = byArray[n8] < 0 ? (long)(byArray[n8] + 256) : (long)byArray[n8];
            ++n8;
        }
        int n9 = byArray.length;
        switch (n9 % 3) {
            case 2: {
                lArray2[n4] = (lArray[n5] << 8) + lArray[n5 + 1];
                n5 = (byte)(n5 + 2);
                n9 -= 2;
                break;
            }
            case 1: {
                lArray2[n4] = lArray[n5];
                n5 = (byte)(n5 + 1);
                --n9;
                break;
            }
            default: {
                l2 = (lArray[n5] << 16) + (lArray[n5 + 1] << 8) + lArray[n5 + 2];
                lArray2[n4] = l2 % 1000000L;
                lArray2[n4 - 1] = l2 / 1000000L;
                n6 = (byte)(n6 - (lArray2[n4 - 1] != 0L ? 1 : 0));
                n5 = (byte)(n5 + 3);
                n9 -= 3;
                break;
            }
        }
        while (n9 != 0) {
            l2 = (lArray[n5] << 4) + (lArray[n5 + 1] >> 4);
            n4 = 21;
            while (n4 >= n6) {
                lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                l2 /= 1000000L;
                n4 = (byte)(n4 - 1);
            }
            if (l2 != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l2;
            }
            l2 = ((lArray[n5 + 1] & 0xFL) << 8) + lArray[n5 + 2];
            n4 = 21;
            while (n4 >= n6) {
                lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                l2 /= 1000000L;
                n4 = (byte)(n4 - 1);
            }
            if (l2 != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l2;
            }
            n5 = (byte)(n5 + 3);
            n9 -= 3;
        }
        byArray2[n7] = (byte)(lArray2[n6] / 10000L);
        if (byArray2[n7] != 0) {
            n2 = 3 * (21 - n6) + 3;
            byArray2[n7 + 1] = (byte)(lArray2[n6] % 10000L / 100L);
            byArray2[n7 + 2] = (byte)(lArray2[n6] % 100L);
            n7 += 3;
        } else {
            byArray2[n7] = (byte)(lArray2[n6] % 10000L / 100L);
            if (byArray2[n7] != 0) {
                n2 = 3 * (21 - n6) + 2;
                byArray2[n7 + 1] = (byte)(lArray2[n6] % 100L);
                n7 += 2;
            } else {
                byArray2[n7] = (byte)lArray2[n6];
                n2 = 3 * (21 - n6) + 1;
                ++n7;
            }
        }
        n4 = (byte)(n6 + 1);
        while (n4 <= 21) {
            byArray2[n7] = (byte)(lArray2[n4] / 10000L);
            byArray2[n7 + 1] = (byte)(lArray2[n4] % 10000L / 100L);
            byArray2[n7 + 2] = (byte)(lArray2[n4] % 100L);
            n7 += 3;
            n4 = (byte)(n4 + 1);
        }
        n8 = n7 - 1;
        while (n8 >= 0) {
            if (byArray2[n8] != 0) break;
            --n2;
            --n8;
        }
        if (n2 > 19) {
            n8 = 20;
            n2 = 19;
            if (byArray2[n8] >= 50) {
                int n10 = --n8;
                byArray2[n10] = (byte)(byArray2[n10] + 1);
                while (byArray2[n8] == 100) {
                    if (n8 == 0) {
                        ++n3;
                        byArray2[n8] = 1;
                        break;
                    }
                    byArray2[n8] = 0;
                    int n11 = --n8;
                    byArray2[n11] = (byte)(byArray2[n11] + 1);
                }
                n8 = n2 - 1;
                while (n8 >= 0) {
                    if (byArray2[n8] != 0) break;
                    --n2;
                    --n8;
                }
            }
        }
        if (n3 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        object = new byte[n2 + 1];
        object[0] = (byte)n3;
        System.arraycopy(byArray2, 0, object, 1, n2);
        return NUMBER._toLnxFmt((byte[])object, bl2);
    }

    public static byte[] toBytes(short s2) {
        return NUMBER.toBytes((long)s2);
    }

    public static byte[] toBytes(boolean bl) {
        if (bl) {
            return NUMBER.toBytes(1L);
        }
        return NUMBER.toBytes(0L);
    }

    public static double toDouble(byte[] byArray) {
        if (NUMBER._isZero(byArray)) {
            return 0.0;
        }
        if (NUMBER._isPosInf(byArray)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NUMBER._isNegInf(byArray)) {
            return Double.NEGATIVE_INFINITY;
        }
        String string = null;
        try {
            string = drvType == null ? _slnxlib.lnxnuc(byArray, DBL_MAX, null) : _slnxlib.lnxnuc(byArray, DBL_MAX, LANGID);
        }
        catch (Exception exception) {}
        double d2 = Double.valueOf(string);
        return d2;
    }

    public static float toFloat(byte[] byArray) {
        return (float)NUMBER.toDouble(byArray);
    }

    public String toFormattedText(String string, String string2) throws SQLException {
        return NUMBER._getLnxLib().lnxnfn(this.shareBytes(), string, string2);
    }

    public static int toInt(byte[] byArray) throws SQLException {
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        String string = drvType == null ? _slnxlib.lnxnuc(byArray, INT_MAX, null) : _slnxlib.lnxnuc(byArray, INT_MAX, LANGID);
        double d2 = Double.valueOf(string);
        if ((float)d2 > FLOAT_MAX_INT || (float)d2 < FLOAT_MIN_INT) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (d2 > DOUBLE_MAX_INT && d2 <= DOUBLE_MAX_INT_2) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (d2 < DOUBLE_MIN_INT && d2 >= DOUBLE_MIN_INT_2) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int n2 = (int)d2;
        return n2;
    }

    public Object toJdbc() throws SQLException {
        try {
            return this.bigDecimalValue();
        }
        catch (SQLException sQLException) {
            return new SQLException(sQLException.getMessage());
        }
    }

    public static long toLong(byte[] byArray) throws SQLException {
        if (NUMBER._isZero(byArray)) {
            return 0L;
        }
        if (NUMBER._isInf(byArray) || Datum.compareBytes(byArray, MAX_LONG) > 0 || Datum.compareBytes(byArray, MIN_LONG) < 0) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return NUMBER._getLnxLib().lnxsni(byArray);
    }

    public static short toShort(byte[] byArray) throws SQLException {
        long l2 = 0L;
        l2 = NUMBER.toLong(byArray);
        if (l2 > 32767L || l2 < -32768L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (short)l2;
    }

    public static String toString(byte[] byArray) {
        int n2;
        int n3 = 0;
        if (NUMBER._isZero(byArray)) {
            return new String("0");
        }
        if (NUMBER._isPosInf(byArray)) {
            return new Double(Double.POSITIVE_INFINITY).toString();
        }
        if (NUMBER._isNegInf(byArray)) {
            return new Double(Double.NEGATIVE_INFINITY).toString();
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n4 = byArray2[0];
        int n5 = n4 - ((n2 = byArray2.length - 1) - 1);
        int n6 = n5 >= 0 ? 2 * (n4 + 1) + 1 : (n4 >= 0 ? 2 * (n2 + 1) : 2 * (n2 - n4) + 3);
        char[] cArray = new char[n6];
        if (!NUMBER._isPositive(byArray)) {
            cArray[n3++] = 45;
        }
        if (n5 >= 0) {
            n3 += NUMBER._byteToChars(byArray2[1], cArray, n3);
            int n7 = 2;
            while (n7 <= n2) {
                NUMBER._byteTo2Chars(byArray2[n7], cArray, n3);
                n3 += 2;
                ++n7;
                --n4;
            }
            if (n4 > 0) {
                while (n4 > 0) {
                    cArray[n3++] = 48;
                    cArray[n3++] = 48;
                    --n4;
                }
            }
        } else {
            int n8 = n2 + n5;
            if (n8 > 0) {
                n3 += NUMBER._byteToChars(byArray2[1], cArray, n3);
                if (n8 == 1) {
                    cArray[n3++] = 46;
                }
                int n9 = 2;
                while (n9 < n2) {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n3);
                    n3 += 2;
                    if (n8 == n9) {
                        cArray[n3++] = 46;
                    }
                    ++n9;
                }
                if (byArray2[n9] % 10 == 0) {
                    n3 += NUMBER._byteToChars((byte)(byArray2[n9] / 10), cArray, n3);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n3);
                    n3 += 2;
                }
            } else {
                cArray[n3++] = 48;
                cArray[n3++] = 46;
                while (n8 < 0) {
                    cArray[n3++] = 48;
                    cArray[n3++] = 48;
                    ++n8;
                }
                int n10 = 1;
                while (n10 < n2) {
                    NUMBER._byteTo2Chars(byArray2[n10], cArray, n3);
                    n3 += 2;
                    ++n10;
                }
                if (byArray2[n10] % 10 == 0) {
                    n3 += NUMBER._byteToChars((byte)(byArray2[n10] / 10), cArray, n3);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n10], cArray, n3);
                    n3 += 2;
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public String toText(int n2, String string) throws SQLException {
        return NUMBER._getLnxLib().lnxnuc(this.shareBytes(), n2, string);
    }

    public NUMBER truncate(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtru(this.shareBytes(), n2));
    }

    public static NUMBER zero() {
        return new NUMBER(NUMBER._makeZero());
    }
}

