/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLDecodeReader;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTDBuilder;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.QxNameHash;
import org.xml.sax.SAXException;

public class BinXMLInfosetReader
extends BinXMLDecodeReader
implements InfosetReader,
BinXMLConstants {
    DTDBuilder builder;
    boolean dtd = false;

    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl) throws BinXMLException {
        super(binXMLStreamImpl, binXMLDecoderImpl);
    }

    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl) throws BinXMLException {
        super(binXMLStreamImpl, null);
    }

    String getStreamURI() {
        return this.binStream.getStreamURI();
    }

    public InfosetReader.Offset getOffset() {
        short s;
        BinXMLDecodeReader.DecodeElem decodeElem;
        Locator locator = null;
        if (this.event == 4 || this.elemStack.size() < 2) {
            decodeElem = this.elemStack.peek();
            if (this.state == 3) {
                decodeElem = this.elemStack.get(this.elemStack.size() - 2);
                s = decodeElem.isArrMode() ? (short)6 : (decodeElem.isSeqMode() ? (short)7 : 8);
            } else if (this.prevSibling != null) {
                switch (decodeElem.flags & 0xF) {
                    case 0: {
                        s = 9;
                        break;
                    }
                    case 2: {
                        s = 10;
                        break;
                    }
                    default: {
                        s = decodeElem.flags;
                        break;
                    }
                }
            } else {
                s = decodeElem.flags;
            }
        } else {
            decodeElem = this.elemStack.get(this.elemStack.size() - 2);
            s = decodeElem.flags;
        }
        switch (s & 0xF) {
            case 0: {
                locator = new Locator(s, this.eventMark);
                break;
            }
            case 1: {
                locator = new LocatorArray(s, this.eventMark, this.curElem.id, this.curElem.pfxid);
                break;
            }
            case 2: {
                long l;
                if (decodeElem.typeid != 0) {
                    s = (short)(s | 0x10);
                    l = decodeElem.typeid;
                } else {
                    l = decodeElem.id;
                }
                locator = new LocatorSchema(s, this.eventMark, l, this.oldKidnum, (byte)this.getSchemaId(this.schema));
                break;
            }
            case 3: {
                long l;
                if (decodeElem.typeid != 0) {
                    s = (short)(s | 0x10);
                    l = decodeElem.typeid;
                } else {
                    l = decodeElem.id;
                }
                locator = new LocatorArraySchema(s, this.eventMark, this.curElem.id, this.curElem.pfxid, l, this.oldKidnum, (byte)this.getSchemaId(this.schema));
                break;
            }
            case 6: {
                locator = new LocatorArray(s, this.eventMark, this.curElem.id, this.curElem.pfxid);
                break;
            }
            case 7: {
                long l;
                if (decodeElem.typeid != 0) {
                    s = (short)(s | 0x10);
                    l = decodeElem.typeid;
                } else {
                    l = decodeElem.id;
                }
                locator = new LocatorSchema(s, this.eventMark, l, this.oldKidnum, (byte)this.getSchemaId(this.schema));
                break;
            }
            case 8: {
                locator = new Locator(s, this.eventMark);
                break;
            }
            case 9: {
                locator = new LocatorArray(s, this.eventMark, this.curElem.id, this.curElem.pfxid);
                break;
            }
            case 10: {
                long l;
                if (decodeElem.typeid != 0) {
                    s = (short)(s | 0x10);
                    l = decodeElem.typeid;
                } else {
                    l = decodeElem.id;
                }
                locator = new LocatorArraySchema(s, this.eventMark, this.curElem.id, this.curElem.pfxid, l, this.oldKidnum, (byte)this.getSchemaId(this.schema));
            }
        }
        if (this.schema != null) {
            locator.schid = (byte)this.getSchemaId(this.schema);
        }
        if (decodeElem.streamId != this.curStream.id && this.state != 3) {
            locator.streamId = decodeElem.streamId;
            locator.flags = (short)(locator.flags | 4);
        }
        if (this.printLocator) {
            System.out.print("getOffset - ");
            locator.print();
        }
        return locator;
    }

    public void seek(InfosetReader.Offset offset) {
        BinXMLDecodeReader.PrefixInfo prefixInfo = null;
        Locator locator = (Locator)offset;
        if (locator == null) {
            return;
        }
        if (this.printLocator) {
            System.out.print("seek - ");
            locator.print();
        }
        try {
            this.resetSimple();
            if (locator.schid >= 0) {
                this.schema = this.getSchema(locator.schid);
                this.pushSchema(this.schema);
            }
            switch (locator.flags & 0xF) {
                case 0: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    this.curElem = this.elemStack.getNew();
                    this.curElem.pfxid = 0;
                    this.pushElem(this.curElem);
                    break;
                }
                case 1: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArray locatorArray = (LocatorArray)locator;
                    BinXMLDecodeReader.DecodeElem decodeElem = this.elemStack.getNew();
                    decodeElem.setArrMode(true);
                    this.pushElem(decodeElem);
                    this.curElem = this.getDecodeElem(locatorArray.qnameid);
                    this.curElem.pfxid = locatorArray.pfxid;
                    if (locatorArray.pfxid != 0) {
                        this.curElem.setPrefix(this.getPrefix(locatorArray.pfxid));
                        break;
                    }
                    this.curElem.setPrefix(null);
                    break;
                }
                case 2: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorSchema locatorSchema = (LocatorSchema)locator;
                    this.curElem = (locator.flags & 0x10) > 0 ? this.getDecodeElemByTypeId((int)locatorSchema.propid) : this.getDecodeElem(locatorSchema.propid);
                    this.curElem.setPrefix(null);
                    this.curElem.kidnum = locatorSchema.kidnum;
                    this.curElem.setSeqMode(true);
                    this.curElem.pfxid = 0;
                    this.pushElem(this.curElem);
                    BinXMLDecodeReader.DecodeElem decodeElem = this.curElem;
                    break;
                }
                case 3: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArraySchema locatorArraySchema = (LocatorArraySchema)locator;
                    BinXMLDecodeReader.DecodeElem decodeElem = (locator.flags & 0x10) > 0 ? this.getDecodeElemByTypeId((int)locatorArraySchema.propid) : this.getDecodeElem(locatorArraySchema.propid);
                    decodeElem.setPrefix(null);
                    decodeElem.kidnum = locatorArraySchema.kidnum;
                    decodeElem.setArrMode(true);
                    decodeElem.setSeqMode(true);
                    this.pushElem(decodeElem);
                    this.curElem = this.getDecodeElem(locatorArraySchema.qnameid);
                    this.curElem.pfxid = locatorArraySchema.pfxid;
                    if (locatorArraySchema.pfxid != 0) {
                        this.curElem.setPrefix(this.getPrefix(locatorArraySchema.pfxid));
                        break;
                    }
                    this.curElem.setPrefix(null);
                    break;
                }
                case 4: {
                    this.pushStreamParentMark(locator.streamId, locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    this.curElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(this.curElem);
                    this.pushStreamMark(locator.mark);
                    if (this.curStream.locator == null) break;
                    String[] stringArray = this.curStream.locator.split(",");
                    switch (stringArray[0].charAt(0)) {
                        case 'A': {
                            this.locId = Long.parseLong(stringArray[2]);
                            this.curElem.setArrMode(true);
                            break;
                        }
                        case 'S': {
                            this.vocabId.setVocabID(stringArray[3].getBytes());
                            this.schema = this.vocabMngr.getBinXMLSchema(this.vocabId);
                            this.addSchema(this.schema);
                            this.pushSchema(this.schema);
                            this.locId = Long.parseLong(stringArray[2]);
                            break;
                        }
                        case 'T': {
                            this.locId = 1L;
                            break;
                        }
                        case 'E': {
                            this.locId = 0L;
                        }
                    }
                    break;
                }
                case 6: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArray locatorArray = (LocatorArray)locator;
                    BinXMLDecodeReader.DecodeElem decodeElem = this.elemStack.getNew();
                    decodeElem.setArrMode(true);
                    this.pushElem(decodeElem);
                    this.curElem = this.getDecodeElem(locatorArray.qnameid);
                    this.curElem.pfxid = locatorArray.pfxid;
                    if (locatorArray.pfxid != 0) {
                        this.curElem.setPrefix(this.getPrefix(locatorArray.pfxid));
                    } else {
                        this.curElem.setPrefix(null);
                    }
                    this.getNext();
                    break;
                }
                case 7: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorSchema locatorSchema = (LocatorSchema)locator;
                    this.curElem = (locator.flags & 0x10) > 0 ? this.getDecodeElemByTypeId((int)locatorSchema.propid) : this.getDecodeElem(locatorSchema.propid);
                    this.curElem.setPrefix(null);
                    this.curElem.setSeqMode(true);
                    this.curElem.kidnum = locatorSchema.kidnum;
                    this.curElem.pfxid = 0;
                    this.pushElem(this.curElem);
                    BinXMLDecodeReader.DecodeElem decodeElem = this.curElem;
                    this.getNext();
                    break;
                }
                case 8: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(decodeElem);
                    this.getNext();
                    break;
                }
                case 9: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArray locatorArray = (LocatorArray)locator;
                    BinXMLDecodeReader.DecodeElem decodeElem = this.elemStack.getNew();
                    this.pushElem(decodeElem);
                    this.curElem = this.getDecodeElem(locatorArray.qnameid);
                    this.curElem.pfxid = locatorArray.pfxid;
                    if (locatorArray.pfxid != 0) {
                        this.curElem.setPrefix(this.getPrefix(locatorArray.pfxid));
                    } else {
                        this.curElem.setPrefix(null);
                    }
                    this.prevSibling = this.curElem;
                    break;
                }
                case 10: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArraySchema locatorArraySchema = (LocatorArraySchema)locator;
                    BinXMLDecodeReader.DecodeElem decodeElem = (locator.flags & 0x10) > 0 ? this.getDecodeElemByTypeId((int)locatorArraySchema.propid) : this.getDecodeElem(locatorArraySchema.propid);
                    decodeElem.kidnum = locatorArraySchema.kidnum;
                    decodeElem.setSeqMode(true);
                    this.pushElem(decodeElem);
                    this.curElem = this.getDecodeElem(locatorArraySchema.qnameid);
                    this.curElem.pfxid = locatorArraySchema.pfxid;
                    if (locatorArraySchema.pfxid != 0) {
                        this.curElem.setPrefix(this.getPrefix(locatorArraySchema.pfxid));
                    } else {
                        this.curElem.setPrefix(null);
                    }
                    this.prevSibling = this.curElem;
                    break;
                }
                default: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(decodeElem);
                }
            }
            this.mark = locator.mark;
            if (prefixInfo != null) {
                this.pushNamespace(prefixInfo);
            }
            this.event = this.getNextEvent();
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
    }

    public boolean hasNext() {
        boolean bl = true;
        if (this.event == 8 || this.state == 3) {
            bl = false;
        }
        try {
            short s = this.nextByte();
            if (s == 216) {
                s = this.nextByte2();
            }
            if (s == 217 || s == 160) {
                bl = false;
            }
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
        return bl;
    }

    public void next() {
        try {
            if (this.event == 100) {
                this.buildDTD();
            }
            this.event = this.getNextEvent();
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
    }

    DTD buildDTD() {
        if (this.event == 100) {
            try {
                if (this.builder == null) {
                    this.builder = new DTDBuilder();
                }
                while (true) {
                    switch (this.event) {
                        case 100: {
                            if (this.dtd) break;
                            this.builder.startDTD(this.dtdName, this.publicId, this.systemId);
                            break;
                        }
                        case 101: {
                            if (this.dtd) break;
                            this.builder.elementDecl(this.elemName, this.contentSpec);
                            break;
                        }
                        case 102: {
                            if (this.dtd) break;
                            this.builder.attributeDecl(this.elemName, this.attrName, this.attrType, this.attrMode, this.value);
                            break;
                        }
                        case 103: {
                            if (this.dtd) break;
                            this.builder.internalEntityDecl(this.entName, this.value);
                            break;
                        }
                        case 104: {
                            if (this.dtd) break;
                            this.builder.unparsedEntityDecl(this.entName, this.publicId, this.systemId, this.notName);
                            break;
                        }
                        case 105: {
                            if (this.dtd) break;
                            this.builder.externalEntityDecl(this.entName, this.publicId, this.systemId);
                            break;
                        }
                        case 106: {
                            break;
                        }
                        case 107: {
                            if (this.dtd) break;
                            this.builder.notationDecl(this.notName, this.publicId, this.systemId);
                            break;
                        }
                        case 108: {
                            if (!this.dtd) {
                                this.builder.endDTD();
                            }
                            this.dtd = true;
                            return this.builder.getDoctype();
                        }
                        default: {
                            throw new RuntimeException(this.err.getMessage0(35008));
                        }
                    }
                    this.event = this.getNextEvent();
                }
            }
            catch (BinXMLException binXMLException) {
                System.out.println(binXMLException.getMessage());
            }
            catch (SAXException sAXException) {
                System.out.println(sAXException.getMessage());
            }
        }
        return null;
    }

    public void skip() {
        try {
            this.skipNode();
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
    }

    public int getEventType() {
        if (this.event == 100 || this.event == 108) {
            return 11;
        }
        return this.event;
    }

    public QName getQName() {
        switch (this.event) {
            case 3: {
                return QxNameHash.create("", this.piTarget, "");
            }
            case 1: 
            case 2: {
                return QxNameHash.create(this.curElem.getURI(), this.curElem.getLocal(), this.curElem.getPrefix());
            }
        }
        return QxNameHash.create("", "", "");
    }

    public String getNamespaceURI(String string) {
        return this.curElem.getURI();
    }

    public String getPrefix(String string) {
        return this.curElem.getPrefix();
    }

    public TypedAttributes getAttributes() {
        return this.attrlist;
    }

    public String getAttribute(QName qName) {
        return null;
    }

    public String getValue() {
        try {
            switch (this.event) {
                case 4: {
                    return this.getEventText();
                }
                case 3: 
                case 5: 
                case 12: {
                    return this.value;
                }
            }
            return null;
        }
        catch (BinXMLException binXMLException) {
            return null;
        }
    }

    public char[] getData() {
        try {
            switch (this.event) {
                case 4: {
                    return this.getEventChars();
                }
                case 3: 
                case 5: 
                case 12: {
                    return this.value.toCharArray();
                }
            }
            return null;
        }
        catch (BinXMLException binXMLException) {
            return null;
        }
    }

    public int getDataStart() {
        return 0;
    }

    public int getDataLength() {
        switch (this.event) {
            case 3: 
            case 5: 
            case 12: {
                return this.value.length();
            }
        }
        return (int)this.datalen;
    }

    public boolean isNSResolutionSupported() {
        return false;
    }

    public boolean isSeekSupported() {
        return true;
    }

    public byte offsetToBytes(InfosetReader.Offset offset, byte[] byArray, int n) {
        return 0;
    }

    public InfosetReader.Offset offsetFromBytes(byte[] byArray, int n) {
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public DTD getDoctype() {
        if (this.event == 100) {
            this.buildDTD();
        }
        if (this.dtd) {
            return this.builder.getDoctype();
        }
        return null;
    }

    public QName getTypeName() {
        return null;
    }

    public int getPrimitiveTypeId() {
        return 0;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    public int getEventFlags() {
        return 0;
    }

    public void close() {
    }

    public Object clone() {
        return this.getReader();
    }

    public String getLocator() {
        return this.getlocator();
    }

    protected class LocatorArraySchema
    extends Locator {
        long qnameid;
        short pfxid;
        long propid;
        short kidnum;
        byte schid;

        LocatorArraySchema(short s, int n, long l, short s2, long l2, short s3, byte by) {
            super(s, n);
            this.qnameid = l;
            this.pfxid = s2;
            this.propid = l2;
            this.kidnum = s3;
            this.schid = by;
        }

        public void print() {
            System.out.println("LocatorArraySchema(" + this.flags + ", " + this.pfxid + ":" + this.qnameid + ") at " + this.mark);
        }
    }

    protected class LocatorSchema
    extends Locator {
        long propid;
        short kidnum;

        LocatorSchema(short s, int n, long l, short s2, byte by) {
            super(s, n);
            this.propid = l;
            this.kidnum = s2;
            this.schid = by;
        }

        public String toString() {
            long l = 1L - this.propid;
            String string = new Long(l).toString();
            BinXMLSchema binXMLSchema = BinXMLInfosetReader.this.getSchema(this.schid);
            BinXMLVocabId binXMLVocabId = binXMLSchema.getSchemaId();
            String string2 = new String(binXMLVocabId.getVocabID(), 0, 16);
            return new String("A," + this.mark + "," + string + "," + string2);
        }

        public void print() {
            System.out.println("LocatorSchema(" + this.flags + ", " + this.propid + ") at " + this.mark);
        }
    }

    protected class LocatorArray
    extends Locator {
        long qnameid;
        short pfxid;

        LocatorArray(short s, int n, long l, short s2) {
            super(s, n);
            this.qnameid = l;
            this.pfxid = s2;
        }

        public String toString() {
            String string = new Long(this.qnameid).toString();
            return new String("A," + this.mark + "," + string);
        }

        public void print() {
            System.out.println("LocatorArray(" + this.flags + ", " + this.pfxid + ":" + this.qnameid + ") at " + this.mark);
        }
    }

    protected class Locator
    implements InfosetReader.Offset {
        short flags;
        int mark;
        byte schid;
        byte streamId = (byte)-1;

        Locator(short s, int n) {
            this.flags = s;
            this.mark = n;
            this.schid = (byte)-1;
        }

        public int compareTo(Object object) {
            Locator locator = (Locator)object;
            return this.mark == locator.mark ? 0 : (this.mark < locator.mark ? -1 : 1);
        }

        public String toString() {
            if ((this.flags & 0xF) == 8) {
                return new String("T," + this.mark);
            }
            return new String("E," + this.mark);
        }

        public void print() {
            System.out.println("Locator(" + this.flags + ") at " + this.mark);
        }
    }
}

