/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action;

import com.tandbergtv.watchpoint.cms.action.ActionException;
import com.tandbergtv.watchpoint.cms.util.ArchiveUtility;
import java.io.File;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ExtractArchiveAction
implements ActionHandler {
    private static final long serialVersionUID = 588772173852715206L;
    protected String archivePath;
    protected String targetFolderPath;

    public void execute(ExecutionContext executionContext) throws Exception {
        this.extractArchive(executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractArchive(ExecutionContext context) throws ActionException {
        this.prepareForExtract(context);
        de.schlichtherle.io.File archiveFile = null;
        try {
            archiveFile = ArchiveUtility.openArchive(this.archivePath);
            de.schlichtherle.io.File targetFolder = new de.schlichtherle.io.File(this.targetFolderPath);
            this.performPreExtractTasks(context, archiveFile, targetFolder);
            if (!archiveFile.copyAllTo((File)targetFolder)) {
                String message = "Failed to extract contents of archive file: " + archiveFile + " to location: " + targetFolder;
                throw new ActionException(message);
            }
            this.performPostExtractTasks(context, archiveFile, targetFolder);
        }
        finally {
            if (archiveFile != null) {
                ArchiveUtility.closeArchive(archiveFile);
            }
        }
    }

    protected void prepareForExtract(ExecutionContext context) throws ActionException {
    }

    protected void performPreExtractTasks(ExecutionContext context, de.schlichtherle.io.File archiveFile, de.schlichtherle.io.File targetFolder) throws ActionException {
    }

    protected void performPostExtractTasks(ExecutionContext context, de.schlichtherle.io.File archiveFile, de.schlichtherle.io.File targetFolder) throws ActionException {
    }
}

