/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.action.ActionException;
import com.tandbergtv.watchpoint.cms.util.DateUtility;
import com.tandbergtv.watchpoint.cms.util.FilePermissionUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import java.util.Date;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class MakeOriginalFilesDirectory
implements ActionHandler {
    private static final String FOLDER_DATE_FORMAT = "folder.date.format";
    private static final long serialVersionUID = -5933623971869147450L;

    public void execute(ExecutionContext context) throws Exception {
        String originalFileDirName;
        String filePath = this.getStringValue(context, "filePath");
        File file = new File(filePath);
        String providerId = this.getStringValue(context, "providerId");
        String providerPath = PathProperties.getProviderPath(providerId);
        String date = DateUtility.formatDate(new Date(), FOLDER_DATE_FORMAT);
        String assetPath = PathProperties.getProperty("provider.original.asset");
        String originalAssetDirPath = providerPath + File.separator + date + File.separator + assetPath;
        File originalAssetDir = new File(originalAssetDirPath);
        File originalFileDir = new File(originalAssetDir, originalFileDirName = file.getName() + "_" + System.currentTimeMillis());
        if (!originalFileDir.mkdirs()) {
            throw new ActionException("Unable to create directory: " + originalFileDir);
        }
        FilePermissionUtility.setPermissions(originalFileDir);
        context.setVariable("extractFilePath", (Object)originalFileDir.getAbsolutePath());
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

