/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ReadMetadata
implements ActionHandler {
    private static final String ORIGINAL = "ORIGINAL";
    private static final long serialVersionUID = 6510675565655967893L;
    private static final Logger logger = Logger.getLogger(ReadMetadata.class);
    private static final String MATCHING_FILE_ASSET_ID_PART1_XPATH = "//*[local-name()='Item'][*[local-name()='Fields']/*[local-name()='TTVId']/*[local-name()='Id']='";
    private static final String MATCHING_FILE_ASSET_ID_PART2_XPATH = "']/*[local-name()='Relation']/*[local-name()='Target']/*[local-name()='Id']";
    private static final String MATCHING_FILE_TYPE_PART1_XPATH = "//*[local-name()='Fields'][*[local-name()='TTVId']/*[local-name()='Id']='";
    private static final String MATCHING_FILE_TYPE_PART2_XPATH = "']/*[local-name()='Locator']/*[local-name()='Description']/*[local-name()='Text']";

    public void execute(ExecutionContext context) throws Exception {
        String fileName = this.getStringValue(context, "outputMetadataFilePath");
        logger.debug((Object)("outputMetadataFilePathInternalSpec=" + fileName));
        Document doc = this.getDocument(fileName, context);
        String commaSeparatedLongAssetIds = this.getStringValue(context, "mappedAssets");
        List<String> assetIdList = this.convertCommaSepListtoList(commaSeparatedLongAssetIds);
        String fileAssetIds = "";
        boolean firstTime = true;
        block0: for (String assetId : assetIdList) {
            String xpathFileAssetId = MATCHING_FILE_ASSET_ID_PART1_XPATH + assetId + MATCHING_FILE_ASSET_ID_PART2_XPATH;
            NodeList matchingFileAssetIdNodes = this.getNodes(xpathFileAssetId, doc);
            if (matchingFileAssetIdNodes == null) continue;
            for (int i = 0; i < matchingFileAssetIdNodes.getLength(); ++i) {
                String fileAssetId = matchingFileAssetIdNodes.item(i).getTextContent();
                String xpathFileType = MATCHING_FILE_TYPE_PART1_XPATH + fileAssetId + MATCHING_FILE_TYPE_PART2_XPATH;
                NodeList matchingFileType = this.getNodes(xpathFileType, doc);
                if (matchingFileType == null || !matchingFileType.item(0).getTextContent().equals(ORIGINAL)) continue;
                if (firstTime) {
                    fileAssetIds = fileAssetId;
                    firstTime = false;
                    continue block0;
                }
                fileAssetIds = fileAssetIds + "," + fileAssetId;
                continue block0;
            }
        }
        context.setVariable("fileAssetIds", (Object)fileAssetIds);
        logger.debug((Object)("fileAssetIds=" + fileAssetIds));
    }

    private NodeList getNodes(String xpathStr, Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
        return nodes;
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }

    private Document getDocument(String path, ExecutionContext context) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            return docBuilder.parse(new File(path));
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to read file: " + path + " - " + e.getMessage();
            context.setVariable("error-message", (Object)msg);
            throw new RuntimeException(msg, e);
        }
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }
}

