/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.processing;

import com.tandbergtv.watchpoint.cms.util.DateUtility;
import com.tandbergtv.watchpoint.cms.util.FilePermissionUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ReadMetadata
implements ActionHandler {
    private static final long serialVersionUID = 6510675565655967893L;
    private static final Logger logger = Logger.getLogger(ReadMetadata.class);
    public static String ASSET_PROCESSING_PROPERTIES = "/cms-template-actions/contentProcessing.properties";
    private static final String TITLE_BRIEF_XPATH = "//*[local-name()='Fields']/*[local-name()='Title']/*[local-name()='ShortTitle']";
    private static final String PROVIDER_ID_XPATH = "//*[local-name()='Group']/*[local-name()='Fields']/*[local-name()='ProviderInfo']/*[local-name()='Identifier']/*[local-name()='Id']";
    private static final String ASSET_ID_SPEC_XPATH = "//*[local-name()='Fields']/*[local-name()='Identifier']/*[local-name()='Id']";
    private static final String GROUP_ASSET_ID_SPEC_XPATH = "//*[local-name()='Group'][@type='PACKAGE']/*[local-name()='Fields']/*[local-name()='TTVId']/*[local-name()='Id']";
    public static final String LICENSING_WINDOW_START_XPATH = "//*[local-name()='Fields']/*[local-name()='Rights']/*[local-name()='LicensingWindowStart']";
    public static final String LICENSING_WINDOW_END_XPATH = "//*[local-name()='Fields']/*[local-name()='Rights']/*[local-name()='LicensingWindowEnd']";
    private static final String MATCHING_ID_LONG_PART1_XPATH = "//*[local-name()='Fields'][*[local-name()='Identifier']/*[local-name()='Id']='";
    private static final String MATCHING_ID_LONG_PART2_XPATH = "']/*[local-name()='TTVId']/*[local-name()='Id']";
    private static final String MOVIE_ASSET_ID_XPATH = "//*[local-name()='Group' or local-name()='Item'][@type='MOVIE']/*[local-name()='Fields']/*[local-name()='TTVId']/*[local-name()='Id']";
    private static final String PACKAGE_NAME_XPATH = "//*[local-name()='Group'][@type='PACKAGE']/*[local-name()='Fields']/*[local-name()='AssetName']";
    private static final String ASSET_ID_CL_XPATH = "//Asset/Asset/Metadata/AMS";
    private static final String ASSET_ID_CL = "Asset_ID";
    private static final String MOVIE_REENCODE_REQUIRED_XPATH = "//*[local-name()='Item' or local-name()='Group'][@type='MOVIE']/*[local-name()='Fields']/*[local-name()='CustomFields']/*[local-name()='CustomField'][@name='Reencode']";
    private static final String MOVIE_REENCODE_PROFILE_XPATH = "//*[local-name()='Item' or local-name()='Group'][@type='MOVIE']/*[local-name()='Fields']/*[local-name()='CustomFields']/*[local-name()='CustomField'][@name='ReencodeProfile']";
    private static final String MOVIE_TRANSCODE_REQUIRED_XPATH = "//*[local-name()='Item' or local-name()='Group'][@type='MOVIE']/*[local-name()='Fields']/*[local-name()='CustomFields']/*[local-name()='CustomField'][@name='Transcode']";
    private static final String MOVIE_TRANSCODE_FORMAT_XPATH = "//*[local-name()='Item' or local-name()='Group'][@type='MOVIE']/*[local-name()='Fields']/*[local-name()='CustomFields']/*[local-name()='CustomField'][@name='TranscodeFormat']";
    private static final String MOVIE_TRANSCODE_PROFILE_XPATH = "//*[local-name()='Item' or local-name()='Group'][@type='MOVIE']/*[local-name()='Fields']/*[local-name()='CustomFields']/*[local-name()='CustomField'][@name='TranscodeProfile']";
    private static final String ARCHIVE_TYPE_XPATH = "//*[local-name()='CustomField'][@name='ArchiveType']";
    private static final String FOLDER_DATE_FORMAT = "folder.date.format";

    public void execute(ExecutionContext context) throws Exception {
        String outputMetadataFileName;
        String fileName = this.getStringValue(context, "outputMetadataFilePathOutputSpec");
        logger.debug((Object)("outputMetadataFilePathOutputSpec=" + fileName));
        Document doc = this.getDocument(fileName, context);
        ArrayList<String> assetIdsCL = new ArrayList<String>();
        NodeList assetIdnodesCL = this.getNodes(ASSET_ID_CL_XPATH, doc);
        for (int i = 0; i < assetIdnodesCL.getLength(); ++i) {
            assetIdsCL.add(assetIdnodesCL.item(i).getAttributes().getNamedItem(ASSET_ID_CL).getTextContent());
        }
        logger.debug((Object)("assetIdsCL=" + assetIdsCL));
        fileName = this.getStringValue(context, "outputMetadataFilePathInternalSpec");
        logger.debug((Object)("outputMetadataFilePathInternalSpec=" + fileName));
        doc = this.getDocument(fileName, context);
        String commaSeparatedLongAssetIds = "";
        NodeList nodes = this.getNodes(ASSET_ID_SPEC_XPATH, doc);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String assetId = nodes.item(i).getTextContent();
            if (!assetIdsCL.contains(assetId)) continue;
            String xpath = MATCHING_ID_LONG_PART1_XPATH + assetId + MATCHING_ID_LONG_PART2_XPATH;
            NodeList matchingNode = this.getNodes(xpath, doc);
            commaSeparatedLongAssetIds = commaSeparatedLongAssetIds + matchingNode.item(0).getTextContent() + ",";
        }
        if (commaSeparatedLongAssetIds.endsWith(",")) {
            int lastCommaIndex = commaSeparatedLongAssetIds.lastIndexOf(",");
            commaSeparatedLongAssetIds = commaSeparatedLongAssetIds.substring(0, lastCommaIndex);
        }
        context.setVariable("commaSeparatedLongAssetIds", (Object)commaSeparatedLongAssetIds);
        nodes = this.getNodes(TITLE_BRIEF_XPATH, doc);
        if (nodes != null && nodes.item(0) != null) {
            String titleBrief = nodes.item(0).getTextContent();
            context.setVariable("titleBrief", (Object)titleBrief);
        }
        if ((nodes = this.getNodes(LICENSING_WINDOW_START_XPATH, doc)) != null && nodes.item(0) != null) {
            String licStart = nodes.item(0).getTextContent();
            context.setVariable("licensingWindowStart", (Object)licStart);
        }
        if ((nodes = this.getNodes(LICENSING_WINDOW_END_XPATH, doc)) != null && nodes.item(0) != null) {
            String licEnd = nodes.item(0).getTextContent();
            context.setVariable("licensingWindowEnd", (Object)licEnd);
        }
        nodes = this.getNodes(PROVIDER_ID_XPATH, doc);
        String providerId = "";
        if (nodes != null && nodes.item(0) != null) {
            providerId = nodes.item(0).getTextContent();
            context.setVariable("providerId", (Object)providerId);
        }
        nodes = this.getNodes(PACKAGE_NAME_XPATH, doc);
        String packageName = "package";
        if (nodes != null && nodes.item(0) != null) {
            packageName = nodes.item(0).getTextContent();
            context.setVariable("packageName", (Object)packageName);
        }
        nodes = this.getNodes(GROUP_ASSET_ID_SPEC_XPATH, doc);
        String groupAssetId = "";
        if (nodes != null && nodes.item(0) != null) {
            groupAssetId = nodes.item(0).getTextContent();
            context.setVariable("groupAssetId", (Object)groupAssetId);
        }
        if ((nodes = this.getNodes(MOVIE_ASSET_ID_XPATH, doc)) != null && nodes.item(0) != null) {
            String movieAssetId = nodes.item(0).getTextContent();
            context.setVariable("movieAssetId", (Object)movieAssetId);
        }
        String reencodeRequired = "false";
        String reencodeProfile = "";
        nodes = this.getNodes(MOVIE_REENCODE_REQUIRED_XPATH, doc);
        if (nodes != null && nodes.item(0) != null) {
            NamedNodeMap map = nodes.item(0).getAttributes();
            reencodeRequired = map.getNamedItem("value").getTextContent();
            if (Boolean.parseBoolean(reencodeRequired) && (nodes = this.getNodes(MOVIE_REENCODE_PROFILE_XPATH, doc)) != null && nodes.item(0) != null) {
                map = nodes.item(0).getAttributes();
                reencodeProfile = map.getNamedItem("value").getTextContent();
            }
        } else {
            InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
            Properties config = new Properties();
            config.load(stream);
            reencodeRequired = config.getProperty("reencode.required");
            reencodeProfile = config.getProperty("reencode.profile");
        }
        context.setVariable("reencodeRequired", (Object)reencodeRequired);
        context.setVariable("reencodeProfile", (Object)reencodeProfile);
        String transcodeRequired = "false";
        String transcodeProfile = "";
        String transcodeFormat = "";
        nodes = this.getNodes(MOVIE_TRANSCODE_REQUIRED_XPATH, doc);
        if (nodes != null && nodes.item(0) != null) {
            NamedNodeMap map = nodes.item(0).getAttributes();
            transcodeRequired = map.getNamedItem("value").getTextContent();
            if (Boolean.parseBoolean(transcodeRequired)) {
                nodes = this.getNodes(MOVIE_TRANSCODE_PROFILE_XPATH, doc);
                if (nodes != null && nodes.item(0) != null) {
                    map = nodes.item(0).getAttributes();
                    transcodeProfile = map.getNamedItem("value").getTextContent();
                }
                if ((nodes = this.getNodes(MOVIE_TRANSCODE_FORMAT_XPATH, doc)) != null && nodes.item(0) != null) {
                    map = nodes.item(0).getAttributes();
                    transcodeFormat = map.getNamedItem("value").getTextContent();
                }
            }
        } else {
            InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
            Properties config = new Properties();
            config.load(stream);
            transcodeRequired = config.getProperty("transcode.required");
            transcodeProfile = config.getProperty("transcode.profile");
            transcodeFormat = config.getProperty("transcode.format");
        }
        context.setVariable("transcodeRequired", (Object)transcodeRequired);
        context.setVariable("transcodeProfile", (Object)transcodeProfile);
        context.setVariable("transcodeFormat", (Object)transcodeFormat);
        String titleID = this.getStringValue(context, "titleId");
        StringBuffer sb = this.getTitlesPath(providerId, titleID);
        sb.append(File.separator);
        sb.append(PathProperties.getProperty("title.processed.asset"));
        String destPath = sb.toString();
        File dest = new File(destPath);
        logger.debug((Object)("destPath=" + destPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        FilePermissionUtility.setPermissions(dest);
        context.setVariable("outputDirectory", (Object)destPath);
        long processId = context.getProcessInstance().getId();
        File srcFile = new File(this.getStringValue(context, "outputMetadataFilePathOutputSpec"));
        File destFile = new File(destPath, "ADI.XML");
        destFile.delete();
        if (srcFile.renameTo(destFile)) {
            context.setVariable("outputMetadataFilePathOutputSpec", (Object)destFile.getAbsolutePath());
        }
        if ((srcFile = new File(this.getStringValue(context, "outputMetadataFilePathInternalSpec"))).renameTo(destFile = new File(destPath, outputMetadataFileName = processId + "_TTV_METADATA.XML"))) {
            context.setVariable("outputMetadataFilePathInternalSpec", (Object)destFile.getAbsolutePath());
        }
        StringBuffer tarSB = this.getTitlesPath(providerId, titleID);
        tarSB.append(File.separator);
        tarSB.append(PathProperties.getProperty("title.processed.package"));
        String archiveExtension = ".";
        String archiveType = "";
        nodes = this.getNodes(ARCHIVE_TYPE_XPATH, doc);
        if (nodes != null && nodes.item(0) != null) {
            NamedNodeMap map = nodes.item(0).getAttributes();
            archiveType = map.getNamedItem("value").getTextContent();
        } else {
            InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
            Properties config = new Properties();
            config.load(stream);
            archiveType = config.getProperty("archive.type");
        }
        archiveExtension = archiveType != null && !archiveType.trim().equals("") ? archiveExtension + archiveType : archiveExtension + "tar";
        logger.debug((Object)("archiveExtension=" + archiveExtension + "."));
        String tarDestinationFolder = tarSB.toString();
        String tarDestinationFile = tarDestinationFolder + File.separator + processId + "_" + packageName + archiveExtension;
        File tarDest = new File(tarDestinationFolder);
        logger.debug((Object)("tarDestinationFolder=" + tarDestinationFolder));
        if (!tarDest.exists()) {
            tarDest.mkdirs();
        }
        FilePermissionUtility.setPermissions(tarDest);
        logger.debug((Object)("tarDestinationFile=" + tarDestinationFile));
        context.setVariable("tarDestination", (Object)tarDestinationFile);
        context.setVariable("tarFilepath", (Object)"tarFilepath");
    }

    private StringBuffer getTitlesPath(String providerID, String titleID) {
        StringBuffer sb = new StringBuffer();
        sb.append(PathProperties.getProperty("contentPath"));
        sb.append(File.separator);
        sb.append(providerID);
        sb.append(File.separator);
        sb.append(DateUtility.formatDate(new Date(), FOLDER_DATE_FORMAT));
        sb.append(File.separator);
        sb.append(PathProperties.getProperty("provider.processed.title"));
        sb.append(File.separator);
        sb.append(titleID);
        return sb;
    }

    private NodeList getNodes(String xpathStr, Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
        return nodes;
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }

    private Document getDocument(String path, ExecutionContext context) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            return docBuilder.parse(new File(path));
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to read file: " + path + " - " + e.getMessage();
            context.setVariable("error-message", (Object)msg);
            throw new RuntimeException(msg, e);
        }
    }
}

