/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.processing;

import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetVariables
implements ActionHandler {
    private static final long serialVersionUID = 6510671693435967893L;
    private static final Logger logger = Logger.getLogger(SetVariables.class);
    public static String ASSET_PROCESSING_PROPERTIES = "/cms-template-actions/contentProcessing.properties";

    public void execute(ExecutionContext context) throws Exception {
        InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
        Properties config = new Properties();
        config.load(stream);
        String internalSpec = config.getProperty("spec.internal.format");
        context.setVariable("internalSpec", (Object)internalSpec);
        String tempFolder = PathProperties.getProperty("tempContentPath");
        long processId = context.getProcessInstance().getId();
        String outputMetadataFileName = processId + "_TTV_METADATA.XML";
        String outputMetadataFilePathInternalSpec = tempFolder + File.separator + outputMetadataFileName;
        logger.debug((Object)("outputMetadataFilePathInternalSpec=" + outputMetadataFilePathInternalSpec));
        context.setVariable("outputMetadataFilePathInternalSpec", (Object)outputMetadataFilePathInternalSpec);
        String outputSpec = config.getProperty("spec.output.format");
        context.setVariable("outputSpec", (Object)outputSpec);
        String adiDtdFile = config.getProperty("adi.dtd.path");
        context.setVariable("adiDtdFile", (Object)adiDtdFile);
        outputMetadataFileName = processId + "_ADI.XML";
        String outputMetadataFilePathOutputSpec = tempFolder + File.separator + outputMetadataFileName;
        logger.debug((Object)("outputMetadataFilePathOutputSpec=" + outputMetadataFilePathOutputSpec));
        context.setVariable("outputMetadataFilePathOutputSpec", (Object)outputMetadataFilePathOutputSpec);
        long tokenId = context.getToken().getId();
        context.setVariable("sourceComponentName", (Object)"WatchPoint");
        context.setVariable("sourceEntityName", (Object)"Workflow");
        context.setVariable("sourceId", (Object)(Long.toString(processId) + "|" + Long.toString(tokenId)));
        context.setVariable("vodLookupKey", (Object)"VOD");
        context.setVariable("tarLookupKey", (Object)"VOD PACKAGE");
        context.setVariable("emptyString", (Object)"");
    }
}

