/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.processing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class UpdateLoopVariables
implements ActionHandler {
    private static final long serialVersionUID = 648575881288448034L;
    private static final Logger logger = Logger.getLogger(UpdateLoopVariables.class);

    public void execute(ExecutionContext context) throws Exception {
        List<Object> longAssetIdList = new ArrayList();
        String commaSeparatedLongAssedIds = this.getStringValue(context, "commaSeparatedLongAssetIds");
        if (commaSeparatedLongAssedIds != null) {
            longAssetIdList = this.convertCommaSepListtoList(commaSeparatedLongAssedIds);
        }
        int loopIndex = this.getIntegerValue(context, "loopIndex", -1) + 1;
        String assetId = (String)longAssetIdList.get(loopIndex);
        boolean hasMoreAssets = loopIndex + 1 < longAssetIdList.size();
        context.setVariable("loopAssetId", (Object)assetId);
        context.setVariable("hasMoreAssets", (Object)hasMoreAssets);
        context.setVariable("loopIndex", (Object)loopIndex);
        context.setVariable("assetIdCount", (Object)new Integer(longAssetIdList.size()));
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private int getIntegerValue(ExecutionContext context, String variableName, int defaultValue) {
        int intValue = defaultValue;
        Object value = context.getVariable(variableName);
        if (value == null) {
            intValue = defaultValue;
        } else if (value instanceof Integer) {
            intValue = (Integer)value;
        } else {
            try {
                intValue = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Failed to parse value: " + value + " to an integer when getting Asset Mapping Loop Index, " + "using default value: " + defaultValue), (Throwable)e);
            }
        }
        return intValue;
    }
}

