/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionPropertyReader;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class GetMetaDataInfoAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static String PARTNER_DELIMITER = ",";
    private static String SOURCE_PROVIDER_ID = "providerId";
    private static String EXTRACT_METADATA = "extractMetadata";
    private static final Logger logger = Logger.getLogger(GetMetaDataInfoAction.class);

    public void execute(ExecutionContext context) throws Exception {
        String[] providers;
        String providerId = (String)context.getVariable(SOURCE_PROVIDER_ID);
        String providerList = ConversionPropertyReader.getProperty(ConversionPropertyReader.PARTNERS_WITH_METADATA);
        if (providerList == null || providerList.trim().length() == 0) {
            logger.debug((Object)("Provider list not provided in conversion.properties, so assuming that there metadata need not be extracted for provider: " + providerId));
            context.setVariable(EXTRACT_METADATA, (Object)false);
        }
        if (this.contains(providers = providerList.split(PARTNER_DELIMITER), providerId)) {
            logger.debug((Object)"Setting 'extractMetadata' to true");
            context.setVariable(EXTRACT_METADATA, (Object)true);
        } else {
            logger.debug((Object)"Setting 'extractMetadata' to false");
            context.setVariable(EXTRACT_METADATA, (Object)false);
        }
    }

    private boolean contains(String[] providers, String providerId) {
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].equalsIgnoreCase(providerId)) continue;
            return true;
        }
        return false;
    }
}

